<?php
	
/*
-----------------------------------------
---------   All about this file   -------
-----------------------------------------

Your plans/general settings are customized using the settings area, Wizard Panel:

https://www.zomex.com/docs/whmcs-templates/wizard-panel/

This file contains all of the text of the template that isn't edited via Wizard Panel such as the company page text. The reason why text is edited in this file is it allows multi-language support and also ensures that all of the text is located in one place instead of being hardcoded in template files.

Each language has this same file allowing you to set different translations for each language. If you want to support 1 language only then you can ignore the other language files and edit only your default language set in WHMCS.

BEFORE YOU EDIT THIS FILE please read our guide below for full details:

https://www.zomex.com/docs/whmcs-templates/how-to-edit-text-in-the-template/

For more information about editing your template please refer to our full documentation below:

https://www.zomex.com/docs/whmcs-templates/

Feel free to contact Zomex if you run into any issues or have any questions.

------ Tips ------

- While it looks a bit intimidating initially, you do not need any prior coding experience to edit this file. After a bit of practise it's easy to edit. If you run into any problems you can contact Zomex support at anytime.

- Keep a backup of this file at all times, if you make a edit and it causes errors with your website replace this file with your backup to restore everything. As long as you have a backup you cannot go wrong. Making a backup of this file after every few edits is recommended.

- This file uses a PHP structure, ensure that the markup remains valid (no missing " ' ;) to avoid errors. If you experience an error you can use the following tool (paste the full contents of this file), it will highlight the line/section where the error is:

http://phpcodechecker.com/

- You can search this file for the page name to easily find the language text associated with it. E.g for the Company page search this file for "company.php" or "Company page".

- If you are only using 1 language you do not need to edit below the line: Multi-language support: on - Any text below that line is editable in Wizard Panel when multi-language set to off.

-----------------------------------------

*/






/*
-----------------------------------------
---------   Settings    ---------
-----------------------------------------
*/

$_LANG['freemium_setting_companyname'] = "Your Company"; # Defined here, used throughout the template
$_LANG['textdirection'] = "ltr"; # Set the text direction of the template (i.e ltr for English, rtl for Arabic)






/*
-----------------------------------------
---------   Pages - The page name and description text are used in various places of the template such as the menu & footer & subbanner. The content of each page is further down this file.     ---------
-----------------------------------------
*/

// Register Domain

$_LANG['freemium_registerdomain_name'] = "Register Domain";         
$_LANG['freemium_registerdomain_text'] = "Your very own website address";

// Transfer Domain

$_LANG['freemium_transferdomain_name'] = "Transfer Domain";         
$_LANG['freemium_transferdomain_text'] = "Move your domain to " . $_LANG['freemium_setting_companyname'];

//  Wizard Panel Service Pages (With quick setup turned off) - You can re-name any of the 10 default pages by following this guide: https://www.zomex.com/docs/whmcs-templates/how-to-change-hosting-page-type/

// Page 1 - Shared Hosting by default

$_LANG['freemium_custom1_name'] = "Shared Hosting";         
$_LANG['freemium_custom1_text'] = "Premium cPanel web hosting";

// MarketConnect pages - These pages are displayed if enabled within WHMCS: https://marketplace.whmcs.com/connect

// SSL Certificates

$_LANG['freemium_sslcertificates_name'] = "SSL Certificates";
$_LANG['freemium_sslcertificates_text'] = "Encrypt your website using https";

// VPN

$_LANG['freemium_vpn_name'] = "VPN";
$_LANG['freemium_vpn_text'] = "Protect your online identity and IP address";

// Website Builder

$_LANG['freemium_websitebuilder_name'] = "Website Builder";
$_LANG['freemium_websitebuilder_text'] = "An easy to create website builder tool";

// Website Backup

$_LANG['freemium_websitebackup_name'] = "Website Backup";
$_LANG['freemium_websitebackup_text'] = "Protect your website with frequent backups";

// Website Security

$_LANG['freemium_websitesecurity_name'] = "Website Security";
$_LANG['freemium_websitesecurity_text'] = "Keep your website safe &amp; secure";

// Email Security

$_LANG['freemium_emailsecurity_name'] = "Email Security";
$_LANG['freemium_emailsecurity_text'] = "Secure your incoming and outgoing email";

// SEO Tools

$_LANG['freemium_seotools_name'] = "SEO Tools";
$_LANG['freemium_seotools_text'] = "SEO report with optimization steps";

// Professional Email

$_LANG['freemium_professionalemail_name'] = "Professional Email";
$_LANG['freemium_professionalemail_text'] = "Powerful email and productivity";

// Site Builder

$_LANG['freemium_sitebuilder_name'] = "Site Builder";
$_LANG['freemium_sitebuilder_text'] = "Drag and drop DIY site builder";

// cPanel SEO

$_LANG['freemium_cpanelseo_name'] = "cPanel SEO";
$_LANG['freemium_cpanelseo_text'] = "SEO optimization from cPanel";

// Xovinow

$_LANG['freemium_xovinow_name'] = "XOVI NOW";
$_LANG['freemium_xovinow_text'] = "SEO optimization &amp; reporting";

// Nordvpn

$_LANG['freemium_nordvpn_name'] = "NordVPN";
$_LANG['freemium_nordvpn_text'] = "Protect your online privacy";

// 360Monitoring

$_LANG['freemium_360monitoring_name'] = "360Monitoring";
$_LANG['freemium_360monitoring_text'] = "Monitor your website";

// Company

$_LANG['freemium_company_name'] = "Company";         
$_LANG['freemium_company_text'] = "Learn more about " . $_LANG['freemium_setting_companyname'];

// Why Choose Us

$_LANG['freemium_whychooseus_name'] = "Why Choose Us";         
$_LANG['freemium_whychooseus_text'] = "The reasons why to choose us";

// Testimonials

$_LANG['freemium_testimonials_name'] = "Testimonials";         
$_LANG['freemium_testimonials_text'] = "Lots of feedback from our customer&#39;s";

// Announcements

$_LANG['freemium_announcements_name'] = "Announcements";         
$_LANG['freemium_announcements_text'] = "Get up to date with the latest news";

// Downloads

$_LANG['freemium_downloads_name'] = "Downloads";         
$_LANG['freemium_downloads_text'] = "View our collection of downloads";

// Addon pages - Displayed if you have the addons setting enabled under Wizard Panel > Pages

// Addons

$_LANG['freemium_addons_name'] = "Addons";

// WHMCS Templates

$_LANG['freemium_whmcstemplates_name'] = "WHMCS Templates";         
$_LANG['freemium_whmcstemplates_text'] = "The best web hosting templates";

// WordPress Themes

$_LANG['freemium_wordpressthemes_name'] = "WordPress Themes";         
$_LANG['freemium_wordpressthemes_text'] = "Feature-rich WordPress themes";

// HTML Templates

$_LANG['freemium_htmltemplates_name'] = "HTML Templates";         
$_LANG['freemium_htmltemplates_text'] = "Responsive HTML5 Templates";

// Blesta Templates

$_LANG['freemium_blestatemplates_name'] = "Blesta Templates";         
$_LANG['freemium_blestatemplates_text'] = "Blesta web hosting templates";

// Clientexec Templates

$_LANG['freemium_clientexectemplates_name'] = "Clientexec Templates";         
$_LANG['freemium_clientexectemplates_text'] = "Powerful templates for Clientexec";

// WISECP Templates

$_LANG['freemium_wisecptemplates_name'] = "WISECP Templates";         
$_LANG['freemium_wisecptemplates_text'] = "Powerful templates for WISECP";

// HostBill Templates

$_LANG['freemium_hostbilltemplates_name'] = "HostBill Templates";         
$_LANG['freemium_hostbilltemplates_text'] = "Powerful templates for HostBill";

// WHMCS Modules

$_LANG['freemium_whmcsmodules_name'] = "WHMCS Modules";         
$_LANG['freemium_whmcsmodules_text'] = "Enhance your WHMCS system";

// Scripts

$_LANG['freemium_scripts_name'] = "Scripts";         
$_LANG['freemium_scripts_text'] = "Menus, feature boxes &amp; tables";

// Logo Design

$_LANG['freemium_logodesign_name'] = "Logo Design";         
$_LANG['freemium_logodesign_text'] = "Custom vector logo design service";

// Banner Design

$_LANG['freemium_bannerdesign_name'] = "Banner Design";         
$_LANG['freemium_bannerdesign_text'] = "Custom animated banner design";

// WHMCS Services

$_LANG['freemium_whmcsservices_name'] = "WHMCS Services";         
$_LANG['freemium_whmcsservices_text'] = "Setup, configuration &amp; custom services";

// WordPress Services

$_LANG['freemium_wordpressservices_name'] = "WordPress Services";         
$_LANG['freemium_wordpressservices_text'] = "Installation, integration &amp; more";

// Blesta Services

$_LANG['freemium_blestaservices_name'] = "Blesta Services";         
$_LANG['freemium_blestaservices_text'] = "Installation, integration &amp; more";

// Clientexec Services

$_LANG['freemium_clientexecservices_name'] = "Clientexec Services";         
$_LANG['freemium_clientexecservices_text'] = "Installation, integration &amp; more";

// Portal

$_LANG['freemium_portal_name'] = "Support";

// Contact

$_LANG['freemium_contact_name'] = "Contact Form";         
$_LANG['freemium_contact_text'] = "Contact our pre-sales department";

// Submit Ticket

$_LANG['freemium_submitticket_name'] = "Submit Ticket";         
$_LANG['freemium_submitticket_text'] = "Contact our support via ticket";

// Knowledgebase

$_LANG['freemium_knowledgebase_name'] = "Knowledgebase";         
$_LANG['freemium_knowledgebase_text'] = "View our vast documentation";

// Terms Of Service

$_LANG['freemium_termsofservice_name'] = "Terms Of Service";

// Acceptable Usage Policy

$_LANG['freemium_acceptableusagepolicy_name'] = "Acceptable Usage Policy";

// Privacy Policy

$_LANG['freemium_privacypolicy_name'] = "Privacy Policy";






/*
-----------------------------------------
---------   Toolbar (File: includes/toolbar.tpl)   ---------
-----------------------------------------
*/

// Logged-out menu

$_LANG['freemium_toolbar_menu_contact'] = "Contact";
$_LANG['freemium_toolbar_menu_contact_icon'] = "fas fa-envelope";

$_LANG['freemium_toolbar_menu_cart'] = "View Cart";
$_LANG['freemium_toolbar_menu_cart_icon'] = "fas fa-shopping-cart";

$_LANG['freemium_toolbar_menu_clientarea'] = "Client Area";
$_LANG['freemium_toolbar_menu_clientarea_icon'] = "fas fa-lock";

// Logged-in menu

$_LANG['freemium_toolbar_menu_account'] = "My Account";
$_LANG['freemium_toolbar_menu_account_icon'] = "fas fa-address-card";

$_LANG['freemium_toolbar_menu_home'] = "Portal Home";
$_LANG['freemium_toolbar_menu_details'] = "Account Details";
$_LANG['freemium_toolbar_menu_usermanagement'] = "User Management";
$_LANG['freemium_toolbar_menu_contacts'] = "Contacts";
$_LANG['freemium_toolbar_menu_emails'] = "Email History";
$_LANG['freemium_toolbar_menu_profile'] = "Profile";
$_LANG['freemium_toolbar_menu_password'] = "Change Password";
$_LANG['freemium_toolbar_menu_commissions'] = "Refer A Friend";
$_LANG['freemium_toolbar_menu_invoices'] = "My Invoices";
$_LANG['freemium_toolbar_menu_orders'] = "My Orders";
$_LANG['freemium_toolbar_menu_domains'] = "My Domains";
$_LANG['freemium_toolbar_menu_quotes'] = "My Quotes";
$_LANG['freemium_toolbar_menu_tickets'] = "My Tickets";

$_LANG['freemium_toolbar_menu_logout'] = "Logout";
$_LANG['freemium_toolbar_menu_logout_icon'] = "far fa-sign-out";






/*
-----------------------------------------
---------   Main menu (File: includes/menu.tpl). The links within the menu can be found in the Pages section of this file.   ---------
-----------------------------------------
*/

// Domains

$_LANG['freemium_menu_domains'] = "Domains";

$_LANG['freemium_menu_domains_text'] = "<p>Hundreds of customer's around the world trust " . $_LANG['freemium_setting_companyname'] . " to manage their domain. We provide freedom and control including full access & the ability to move/sell your domains.</p>";

// Web Hosting

$_LANG['freemium_menu_services'] = "Web Hosting";

$_LANG['freemium_menu_services_text'] = "<p>We provide a wide range of services for your business including Web Hosting, Dedicated Servers, VPNs &amp; more.</p>";

// Extras

$_LANG['freemium_menu_extras'] = "Extras";

$_LANG['freemium_menu_extras_text'] = "<p>Enhance your website with these extras including our website backup &amp; security services.</p>";

// Company

$_LANG['freemium_menu_company'] = "Company";

$_LANG['freemium_menu_company_text'] = "<p>Learn more about what makes " . $_LANG['freemium_setting_companyname'] . " the best choice for web hosting services.</p>";

// Addons

$_LANG['freemium_menu_addons'] = "Addons";

$_LANG['freemium_menu_addons_text'] = "<p>Launch your business with our range of website templates and related services.</p>";

// Support

$_LANG['freemium_menu_support'] = "Support";

$_LANG['freemium_menu_support_text'] = "<p>If you have a pre-sale question or issue with your website we are here to help.</p>";






/*
-----------------------------------------
---------   Cart menu (File: includes/menu.tpl) - Displayed on the cart.php pages    ---------
-----------------------------------------
*/

$_LANG['freemium_cart_steps_1_name'] = "Step 1";
$_LANG['freemium_cart_steps_1_text'] = "Choose";

$_LANG['freemium_cart_steps_2_name'] = "Step 2";
$_LANG['freemium_cart_steps_2_text'] = "Configure";

$_LANG['freemium_cart_steps_3_name'] = "Step 3";
$_LANG['freemium_cart_steps_3_text'] = "Checkout";






/*
-----------------------------------------
---------   Footer (File: includes/footer.tpl) - The link text for each link (e.g Register Domain of the register domain link) are set under the Pages section within this file    ---------
-----------------------------------------
*/

$_LANG['freemium_footer_services'] = "Services";

$_LANG['freemium_footer_extras'] = "Extras";

$_LANG['freemium_footer_addons'] = "Addons";

$_LANG['freemium_footer_domains'] = "Domains";

$_LANG['freemium_footer_support'] = "Support";

$_LANG['freemium_footer_company'] = "Company";

$_LANG['freemium_footer_social'] = "Follow " . $_LANG['freemium_setting_companyname'];






/*
-----------------------------------------
---------   Copyright (File: includes/footer.tpl)   ---------
-----------------------------------------
*/

$_LANG['freemium_copyright_text'] = " | All rights reserved";

$_LANG['freemium_legal_link_terms'] = "Terms Of Service";
$_LANG['freemium_legal_link_usage'] = "Acceptable Usage Policy";
$_LANG['freemium_legal_link_privacy'] = "Privacy Policy";






/*
-----------------------------------------
---------   Cart banner (File: includes/itemsincart.tpl)   ---------
-----------------------------------------
*/

$_LANG['freemium_itemsincart_display'] = true;
$_LANG['freemium_itemsincart_heading'] = "Your Order Is Almost Completed";
$_LANG['freemium_itemsincart_text1'] = "We notice that you have items in your cart totalling ";
$_LANG['freemium_itemsincart_text2'] = ". We have saved it for you so you don't miss out on the high quality products &amp; support that you can expect from " . $_LANG['freemium_setting_companyname'] . ".";
$_LANG['freemium_itemsincart_carttotal_display'] = true;
$_LANG['freemium_itemsincart_promo_display'] = true;
$_LANG['freemium_itemsincart_promo_text'] = "Complete your order today and <strong>save 5%</strong>* using coupon: ";
$_LANG['freemium_itemsincart_promo_code'] = "WelcomeBack"; // Leave blank for no promo. This promo should be created in WHMCS: https://docs.whmcs.com/Promotions
$_LANG['freemium_itemsincart_button1_text'] = "Have A Question?";
$_LANG['freemium_itemsincart_button1_icon'] = "fas fa-envelope";
$_LANG['freemium_itemsincart_button1_url'] = "default";
$_LANG['freemium_itemsincart_button1_url_newwindow'] = false;
$_LANG['freemium_itemsincart_button2_text'] = "Apply Discount!";
$_LANG['freemium_itemsincart_button2_icon'] = "fas fa-shopping-cart";
$_LANG['freemium_itemsincart_button2_url'] = "default";
$_LANG['freemium_itemsincart_button2_url_newwindow'] = false;






/*
-----------------------------------------
---------   Badges - Used for various areas such as the menu, footer links, feature boxes - loaded via CSS file by default, add below to override   ---------
-----------------------------------------
*/

$_LANG['freemium_badge_hot'] = "";  // hot by default
$_LANG['freemium_badge_new'] = ""; // new by default
$_LANG['freemium_badge_popular'] = ""; // popular by default
$_LANG['freemium_badge_free'] = ""; // free by default

$_LANG['freemium_price_free'] = "free"; // Used when a price is set to free in Wizard Panel






/*
-----------------------------------------
---------   Home page (File: homepage.tpl, index.php)   ---------
-----------------------------------------
*/

// Submenu

$_LANG['freemium_homepage_submenu_display'] = false;

$_LANG['freemium_homepage_submenu_1_display'] = true;
$_LANG['freemium_homepage_submenu_1_text'] = "Overview";
$_LANG['freemium_homepage_submenu_1_url'] = "#overview";
$_LANG['freemium_homepage_submenu_1_url_newwindow'] = false;

$_LANG['freemium_homepage_submenu_2_display'] = true;
$_LANG['freemium_homepage_submenu_2_text'] = "Services";
$_LANG['freemium_homepage_submenu_2_url'] = "#services";
$_LANG['freemium_homepage_submenu_2_url_newwindow'] = false;

$_LANG['freemium_homepage_submenu_3_display'] = true;
$_LANG['freemium_homepage_submenu_3_text'] = "Features";
$_LANG['freemium_homepage_submenu_3_url'] = "#features";
$_LANG['freemium_homepage_submenu_3_url_newwindow'] = false;

$_LANG['freemium_homepage_submenu_4_display'] = true;
$_LANG['freemium_homepage_submenu_4_text'] = "Testimonials";
$_LANG['freemium_homepage_submenu_4_url'] = "#testimonials";
$_LANG['freemium_homepage_submenu_4_url_newwindow'] = false;

$_LANG['freemium_homepage_submenu_5_display'] = true;
$_LANG['freemium_homepage_submenu_5_text'] = "Why Choose Us";
$_LANG['freemium_homepage_submenu_5_url'] = "#whychooseus";
$_LANG['freemium_homepage_submenu_5_url_newwindow'] = false;

$_LANG['freemium_homepage_submenu_6_display'] = true;
$_LANG['freemium_homepage_submenu_6_text'] = "FAQS";
$_LANG['freemium_homepage_submenu_6_url'] = "#faqs";
$_LANG['freemium_homepage_submenu_6_url_newwindow'] = false;

// Overview

$_LANG['freemium_homepage_overview_display'] = true;

$_LANG['freemium_homepage_overview_heading'] = $_LANG['freemium_setting_companyname'] . " Brings You Quality Web Hosting";

$_LANG['freemium_homepage_overview_text'] = "

<p>We provide Shared Hosting, Reseller Hosting, Business Hosting, Virtual Private Servers, Dedicated Servers and many more solutions for individuals, families, organisations and businesses. As we are a pronounced web hosting company we include a free domain name registration/transfer with all of our web hosting plans. The domain name included with your hosting plan is yours to carry on forever.</p>
	
<p>Our experts are available 24 hours a day, 7 days a week by customer desk, live chat & by phone for those times when you need help. Whether you need help with server assistance, registration of domains, transferring domain and websites, hosting related issues, control panel guidance we are here to assist you!</p>

";

/* Plans - Your plans are set and edited in Wizard Panel (With quick setup set to off). If you have Multi-language support set to on then the text is edited in this file under the "Multi-language support: on" section */

// Features

$_LANG['freemium_homepage_features_display'] = true;

$_LANG['freemium_homepage_features_heading'] = "Our Hosting Features";

// Feature 1

$_LANG['freemium_homepage_features_1_display'] = true;
$_LANG['freemium_homepage_features_1_displayorder'] = 0;
$_LANG['freemium_homepage_features_1_animation'] = "fadeInLeft";
$_LANG['freemium_homepage_features_1_heading'] = "cPanel Control Panel";
$_LANG['freemium_homepage_features_1_image'] = "homepage-features-1.png";
$_LANG['freemium_homepage_features_1_image_alt'] = "cpanel";
$_LANG['freemium_homepage_features_1_image_url'] = "";
$_LANG['freemium_homepage_features_1_image_url_newwindow'] = false;
$_LANG['freemium_homepage_features_1_text'] = "

<p>With cPanel you can easily manage every aspect of your web hosting account. From creating custom email addresses all the way to editing your website files.</p>

";

// Feature 2

$_LANG['freemium_homepage_features_2_display'] = true;
$_LANG['freemium_homepage_features_2_displayorder'] = 0;
$_LANG['freemium_homepage_features_2_animation'] = "fadeInUp";
$_LANG['freemium_homepage_features_2_heading'] = "Softaculous Script Installer";
$_LANG['freemium_homepage_features_2_image'] = "homepage-features-2.png";
$_LANG['freemium_homepage_features_2_image_alt'] = "softaculous";
$_LANG['freemium_homepage_features_2_image_url'] = "";
$_LANG['freemium_homepage_features_2_image_url_newwindow'] = false;
$_LANG['freemium_homepage_features_2_text'] = "

<p>Softaculous is an application built into cPanel that allows you to easily install from over 150 free scripts/software. Software includes: WordPress, Joomla, Magento and many more.</p>

";

// Feature 3

$_LANG['freemium_homepage_features_3_display'] = true;
$_LANG['freemium_homepage_features_3_displayorder'] = 0;
$_LANG['freemium_homepage_features_3_animation'] = "fadeInRight";
$_LANG['freemium_homepage_features_3_heading'] = "LiteSpeed Web Servers";
$_LANG['freemium_homepage_features_3_image'] = "homepage-features-3.png";
$_LANG['freemium_homepage_features_3_image_alt'] = "litespeed";
$_LANG['freemium_homepage_features_3_image_url'] = "";
$_LANG['freemium_homepage_features_3_image_url_newwindow'] = false;
$_LANG['freemium_homepage_features_3_text'] = "

<p>All of our web hosting packages come with LiteSpeed out of the box. LiteSpeed is up to 9 times faster than Apache which is the standard web server setup.</p>

";

// Feature 4

$_LANG['freemium_homepage_features_4_display'] = true;
$_LANG['freemium_homepage_features_4_displayorder'] = 0;
$_LANG['freemium_homepage_features_4_animation'] = "fadeInLeft";
$_LANG['freemium_homepage_features_4_heading'] = "R1Soft Backups";
$_LANG['freemium_homepage_features_4_image'] = "homepage-features-4.png";
$_LANG['freemium_homepage_features_4_image_alt'] = "r1soft";
$_LANG['freemium_homepage_features_4_image_url'] = "";
$_LANG['freemium_homepage_features_4_image_url_newwindow'] = false;
$_LANG['freemium_homepage_features_4_text'] = "

<p>All of our web hosting accounts come with automated and completely free backups. This is made possible by the leading R1Soft Backup software.</p>

";

// Feature 5

$_LANG['freemium_homepage_features_5_display'] = true;
$_LANG['freemium_homepage_features_5_displayorder'] = 0;
$_LANG['freemium_homepage_features_5_animation'] = "fadeInUp";
$_LANG['freemium_homepage_features_5_heading'] = "Our Datacenter";
$_LANG['freemium_homepage_features_5_image'] = "homepage-features-5.png";
$_LANG['freemium_homepage_features_5_image_alt'] = "datacenter";
$_LANG['freemium_homepage_features_5_image_url'] = "";
$_LANG['freemium_homepage_features_5_image_url_newwindow'] = false;
$_LANG['freemium_homepage_features_5_text'] = "

<p>All of our web servers are located in a large, well-known datacenter in Dallas Texas, United States. Our facility is monitored 24/7 to ensure that all servers are up.</p>

";

// Feature 6

$_LANG['freemium_homepage_features_6_display'] = true;
$_LANG['freemium_homepage_features_6_displayorder'] = 0;
$_LANG['freemium_homepage_features_6_animation'] = "fadeInRight";
$_LANG['freemium_homepage_features_6_heading'] = "Award Winning Provider";
$_LANG['freemium_homepage_features_6_image'] = "homepage-features-6.png";
$_LANG['freemium_homepage_features_6_image_alt'] = "awards";
$_LANG['freemium_homepage_features_6_image_url'] = "";
$_LANG['freemium_homepage_features_6_image_url_newwindow'] = false;
$_LANG['freemium_homepage_features_6_text'] = "

<p>We've won a selection of prestigious awards as a reliable web hosting provider. Made possible with a quality service offer and high level of included support.</p>

";

// Testimonials

$_LANG['freemium_homepage_testimonials_display'] = true;

$_LANG['freemium_homepage_testimonials_heading'] = "Lots Of Happy Customers";

// Testimonial 1

$_LANG['freemium_homepage_testimonials_1_display'] = true;
$_LANG['freemium_homepage_testimonials_1_displayorder'] = 0;
$_LANG['freemium_homepage_testimonials_1_animation'] = "fadeInLeft";
$_LANG['freemium_homepage_testimonials_1_quote'] = "

<p>My experience with " . $_LANG['freemium_setting_companyname'] . " has been nothing short of amazing. The level of support provided with the package has been fantastic. I will be sure to recommend " . $_LANG['freemium_setting_companyname'] . " to all of my friends.</p>

";
$_LANG['freemium_homepage_testimonials_1_author'] = "Nathan";
$_LANG['freemium_homepage_testimonials_1_url'] = "www.google.com";
$_LANG['freemium_homepage_testimonials_1_image'] = "homepage-testimonials-1.png";
$_LANG['freemium_homepage_testimonials_1_alt'] = "client 1";
$_LANG['freemium_homepage_testimonials_1_image_url'] = "";
$_LANG['freemium_homepage_testimonials_1_image_url_newwindow'] = false;

// Testimonial 2

$_LANG['freemium_homepage_testimonials_2_display'] = true;
$_LANG['freemium_homepage_testimonials_2_displayorder'] = 0;
$_LANG['freemium_homepage_testimonials_2_animation'] = "fadeInUp";
$_LANG['freemium_homepage_testimonials_2_quote'] = "

<p>" . $_LANG['freemium_setting_companyname'] . " is the most reliable company I have come across for services. If you're looking for a reliable service look no further than " . $_LANG['freemium_setting_companyname'] . "! Sign-up today to see why they are the best!</p>

";
$_LANG['freemium_homepage_testimonials_2_author'] = "Joanna";
$_LANG['freemium_homepage_testimonials_2_url'] = "www.yahoo.com";
$_LANG['freemium_homepage_testimonials_2_image'] = "homepage-testimonials-2.png";
$_LANG['freemium_homepage_testimonials_2_alt'] = "client 2";
$_LANG['freemium_homepage_testimonials_2_image_url'] = "";
$_LANG['freemium_homepage_testimonials_2_image_url_newwindow'] = false;

// Testimonial 3

$_LANG['freemium_homepage_testimonials_3_display'] = true;
$_LANG['freemium_homepage_testimonials_3_displayorder'] = 0;
$_LANG['freemium_homepage_testimonials_3_animation'] = "fadeInRight";
$_LANG['freemium_homepage_testimonials_3_quote'] = "

<p>I've been a customer with " . $_LANG['freemium_setting_companyname'] . " for over 5 years, they never fail to disappoint me and the service has been top notch since I created my first order with " . $_LANG['freemium_setting_companyname'] . ". Don't hesitate to join!</p>

";
$_LANG['freemium_homepage_testimonials_3_author'] = "George";
$_LANG['freemium_homepage_testimonials_3_url'] = "www.msn.com";
$_LANG['freemium_homepage_testimonials_3_image'] = "homepage-testimonials-3.png";
$_LANG['freemium_homepage_testimonials_3_alt'] = "client 3";
$_LANG['freemium_homepage_testimonials_3_image_url'] = "";
$_LANG['freemium_homepage_testimonials_3_image_url_newwindow'] = false;

// Why Choose Us

$_LANG['freemium_homepage_whychooseus_display'] = true;

$_LANG['freemium_homepage_whychooseus_heading'] = "Why Choose Us?";

// Why Choose Us 1

$_LANG['freemium_homepage_whychooseus_1_display'] = true;
$_LANG['freemium_homepage_whychooseus_1_displayorder'] = 0;
$_LANG['freemium_homepage_whychooseus_1_animation'] = "fadeInLeft";
$_LANG['freemium_homepage_whychooseus_1_heading'] = "Reliable Support";
$_LANG['freemium_homepage_whychooseus_1_image'] = "homepage-whychooseus-1.png";
$_LANG['freemium_homepage_whychooseus_1_image_alt'] = "reliable support";
$_LANG['freemium_homepage_whychooseus_1_image_url'] = "";
$_LANG['freemium_homepage_whychooseus_1_image_url_newwindow'] = false;
$_LANG['freemium_homepage_whychooseus_1_text'] = "

<p>As a " . $_LANG['freemium_setting_companyname'] . " customer you can expect to receive reliable support as we believe support is the most important factor. We provide support via our ticket system and live chat.</p>

";

// Why Choose Us 2

$_LANG['freemium_homepage_whychooseus_2_display'] = true;
$_LANG['freemium_homepage_whychooseus_2_displayorder'] = 0;
$_LANG['freemium_homepage_whychooseus_2_animation'] = "fadeInUp";
$_LANG['freemium_homepage_whychooseus_2_heading'] = "Passionate";
$_LANG['freemium_homepage_whychooseus_2_image'] = "homepage-whychooseus-2.png";
$_LANG['freemium_homepage_whychooseus_2_image_alt'] = "quality servers";
$_LANG['freemium_homepage_whychooseus_2_image_url'] = "";
$_LANG['freemium_homepage_whychooseus_2_image_url_newwindow'] = false;
$_LANG['freemium_homepage_whychooseus_2_text'] = "

<p>We provide many products and services and have a passion for the quality and support provided. Create your order with us today to see just how much this impacts our services.</p>

";

// Why Choose Us 3

$_LANG['freemium_homepage_whychooseus_3_display'] = true;
$_LANG['freemium_homepage_whychooseus_3_displayorder'] = 0;
$_LANG['freemium_homepage_whychooseus_3_animation'] = "fadeInRight";
$_LANG['freemium_homepage_whychooseus_3_heading'] = "We Love Renewable";
$_LANG['freemium_homepage_whychooseus_3_image'] = "homepage-whychooseus-3.png";
$_LANG['freemium_homepage_whychooseus_3_image_alt'] = "renewable";
$_LANG['freemium_homepage_whychooseus_3_image_url'] = "";
$_LANG['freemium_homepage_whychooseus_3_image_url_newwindow'] = false;
$_LANG['freemium_homepage_whychooseus_3_text'] = "

<p>We have a deep passion for renewable energy and environment friendly hosting services and we are always keen to further expand this focus and attention to detail.</p>

";

// FAQs

$_LANG['freemium_homepage_faqs_display'] = true;

$_LANG['freemium_homepage_faqs_heading'] = "FAQs";

$_LANG['freemium_homepage_faqs_question_heading'] = "Have A Question?";
$_LANG['freemium_homepage_faqs_question_text'] = "<p>If you can't find the answer you are looking for our support is just an email away.</p>";

$_LANG['freemium_homepage_faqs_question_button1_text'] = "Contact Us";
$_LANG['freemium_homepage_faqs_question_button1_icon'] = "fas fa-envelope";
$_LANG['freemium_homepage_faqs_question_button1_url'] = "contact.php";
$_LANG['freemium_homepage_faqs_question_button1_url_newwindow'] = false;

$_LANG['freemium_homepage_faqs_question_button2_text'] = "";
$_LANG['freemium_homepage_faqs_question_button2_icon'] = "";
$_LANG['freemium_homepage_faqs_question_button2_url'] = "";
$_LANG['freemium_homepage_faqs_question_button2_url_newwindow'] = false;

$_LANG['freemium_homepage_faqs_1_display'] = true;
$_LANG['freemium_homepage_faqs_1_displayorder'] = 0;
$_LANG['freemium_homepage_faqs_1_question'] = "How long have you been in business?";
$_LANG['freemium_homepage_faqs_1_answer'] = "<p>" . $_LANG['freemium_setting_companyname'] . " has been providing reliable services since early 2008.</p>";

$_LANG['freemium_homepage_faqs_2_display'] = true;
$_LANG['freemium_homepage_faqs_2_displayorder'] = 0;
$_LANG['freemium_homepage_faqs_2_question'] = "Which payment methods are available?";
$_LANG['freemium_homepage_faqs_2_answer'] = "<p>We accept payment via PayPal, credit/debit card & cryptocurrencies.</p>";

$_LANG['freemium_homepage_faqs_3_display'] = true;
$_LANG['freemium_homepage_faqs_3_displayorder'] = 0;
$_LANG['freemium_homepage_faqs_3_question'] = "Which methods of support do you provide?";
$_LANG['freemium_homepage_faqs_3_answer'] = "<p>You can contact support via email, ticket and live chat.</p>";






/*
-----------------------------------------
---------   Register domain page (File: domain-pricing.tpl)   ---------
-----------------------------------------
*/

// Banner

$_LANG['freemium_registerdomain_banner_display'] = true;
$_LANG['freemium_registerdomain_banner_heading'] = "Register Domain";
$_LANG['freemium_registerdomain_banner_text'] = "Find the perfect domain for your business";
$_LANG['freemium_registerdomain_banner_background'] = "background5.jpg";
$_LANG['freemium_registerdomain_banner_background_opacity'] = 0.5;
$_LANG['freemium_registerdomain_banner_domainsearch_display'] = true;
$_LANG['freemium_registerdomain_banner_domainsearch_placeholder'] = "yourbusinessname.com";
$_LANG['freemium_registerdomain_banner_domainsearch_button'] = "Search";

// Submenu

$_LANG['freemium_registerdomain_submenu_display'] = true;

$_LANG['freemium_registerdomain_submenu_1_display'] = true;
$_LANG['freemium_registerdomain_submenu_1_text'] = "Featured TLDs";
$_LANG['freemium_registerdomain_submenu_1_url'] = "#featured";
$_LANG['freemium_registerdomain_submenu_1_url_newwindow'] = false;

$_LANG['freemium_registerdomain_submenu_2_display'] = true;
$_LANG['freemium_registerdomain_submenu_2_text'] = "Domain Pricing";
$_LANG['freemium_registerdomain_submenu_2_url'] = "#pricing";
$_LANG['freemium_registerdomain_submenu_2_url_newwindow'] = false;

$_LANG['freemium_registerdomain_submenu_3_display'] = true;
$_LANG['freemium_registerdomain_submenu_3_text'] = "Domain Features";
$_LANG['freemium_registerdomain_submenu_3_url'] = "#features";
$_LANG['freemium_registerdomain_submenu_3_url_newwindow'] = false;

// Featured TLDs

$_LANG['freemium_registerdomain_featuredtld_display'] = true;
$_LANG['freemium_registerdomain_featuredtld_heading'] = "Featured TLDs";

// Domain Pricing Table

$_LANG['freemium_registerdomain_domainpricing_display'] = true;
$_LANG['freemium_registerdomain_domainpricing_heading'] = "Domain Pricing";
$_LANG['freemium_registerdomain_domainpricing_text'] = "<p>At " . $_LANG['freemium_setting_companyname'] . " we provide many domain registration options including .com, .net & .org. The table below lists all of the TLDs we provide.</p>";

// Features

$_LANG['freemium_registerdomain_features_display'] = true;

$_LANG['freemium_registerdomain_features_heading'] = "Domain Features";

// Feature 1

$_LANG['freemium_registerdomain_features_1_display'] = true;
$_LANG['freemium_registerdomain_features_1_displayorder'] = 0;
$_LANG['freemium_registerdomain_features_1_animation'] = "fadeInLeft";
$_LANG['freemium_registerdomain_features_1_heading'] = "DNS Management";
$_LANG['freemium_registerdomain_features_1_image'] = "registerdomain-features-1.png";
$_LANG['freemium_registerdomain_features_1_image_alt'] = "dns management";
$_LANG['freemium_registerdomain_features_1_image_url'] = "";
$_LANG['freemium_registerdomain_features_1_image_url_newwindow'] = false;
$_LANG['freemium_registerdomain_features_1_text'] = "<p>Full control of your domain's DNS without any restrictions. DNS management includes nameservers, A records, MX, CNAME, URL redirects & email forwarding.</p>";

// Feature 2

$_LANG['freemium_registerdomain_features_2_display'] = true;
$_LANG['freemium_registerdomain_features_2_displayorder'] = 0;
$_LANG['freemium_registerdomain_features_2_animation'] = "fadeInUp";
$_LANG['freemium_registerdomain_features_2_heading'] = "Control Panel";
$_LANG['freemium_registerdomain_features_2_image'] = "registerdomain-features-2.png";
$_LANG['freemium_registerdomain_features_2_image_alt'] = "domain control panel";
$_LANG['freemium_registerdomain_features_2_image_url'] = "";
$_LANG['freemium_registerdomain_features_2_image_url_newwindow'] = false;
$_LANG['freemium_registerdomain_features_2_text'] = "<p>Manage every aspect of your domain easily from inside your " . $_LANG['freemium_setting_companyname'] . " domain control panel. Mange your DNS, nameservers, email, forwarding, lock, EPP code & WHOIS.</p>";

// Feature 3

$_LANG['freemium_registerdomain_features_3_display'] = true;
$_LANG['freemium_registerdomain_features_3_displayorder'] = 0;
$_LANG['freemium_registerdomain_features_3_animation'] = "fadeInRight";
$_LANG['freemium_registerdomain_features_3_heading'] = "Email Forwarding";
$_LANG['freemium_registerdomain_features_3_image'] = "registerdomain-features-3.png";
$_LANG['freemium_registerdomain_features_3_image_alt'] = "email forwarding";
$_LANG['freemium_registerdomain_features_3_image_url'] = "";
$_LANG['freemium_registerdomain_features_3_image_url_newwindow'] = false;
$_LANG['freemium_registerdomain_features_3_text'] = "<p>Email forwarding is included completely free with all domains. This allows you to forward unlimited @yourcompany.com email addresses without a hosting or email service.</p>";






/*
-----------------------------------------
---------   Wizard Panel Sales Pages (with quick setup turned off)   ---------
-----------------------------------------
*/



/*
	
	You can re-name any of the 10 Wizard Panel sales pages following this guide: https://www.zomex.com/docs/whmcs-templates/how-to-change-hosting-page-type/
	
*/



/*
-----------------------------------------
---------   Shared Hosting page by default (File: web-hosting.tpl, web-hosting.php)   ---------
-----------------------------------------
*/

// Submenu

$_LANG['freemium_custom1_submenu_display'] = true;

$_LANG['freemium_custom1_submenu_1_display'] = true;
$_LANG['freemium_custom1_submenu_1_text'] = "Overview";
$_LANG['freemium_custom1_submenu_1_url'] = "#overview";
$_LANG['freemium_custom1_submenu_1_url_newwindow'] = false;

$_LANG['freemium_custom1_submenu_2_display'] = true;
$_LANG['freemium_custom1_submenu_2_text'] = "Plans";
$_LANG['freemium_custom1_submenu_2_url'] = "#plans";
$_LANG['freemium_custom1_submenu_2_url_newwindow'] = false;

$_LANG['freemium_custom1_submenu_3_display'] = true;
$_LANG['freemium_custom1_submenu_3_text'] = "Features";
$_LANG['freemium_custom1_submenu_3_url'] = "#features";
$_LANG['freemium_custom1_submenu_3_url_newwindow'] = false;

$_LANG['freemium_custom1_submenu_4_display'] = true;
$_LANG['freemium_custom1_submenu_4_text'] = "Testimonials";
$_LANG['freemium_custom1_submenu_4_url'] = "#testimonials";
$_LANG['freemium_custom1_submenu_4_url_newwindow'] = false;

$_LANG['freemium_custom1_submenu_5_display'] = true;
$_LANG['freemium_custom1_submenu_5_text'] = "Why Choose Us";
$_LANG['freemium_custom1_submenu_5_url'] = "#whychooseus";
$_LANG['freemium_custom1_submenu_5_url_newwindow'] = false;

$_LANG['freemium_custom1_submenu_6_display'] = true;
$_LANG['freemium_custom1_submenu_6_text'] = "FAQS";
$_LANG['freemium_custom1_submenu_6_url'] = "#faqs";
$_LANG['freemium_custom1_submenu_6_url_newwindow'] = false;

/* Plans - Your plans are set and edited in Wizard Panel (With quick setup set to off). If you have Multi-language support set to on then the text is edited in this file under the "Multi-language support: on" section */

// Overview

$_LANG['freemium_custom1_overview_display'] = true;

$_LANG['freemium_custom1_overview_text'] = "

<p>View our premium quality web hosting plans below. All of our web hosting plans come with cPanel, the leading hosting control panel allowing easy editing and full control of your website.</p>
	
<p>Preinstalled scripts included with our web hosting plans make life much easier by allowing you to install any popular application/software without any prior web hosting knowledge. Whether you want to start a website, blog, forum or online store our 1 click script installer has you covered.</p>

";

// Features

$_LANG['freemium_custom1_features_display'] = true;

$_LANG['freemium_custom1_features_heading'] = $_LANG['freemium_custom1_name'] . " Features";

// Feature 1

$_LANG['freemium_custom1_features_1_display'] = true;
$_LANG['freemium_custom1_features_1_displayorder'] = 0;
$_LANG['freemium_custom1_features_1_animation'] = "fadeInLeft";
$_LANG['freemium_custom1_features_1_heading'] = "cPanel Control Panel";
$_LANG['freemium_custom1_features_1_image'] = "custom1-features-1.png";
$_LANG['freemium_custom1_features_1_image_alt'] = "cpanel";
$_LANG['freemium_custom1_features_1_image_url'] = "";
$_LANG['freemium_custom1_features_1_image_url_newwindow'] = false;
$_LANG['freemium_custom1_features_1_text'] = "

<p>With cPanel you can easily manage every aspect of your web hosting account. From creating custom email addresses all the way to editing your website files.</p>

";

// Feature 2

$_LANG['freemium_custom1_features_2_display'] = true;
$_LANG['freemium_custom1_features_2_displayorder'] = 0;
$_LANG['freemium_custom1_features_2_animation'] = "fadeInUp";
$_LANG['freemium_custom1_features_2_heading'] = "Softaculous Script Installer";
$_LANG['freemium_custom1_features_2_image'] = "custom1-features-2.png";
$_LANG['freemium_custom1_features_2_image_alt'] = "softaculous";
$_LANG['freemium_custom1_features_2_image_url'] = "";
$_LANG['freemium_custom1_features_2_image_url_newwindow'] = false;
$_LANG['freemium_custom1_features_2_text'] = "

<p>Softaculous is an application built into cPanel that allows you to easily install from over 150 free scripts/software. Software includes: WordPress, Joomla, Magento and many more.</p>

";

// Feature 3

$_LANG['freemium_custom1_features_3_display'] = true;
$_LANG['freemium_custom1_features_3_displayorder'] = 0;
$_LANG['freemium_custom1_features_3_animation'] = "fadeInRight";
$_LANG['freemium_custom1_features_3_heading'] = "LiteSpeed Web Servers";
$_LANG['freemium_custom1_features_3_image'] = "custom1-features-3.png";
$_LANG['freemium_custom1_features_3_image_alt'] = "litespeed";
$_LANG['freemium_custom1_features_3_image_url'] = "";
$_LANG['freemium_custom1_features_3_image_url_newwindow'] = false;
$_LANG['freemium_custom1_features_3_text'] = "

<p>All of our web hosting packages come with LiteSpeed out of the box. LiteSpeed is up to 9 times faster than Apache which is the standard web server setup.</p>

";

// Feature 4

$_LANG['freemium_custom1_features_4_display'] = true;
$_LANG['freemium_custom1_features_4_displayorder'] = 0;
$_LANG['freemium_custom1_features_4_animation'] = "fadeInLeft";
$_LANG['freemium_custom1_features_4_heading'] = "R1Soft Backups";
$_LANG['freemium_custom1_features_4_image'] = "custom1-features-4.png";
$_LANG['freemium_custom1_features_4_image_alt'] = "r1soft";
$_LANG['freemium_custom1_features_4_image_url'] = "";
$_LANG['freemium_custom1_features_4_image_url_newwindow'] = false;
$_LANG['freemium_custom1_features_4_text'] = "

<p>All of our web hosting accounts come with automated and completely free backups. This is made possible by the leading R1Soft Backup software.</p>

";

// Feature 5

$_LANG['freemium_custom1_features_5_display'] = true;
$_LANG['freemium_custom1_features_5_displayorder'] = 0;
$_LANG['freemium_custom1_features_5_animation'] = "fadeInUp";
$_LANG['freemium_custom1_features_5_heading'] = "Our Datacenter";
$_LANG['freemium_custom1_features_5_image'] = "custom1-features-5.png";
$_LANG['freemium_custom1_features_5_image_alt'] = "datacenter";
$_LANG['freemium_custom1_features_5_image_url'] = "";
$_LANG['freemium_custom1_features_5_image_url_newwindow'] = false;
$_LANG['freemium_custom1_features_5_text'] = "

<p>All of our web servers are located in a large, well-known datacenter in Dallas Texas, United States. Our facility is monitored 24/7 to ensure that all servers are up.</p>

";

// Feature 6

$_LANG['freemium_custom1_features_6_display'] = true;
$_LANG['freemium_custom1_features_6_displayorder'] = 0;
$_LANG['freemium_custom1_features_6_animation'] = "fadeInRight";
$_LANG['freemium_custom1_features_6_heading'] = "Award Winning Provider";
$_LANG['freemium_custom1_features_6_image'] = "custom1-features-6.png";
$_LANG['freemium_custom1_features_6_image_alt'] = "awards";
$_LANG['freemium_custom1_features_6_image_url'] = "";
$_LANG['freemium_custom1_features_6_image_url_newwindow'] = false;
$_LANG['freemium_custom1_features_6_text'] = "

<p>We've won a selection of prestigious awards as a reliable web hosting provider. Made possible with a quality service offer and high level of included support.</p>

";

// Testimonials

$_LANG['freemium_custom1_testimonials_display'] = true;

$_LANG['freemium_custom1_testimonials_heading'] = "Lots Of Happy Customers";

// Testimonial 1

$_LANG['freemium_custom1_testimonials_1_display'] = true;
$_LANG['freemium_custom1_testimonials_1_displayorder'] = 0;
$_LANG['freemium_custom1_testimonials_1_animation'] = "fadeInLeft";
$_LANG['freemium_custom1_testimonials_1_quote'] = "

<p>My experience with " . $_LANG['freemium_setting_companyname'] . " has been nothing short of amazing. The level of support provided with the package has been fantastic. I will be sure to recommend " . $_LANG['freemium_setting_companyname'] . " to all of my friends.</p>

";
$_LANG['freemium_custom1_testimonials_1_author'] = "Nathan";
$_LANG['freemium_custom1_testimonials_1_url'] = "www.google.com";
$_LANG['freemium_custom1_testimonials_1_image'] = "custom1-testimonials-1.png";
$_LANG['freemium_custom1_testimonials_1_alt'] = "client 1";
$_LANG['freemium_custom1_testimonials_1_image_url'] = "";
$_LANG['freemium_custom1_testimonials_1_image_url_newwindow'] = false;

// Testimonial 2

$_LANG['freemium_custom1_testimonials_2_display'] = true;
$_LANG['freemium_custom1_testimonials_2_displayorder'] = 0;
$_LANG['freemium_custom1_testimonials_2_animation'] = "fadeInUp";
$_LANG['freemium_custom1_testimonials_2_quote'] = "

<p>" . $_LANG['freemium_setting_companyname'] . " is the most reliable company I have come across for services. If you're looking for a reliable service look no further than " . $_LANG['freemium_setting_companyname'] . "! Sign-up today to see why they are the best!</p>

";
$_LANG['freemium_custom1_testimonials_2_author'] = "Joanna";
$_LANG['freemium_custom1_testimonials_2_url'] = "www.yahoo.com";
$_LANG['freemium_custom1_testimonials_2_image'] = "custom1-testimonials-2.png";
$_LANG['freemium_custom1_testimonials_2_alt'] = "client 2";
$_LANG['freemium_custom1_testimonials_2_image_url'] = "";
$_LANG['freemium_custom1_testimonials_2_image_url_newwindow'] = false;

// Testimonial 3

$_LANG['freemium_custom1_testimonials_3_display'] = true;
$_LANG['freemium_custom1_testimonials_3_displayorder'] = 0;
$_LANG['freemium_custom1_testimonials_3_animation'] = "fadeInRight";
$_LANG['freemium_custom1_testimonials_3_quote'] = "

<p>I've been a customer with " . $_LANG['freemium_setting_companyname'] . " for over 5 years, they never fail to disappoint me and the service has been top notch since I created my first order with " . $_LANG['freemium_setting_companyname'] . ". Don't hesitate to join!</p>

";
$_LANG['freemium_custom1_testimonials_3_author'] = "George";
$_LANG['freemium_custom1_testimonials_3_url'] = "www.msn.com";
$_LANG['freemium_custom1_testimonials_3_image'] = "custom1-testimonials-3.png";
$_LANG['freemium_custom1_testimonials_3_alt'] = "client 3";
$_LANG['freemium_custom1_testimonials_3_image_url'] = "";
$_LANG['freemium_custom1_testimonials_3_image_url_newwindow'] = false;

// Why Choose Us

$_LANG['freemium_custom1_whychooseus_display'] = true;

$_LANG['freemium_custom1_whychooseus_heading'] = "Why Choose Us?";

// Why Choose Us 1

$_LANG['freemium_custom1_whychooseus_1_display'] = true;
$_LANG['freemium_custom1_whychooseus_1_displayorder'] = 0;
$_LANG['freemium_custom1_whychooseus_1_animation'] = "fadeInLeft";
$_LANG['freemium_custom1_whychooseus_1_heading'] = "Reliable Support";
$_LANG['freemium_custom1_whychooseus_1_image'] = "custom1-whychooseus-1.png";
$_LANG['freemium_custom1_whychooseus_1_image_alt'] = "reliable support";
$_LANG['freemium_custom1_whychooseus_1_image_url'] = "";
$_LANG['freemium_custom1_whychooseus_1_image_url_newwindow'] = false;
$_LANG['freemium_custom1_whychooseus_1_text'] = "

<p>As a " . $_LANG['freemium_setting_companyname'] . " customer you can expect to receive reliable support as we believe support is the most important factor. We provide support via our ticket system and live chat.</p>

";

// Why Choose Us 2

$_LANG['freemium_custom1_whychooseus_2_display'] = true;
$_LANG['freemium_custom1_whychooseus_2_displayorder'] = 0;
$_LANG['freemium_custom1_whychooseus_2_animation'] = "fadeInUp";
$_LANG['freemium_custom1_whychooseus_2_heading'] = "Passionate";
$_LANG['freemium_custom1_whychooseus_2_image'] = "custom1-whychooseus-2.png";
$_LANG['freemium_custom1_whychooseus_2_image_alt'] = "quality servers";
$_LANG['freemium_custom1_whychooseus_2_image_url'] = "";
$_LANG['freemium_custom1_whychooseus_2_image_url_newwindow'] = false;
$_LANG['freemium_custom1_whychooseus_2_text'] = "

<p>We provide many products and services and have a passion for the quality and support provided. Create your order with us today to see just how much this impacts our services.</p>

";

// Why Choose Us 3

$_LANG['freemium_custom1_whychooseus_3_display'] = true;
$_LANG['freemium_custom1_whychooseus_3_displayorder'] = 0;
$_LANG['freemium_custom1_whychooseus_3_animation'] = "fadeInRight";
$_LANG['freemium_custom1_whychooseus_3_heading'] = "We Love Renewable";
$_LANG['freemium_custom1_whychooseus_3_image'] = "custom1-whychooseus-3.png";
$_LANG['freemium_custom1_whychooseus_3_image_alt'] = "renewable";
$_LANG['freemium_custom1_whychooseus_3_image_url'] = "";
$_LANG['freemium_custom1_whychooseus_3_image_url_newwindow'] = false;
$_LANG['freemium_custom1_whychooseus_3_text'] = "

<p>We have a deep passion for renewable energy and environment friendly hosting services and we are always keen to further expand this focus and attention to detail.</p>

";

// FAQs

$_LANG['freemium_custom1_faqs_display'] = true;

$_LANG['freemium_custom1_faqs_heading'] = "FAQs";

$_LANG['freemium_custom1_faqs_question_heading'] = "Have A Question?";
$_LANG['freemium_custom1_faqs_question_text'] = "<p>If you can't find the answer you are looking for our support is just an email away.</p>";

$_LANG['freemium_custom1_faqs_question_button1_text'] = "Contact Us";
$_LANG['freemium_custom1_faqs_question_button1_icon'] = "fas fa-envelope";
$_LANG['freemium_custom1_faqs_question_button1_url'] = "contact.php";
$_LANG['freemium_custom1_faqs_question_button1_url_newwindow'] = false;

$_LANG['freemium_custom1_faqs_question_button2_text'] = "";
$_LANG['freemium_custom1_faqs_question_button2_icon'] = "";
$_LANG['freemium_custom1_faqs_question_button2_url'] = "";
$_LANG['freemium_custom1_faqs_question_button2_url_newwindow'] = false;

$_LANG['freemium_custom1_faqs_1_display'] = true;
$_LANG['freemium_custom1_faqs_1_displayorder'] = 0;
$_LANG['freemium_custom1_faqs_1_question'] = "How long have you been in business?";
$_LANG['freemium_custom1_faqs_1_answer'] = "<p>" . $_LANG['freemium_setting_companyname'] . " has been providing reliable services since early 2008.</p>";

$_LANG['freemium_custom1_faqs_2_display'] = true;
$_LANG['freemium_custom1_faqs_2_displayorder'] = 0;
$_LANG['freemium_custom1_faqs_2_question'] = "Which payment methods are available?";
$_LANG['freemium_custom1_faqs_2_answer'] = "<p>We accept payment via PayPal, credit/debit card & cryptocurrencies.</p>";

$_LANG['freemium_custom1_faqs_3_display'] = true;
$_LANG['freemium_custom1_faqs_3_displayorder'] = 0;
$_LANG['freemium_custom1_faqs_3_question'] = "Which methods of support do you provide?";
$_LANG['freemium_custom1_faqs_3_answer'] = "<p>You can contact support via email, ticket and live chat.</p>";






/*
-----------------------------------------
---------   Why choose us page (File: why-choose-us.tpl, why-choose-us.php)   ---------
-----------------------------------------
*/

// Why Choose Us

$_LANG['freemium_whychooseus_display'] = true;

// Why Choose Us 1

$_LANG['freemium_whychooseus_1_display'] = true;
$_LANG['freemium_whychooseus_1_displayorder'] = 0;
$_LANG['freemium_whychooseus_1_animation'] = "fadeInLeft";
$_LANG['freemium_whychooseus_1_heading'] = "Reliable Support";
$_LANG['freemium_whychooseus_1_image'] = "whychooseus-whychooseus-1.png";
$_LANG['freemium_whychooseus_1_image_alt'] = "reliable support";
$_LANG['freemium_whychooseus_1_image_url'] = "";
$_LANG['freemium_whychooseus_1_image_url_newwindow'] = false;
$_LANG['freemium_whychooseus_1_text'] = "

<p>As a " . $_LANG['freemium_setting_companyname'] . " customer you can expect to receive reliable support as we believe support is the most important factor. We provide support via our ticket system and live chat.</p>

";

// Why Choose Us 2

$_LANG['freemium_whychooseus_2_display'] = true;
$_LANG['freemium_whychooseus_2_displayorder'] = 0;
$_LANG['freemium_whychooseus_2_animation'] = "fadeInUp";
$_LANG['freemium_whychooseus_2_heading'] = "Passionate";
$_LANG['freemium_whychooseus_2_image'] = "whychooseus-whychooseus-2.png";
$_LANG['freemium_whychooseus_2_image_alt'] = "quality servers";
$_LANG['freemium_whychooseus_2_image_url'] = "";
$_LANG['freemium_whychooseus_2_image_url_newwindow'] = false;
$_LANG['freemium_whychooseus_2_text'] = "

<p>We provide many products and services and have a passion for the quality and support provided. Create your order with us today to see just how much this impacts our services.</p>

";

// Why Choose Us 3

$_LANG['freemium_whychooseus_3_display'] = true;
$_LANG['freemium_whychooseus_3_displayorder'] = 0;
$_LANG['freemium_whychooseus_3_animation'] = "fadeInRight";
$_LANG['freemium_whychooseus_3_heading'] = "We Love Renewable";
$_LANG['freemium_whychooseus_3_image'] = "whychooseus-whychooseus-3.png";
$_LANG['freemium_whychooseus_3_image_alt'] = "renewable";
$_LANG['freemium_whychooseus_3_image_url'] = "";
$_LANG['freemium_whychooseus_3_image_url_newwindow'] = false;
$_LANG['freemium_whychooseus_3_text'] = "

<p>We have a deep passion for renewable energy and environment friendly hosting services and we are always keen to further expand this focus and attention to detail.</p>

";






/*
-----------------------------------------
---------   Testimonials page (File: testimonials.tpl, testimonials.php)   ---------
-----------------------------------------
*/

// Testimonials

$_LANG['freemium_testimonials_display'] = true;

// Testimonial 1

$_LANG['freemium_testimonials_1_display'] = true;
$_LANG['freemium_testimonials_1_displayorder'] = 0;
$_LANG['freemium_testimonials_1_animation'] = "fadeInLeft";
$_LANG['freemium_testimonials_1_quote'] = "

<p>My experience with " . $_LANG['freemium_setting_companyname'] . " has been nothing short of amazing. The level of support provided with the package has been fantastic. I will be sure to recommend " . $_LANG['freemium_setting_companyname'] . " to all of my friends.</p>

";
$_LANG['freemium_testimonials_1_author'] = "Nathan";
$_LANG['freemium_testimonials_1_url'] = "www.google.com";
$_LANG['freemium_testimonials_1_image'] = "testimonials-testimonials-1.png";
$_LANG['freemium_testimonials_1_alt'] = "client 1";
$_LANG['freemium_testimonials_1_image_url'] = "";
$_LANG['freemium_testimonials_1_image_url_newwindow'] = false;

// Testimonial 2

$_LANG['freemium_testimonials_2_display'] = true;
$_LANG['freemium_testimonials_2_displayorder'] = 0;
$_LANG['freemium_testimonials_2_animation'] = "fadeInUp";
$_LANG['freemium_testimonials_2_quote'] = "

<p>" . $_LANG['freemium_setting_companyname'] . " is the most reliable company I have come across for services. If you're looking for a reliable service look no further than " . $_LANG['freemium_setting_companyname'] . "! Sign-up today to see why they are the best!</p>

";
$_LANG['freemium_testimonials_2_author'] = "Joanna";
$_LANG['freemium_testimonials_2_url'] = "www.yahoo.com";
$_LANG['freemium_testimonials_2_image'] = "testimonials-testimonials-2.png";
$_LANG['freemium_testimonials_2_alt'] = "client 2";
$_LANG['freemium_testimonials_2_image_url'] = "";
$_LANG['freemium_testimonials_2_image_url_newwindow'] = false;

// Testimonial 3

$_LANG['freemium_testimonials_3_display'] = true;
$_LANG['freemium_testimonials_3_displayorder'] = 0;
$_LANG['freemium_testimonials_3_animation'] = "fadeInRight";
$_LANG['freemium_testimonials_3_quote'] = "

<p>I've been a customer with " . $_LANG['freemium_setting_companyname'] . " for over 5 years, they never fail to disappoint me and the service has been top notch since I created my first order with " . $_LANG['freemium_setting_companyname'] . ". Don't hesitate to join!</p>

";
$_LANG['freemium_testimonials_3_author'] = "George";
$_LANG['freemium_testimonials_3_url'] = "www.msn.com";
$_LANG['freemium_testimonials_3_image'] = "testimonials-testimonials-3.png";
$_LANG['freemium_testimonials_3_alt'] = "client 3";
$_LANG['freemium_testimonials_3_image_url'] = "";
$_LANG['freemium_testimonials_3_image_url_newwindow'] = false;






/*
-----------------------------------------
---------   Portal page (File: portal.tpl, portal.php)   ---------
-----------------------------------------
*/

$_LANG['freemium_portal_display'] = true;

// Button 1

$_LANG['freemium_portal_1_display'] = true;
$_LANG['freemium_portal_1_displayorder'] = 0;
$_LANG['freemium_portal_1_animation'] = "fadeInLeft";
$_LANG['freemium_portal_1_heading'] = "Client Area";
$_LANG['freemium_portal_1_url'] = "clientarea.php";
$_LANG['freemium_portal_1_url_newwindow'] = false;
$_LANG['freemium_portal_1_image'] = "portal-1.png";
$_LANG['freemium_portal_1_image_alt'] = "client area";
$_LANG['freemium_portal_1_text'] = "View & update your account details";

// Button 2

$_LANG['freemium_portal_2_display'] = true;
$_LANG['freemium_portal_2_displayorder'] = 0;
$_LANG['freemium_portal_2_animation'] = "fadeInLeft";
$_LANG['freemium_portal_2_heading'] = "Pre-Sales Contact Us";
$_LANG['freemium_portal_2_url'] = "contact.php";
$_LANG['freemium_portal_2_url_newwindow'] = false;
$_LANG['freemium_portal_2_image'] = "portal-2.png";
$_LANG['freemium_portal_2_image_alt'] = "contact us";
$_LANG['freemium_portal_2_text'] = "Place any pre-sales enquiries here";

// Button 3

$_LANG['freemium_portal_3_display'] = true;
$_LANG['freemium_portal_3_displayorder'] = 0;
$_LANG['freemium_portal_3_animation'] = "fadeInRight";
$_LANG['freemium_portal_3_heading'] = "Submit Ticket";
$_LANG['freemium_portal_3_url'] = "submitticket.php";
$_LANG['freemium_portal_3_url_newwindow'] = false;
$_LANG['freemium_portal_3_image'] = "portal-3.png";
$_LANG['freemium_portal_3_image_alt'] = "submit ticket";
$_LANG['freemium_portal_3_text'] = "Submit a support or sales request";

// Button 4

$_LANG['freemium_portal_4_display'] = true;
$_LANG['freemium_portal_4_displayorder'] = 0;
$_LANG['freemium_portal_4_animation'] = "fadeInRight";
$_LANG['freemium_portal_4_heading'] = "Downloads";
$_LANG['freemium_portal_4_url'] = "download";
$_LANG['freemium_portal_4_url_newwindow'] = false;
$_LANG['freemium_portal_4_image'] = "portal-4.png";
$_LANG['freemium_portal_4_image_alt'] = "downloads";
$_LANG['freemium_portal_4_text'] = "View our library of downloads";

// Button 5

$_LANG['freemium_portal_5_display'] = true;
$_LANG['freemium_portal_5_displayorder'] = 0;
$_LANG['freemium_portal_5_animation'] = "fadeInLeft";
$_LANG['freemium_portal_5_heading'] = "Support Tickets";
$_LANG['freemium_portal_5_url'] = "supporttickets.php";
$_LANG['freemium_portal_5_url_newwindow'] = false;
$_LANG['freemium_portal_5_image'] = "portal-5.png";
$_LANG['freemium_portal_5_image_alt'] = "support tickets";
$_LANG['freemium_portal_5_text'] = "View and respond to existing tickets";

// Button 6

$_LANG['freemium_portal_6_display'] = true;
$_LANG['freemium_portal_6_displayorder'] = 0;
$_LANG['freemium_portal_6_animation'] = "fadeInLeft";
$_LANG['freemium_portal_6_heading'] = "Knowledgebase";
$_LANG['freemium_portal_6_url'] = "knowledgebase";
$_LANG['freemium_portal_6_url_newwindow'] = false;
$_LANG['freemium_portal_6_image'] = "portal-6.png";
$_LANG['freemium_portal_6_image_alt'] = "knowledgebase";
$_LANG['freemium_portal_6_text'] = "Browse our KB for answers to FAQs";

// Button 7

$_LANG['freemium_portal_7_display'] = true;
$_LANG['freemium_portal_7_displayorder'] = 0;
$_LANG['freemium_portal_7_animation'] = "fadeInRight";
$_LANG['freemium_portal_7_heading'] = "Server Status";
$_LANG['freemium_portal_7_url'] = "serverstatus.php";
$_LANG['freemium_portal_7_url_newwindow'] = false;
$_LANG['freemium_portal_7_image'] = "portal-7.png";
$_LANG['freemium_portal_7_image_alt'] = "server status";
$_LANG['freemium_portal_7_text'] = "View live status info for our servers";

// Button 8

$_LANG['freemium_portal_8_display'] = true;
$_LANG['freemium_portal_8_displayorder'] = 0;
$_LANG['freemium_portal_8_animation'] = "fadeInRight";
$_LANG['freemium_portal_8_heading'] = "Order";
$_LANG['freemium_portal_8_url'] = "cart.php";
$_LANG['freemium_portal_8_url_newwindow'] = false;
$_LANG['freemium_portal_8_image'] = "portal-8.png";
$_LANG['freemium_portal_8_image_alt'] = "order";
$_LANG['freemium_portal_8_text'] = "Place a new order with us today";

// Button 9

$_LANG['freemium_portal_9_display'] = true;
$_LANG['freemium_portal_9_displayorder'] = 0;
$_LANG['freemium_portal_9_animation'] = "fadeInLeft";
$_LANG['freemium_portal_9_heading'] = "Domain Checker";
$_LANG['freemium_portal_9_url'] = "domain/pricing";
$_LANG['freemium_portal_9_url_newwindow'] = false;
$_LANG['freemium_portal_9_image'] = "portal-9.png";
$_LANG['freemium_portal_9_image_alt'] = "domain checker";
$_LANG['freemium_portal_9_text'] = "Register your perfect domain";

// Button 10

$_LANG['freemium_portal_10_display'] = true;
$_LANG['freemium_portal_10_displayorder'] = 0;
$_LANG['freemium_portal_10_animation'] = "fadeInLeft";
$_LANG['freemium_portal_10_heading'] = "Network Issues";
$_LANG['freemium_portal_10_url'] = "networkissues.php";
$_LANG['freemium_portal_10_url_newwindow'] = false;
$_LANG['freemium_portal_10_image'] = "portal-10.png";
$_LANG['freemium_portal_10_image_alt'] = "network issues";
$_LANG['freemium_portal_10_text'] = "Read about current and scheduled outages";

// Button 11

$_LANG['freemium_portal_11_display'] = true;
$_LANG['freemium_portal_11_displayorder'] = 0;
$_LANG['freemium_portal_11_animation'] = "fadeInRight";
$_LANG['freemium_portal_11_heading'] = "Affiliate Program";
$_LANG['freemium_portal_11_url'] = "affiliate-program.php";
$_LANG['freemium_portal_11_url_newwindow'] = false;
$_LANG['freemium_portal_11_image'] = "portal-11.png";
$_LANG['freemium_portal_11_image_alt'] = "affiliate program";
$_LANG['freemium_portal_11_text'] = "Become a " . $_LANG['freemium_setting_companyname'] . " affiliate";

// Button 12

$_LANG['freemium_portal_12_display'] = true;
$_LANG['freemium_portal_12_displayorder'] = 0;
$_LANG['freemium_portal_12_animation'] = "fadeInRight";
$_LANG['freemium_portal_12_heading'] = "Announcements";
$_LANG['freemium_portal_12_url'] = "announcements";
$_LANG['freemium_portal_12_url_newwindow'] = false;
$_LANG['freemium_portal_12_image'] = "portal-12.png";
$_LANG['freemium_portal_12_image_alt'] = "announcements";
$_LANG['freemium_portal_12_text'] = "View our latest news & announcements";






/*
-----------------------------------------
---------   Company page (File: company.tpl, company.php)  ---------
-----------------------------------------
*/

// Submenu

$_LANG['freemium_company_submenu_display'] = true;

$_LANG['freemium_company_submenu_1_display'] = true;
$_LANG['freemium_company_submenu_1_text'] = "Overview";
$_LANG['freemium_company_submenu_1_url'] = "#overview";
$_LANG['freemium_company_submenu_1_url_newwindow'] = false;

$_LANG['freemium_company_submenu_2_display'] = true;
$_LANG['freemium_company_submenu_2_text'] = "Why Choose Us";
$_LANG['freemium_company_submenu_2_url'] = "#whychooseus";
$_LANG['freemium_company_submenu_2_url_newwindow'] = false;

$_LANG['freemium_company_submenu_3_display'] = true;
$_LANG['freemium_company_submenu_3_text'] = "FAQs";
$_LANG['freemium_company_submenu_3_url'] = "#faqs";
$_LANG['freemium_company_submenu_3_url_newwindow'] = false;

// Overview

$_LANG['freemium_company_overview_display'] = true;
$_LANG['freemium_company_overview_reverse'] = true;

$_LANG['freemium_company_overview_heading'] = "Welcome To " . $_LANG['freemium_setting_companyname'];
$_LANG['freemium_company_overview_heading2'] = "We Provide Premium cPanel Hosting!";

$_LANG['freemium_company_overview_text'] = "<p>" . $_LANG['freemium_setting_companyname'] . " is miles above the rest as an exceptional web hosting company. We have many years of leading experience with global businesses of all sizes and have built up an affluence of web hosting expertise that put down us a scratch above other web hosting companies in this time. " . $_LANG['freemium_setting_companyname'] . " is a company that you can rely on for all of your web hosting. With 24 hour support and a money back guarantee there is no reason not to sign up today!</p>";

// Image

$_LANG['freemium_company_overview_image'] = "company.jpg";
$_LANG['freemium_company_overview_image_alt'] = "company premises";
$_LANG['freemium_company_overview_image_url'] = "";
$_LANG['freemium_company_overview_image_url_newwindow'] = false;
$_LANG['freemium_company_overview_image_text'] = "A look at our company premises";
$_LANG['freemium_company_overview_image_bold'] = true;

// Buttons

$_LANG['freemium_company_overview_button1_text'] = "Why Choose Us?";
$_LANG['freemium_company_overview_button1_icon'] = "fas fa-info-circle";
$_LANG['freemium_company_overview_button1_url'] = "#whychooseus";
$_LANG['freemium_company_overview_button1_url_newwindow'] = false;

$_LANG['freemium_company_overview_button2_text'] = "Get Started";
$_LANG['freemium_company_overview_button2_icon'] = "fas fa-angle-double-right";
$_LANG['freemium_company_overview_button2_url'] = "index.php#services";
$_LANG['freemium_company_overview_button2_url_newwindow'] = false;

// Company Bio

$_LANG['freemium_company_bio_text'] = "

<div class=\"headingstyle1\"><h2>Free Domain Name</h2></div>	

<p>As we are a pronounced web hosting company we include a free domain name registration/transfer with all of our web hosting plans. The domain name included with your hosting plan is yours to carry on forever.</p>

<div class=\"headingstyle1\"><h2>99.9% Uptime Guarantee</h2></div>	

<p>We offer a 99.9% uptime guarantee with all of our plans which is monitored by reliable third party companies. Whether it&#39;s the day or night, you can be confident that your website is safe in our professional hands.</p>

<div class=\"headingstyle1\"><h2>Disk Space &amp; Bandwidth</h2></div>	

<p>As we are prominent in our web hosting service, so you can get enormous storage for your files. We offer several tactics with diverse storage options.</p>

<div class=\"headingstyle1\"><h2>30 Days Money Back Guarantee</h2></div>	

<p>We also endow with a 30-days money back guarantee whereby you can claim your money back in full within a month of signing up without any questions asked.</p>

<div class=\"headingstyle1\"><h2>24/7 Support</h2></div>	

<p>Our experts are available 24 hours a day, 7 days a week by customer desk, live chat &amp; by phone for those times when you need help. Whether you need help with server assistance, registration of domains, transferring domain and websites, hosting related issues, control panel guidance we are here to assist you!</p>

<div class=\"headingstyle1\"><h2>Multiple Services To Fit Any Budget</h2></div>	

<p>We have the right web hosing plan for you, whether you&#39;re a big business corporate house or looking to setup your first Wordpress blog. We have a web hosting plan that&#39;s right for you!</p>

<div class=\"headingstyle1\"><h2>cPanel - Multi-Language Control Panel</h2></div>	

<p>We offer a multi-language, user-friendly control panel called cPanel. Languages supported are English, Portuguese, French, Dutch, Norwegian, Spanish, German, Russian, Ukrainian &amp; Bulgarian.</p>

<div class=\"headingstyle1\"><h2>Preinstalled Scripts</h2></div>	

<p>Preinstalled scripts make life much easier by allowing you to install any popular application/software without any web hosting knowledge. Whether you want to start a website, blog, forum or online store our 1 click, script installer has the right software for your needs. From Wordpress to Zen Cart, we have it all!</p>

";

// Why Choose Us

$_LANG['freemium_company_whychooseus_display'] = true;

$_LANG['freemium_company_whychooseus_heading'] = "Why Choose Us?";

// Why Choose Us 1

$_LANG['freemium_company_whychooseus_1_display'] = true;
$_LANG['freemium_company_whychooseus_1_displayorder'] = 0;
$_LANG['freemium_company_whychooseus_1_animation'] = "fadeInLeft";
$_LANG['freemium_company_whychooseus_1_heading'] = "Reliable Support";
$_LANG['freemium_company_whychooseus_1_image'] = "company-whychooseus-1.png";
$_LANG['freemium_company_whychooseus_1_image_alt'] = "reliable support";
$_LANG['freemium_company_whychooseus_1_image_url'] = "";
$_LANG['freemium_company_whychooseus_1_image_url_newwindow'] = false;
$_LANG['freemium_company_whychooseus_1_text'] = "

<p>As a " . $_LANG['freemium_setting_companyname'] . " customer you can expect to receive reliable support as we believe support is the most important factor. We provide support via our ticket system and live chat.</p>

";

// Why Choose Us 2

$_LANG['freemium_company_whychooseus_2_display'] = true;
$_LANG['freemium_company_whychooseus_2_displayorder'] = 0;
$_LANG['freemium_company_whychooseus_2_animation'] = "fadeInUp";
$_LANG['freemium_company_whychooseus_2_heading'] = "Passionate";
$_LANG['freemium_company_whychooseus_2_image'] = "company-whychooseus-2.png";
$_LANG['freemium_company_whychooseus_2_image_alt'] = "quality servers";
$_LANG['freemium_company_whychooseus_2_image_url'] = "";
$_LANG['freemium_company_whychooseus_2_image_url_newwindow'] = false;
$_LANG['freemium_company_whychooseus_2_text'] = "

<p>We provide many products and services and have a passion for the quality and support provided. Create your order with us today to see just how much this impacts our services.</p>

";

// Why Choose Us 3

$_LANG['freemium_company_whychooseus_3_display'] = true;
$_LANG['freemium_company_whychooseus_3_displayorder'] = 0;
$_LANG['freemium_company_whychooseus_3_animation'] = "fadeInRight";
$_LANG['freemium_company_whychooseus_3_heading'] = "We Love Renewable";
$_LANG['freemium_company_whychooseus_3_image'] = "company-whychooseus-3.png";
$_LANG['freemium_company_whychooseus_3_image_alt'] = "renewable";
$_LANG['freemium_company_whychooseus_3_image_url'] = "";
$_LANG['freemium_company_whychooseus_3_image_url_newwindow'] = false;
$_LANG['freemium_company_whychooseus_3_text'] = "

<p>We have a deep passion for renewable energy and environment friendly hosting services and we are always keen to further expand this focus and attention to detail.</p>

";

// FAQs

$_LANG['freemium_company_faqs_display'] = true;

$_LANG['freemium_company_faqs_heading'] = "FAQs";

$_LANG['freemium_company_faqs_question_heading'] = "Have A Question?";
$_LANG['freemium_company_faqs_question_text'] = "<p>If you can't find the answer you are looking for our support is just an email away.</p>";

$_LANG['freemium_company_faqs_question_button1_text'] = "Contact Us";
$_LANG['freemium_company_faqs_question_button1_icon'] = "fas fa-envelope";
$_LANG['freemium_company_faqs_question_button1_url'] = "contact.php";
$_LANG['freemium_company_faqs_question_button1_url_newwindow'] = false;

$_LANG['freemium_company_faqs_question_button2_text'] = "";
$_LANG['freemium_company_faqs_question_button2_icon'] = "";
$_LANG['freemium_company_faqs_question_button2_url'] = "";
$_LANG['freemium_company_faqs_question_button2_url_newwindow'] = false;

$_LANG['freemium_company_faqs_1_display'] = true;
$_LANG['freemium_company_faqs_1_displayorder'] = 0;
$_LANG['freemium_company_faqs_1_question'] = "How long have you been in business?";
$_LANG['freemium_company_faqs_1_answer'] = "<p>" . $_LANG['freemium_setting_companyname'] . " has been providing reliable services since early 2008.</p>";

$_LANG['freemium_company_faqs_2_display'] = true;
$_LANG['freemium_company_faqs_2_displayorder'] = 0;
$_LANG['freemium_company_faqs_2_question'] = "Which payment methods are available?";
$_LANG['freemium_company_faqs_2_answer'] = "<p>We accept payment via PayPal, credit/debit card & cryptocurrencies.</p>";

$_LANG['freemium_company_faqs_3_display'] = true;
$_LANG['freemium_company_faqs_3_displayorder'] = 0;
$_LANG['freemium_company_faqs_3_question'] = "Which methods of support do you provide?";
$_LANG['freemium_company_faqs_3_answer'] = "<p>You can contact support via email, ticket and live chat.</p>";






/*
-----------------------------------------
---------   Terms Of Service page (File: terms-of-service.tpl, terms-of-service.php)   ---------
-----------------------------------------
*/

$_LANG['freemium_page_terms_of_service'] = "

<p>This Web Hosting Agreement is between " . $_LANG['freemium_setting_companyname'] . " and the person/persons who use our website hosting and domain service. Please read carefully to ensure you understand our terms before purchasing any of our products or services.</p>

<h2>Services</h2>

<p>" . $_LANG['freemium_setting_companyname'] . " agrees to provide the services stated for the price agreed at any given time. We do not miss lead customers with hidden costs unlike many other web hosting companies.</p>

<h2>Terms</h2>

<p>All customers are responsible for monitoring their storage space and bandwidth transfer each month. Customers who go over the limit of their account will be sent an email with the option to either upgrade their account or reduce store and or storage. If customers continue to go over we will do everything possible to fix the problem. We do hold to right to ban accounts for continuous problems. If customers sign up for an account and cancel it within the first month they will still be charged for the full first month.</p>

<h2>Payments</h2>

<p>Renewal notices are emailed three days before the actual renew date in your account. If you're using a credit card you will not have to worry about manual payments. All accounts are set up on a pre-pay basis. If payment is not received within 7 days a $5 fee will be added. " . $_LANG['freemium_setting_companyname'] . " reserves the right to change prices at any time, unless other terms have been agreed upon. Any account not brought current within a week (7 days) of e-mail notice or exceeding this time frame in any way is subject to suspension. YOU are responsible for all fees owed on the account from the time it was established to the time that YOU notify " . $_LANG['freemium_setting_companyname'] . " to request for termination of services. Although we are based in the UK our websites currency is USD. YOUR particular billing cycle corresponds to the contract length that was initially chosen at setup. YOUR account will automatically renew at this length unless cancelled before hand. There is no fee for cancelled accounts that have been paid for yearly. If you cancel an account on the monthly billing cycle " . $_LANG['freemium_setting_companyname'] . " can not refund any payments made before.</p>

<p>All annual payments are non refundable once the 30 day money back guarantee has passed. The only time your annual plan will end is if your account does not comply with our terms of service/acceptable usage policy. Both monthly and annual payments are non-refundable if your account does not follow our terms of service/acceptable usage policy.</p>

<h2>Cancellation and Early Termination</h2>

<p>Customers must acknowledge that the amount of the services bought is based on customers agreement to pay the fee for the initial term or renewal term.</p>

<h2>Server Abuse</h2>

<p>Any attempt to undermine or cause harm to a server or customer of " . $_LANG['freemium_setting_companyname'] . " is strictly prohibited.</p>

<p>" . $_LANG['freemium_setting_companyname'] . " will strongly react to any use or attempted use of an Internet account or computer without the owner's authorization. Such attempts include 'Internet scamming' (tricking other people into releasing their passwords), password theft, security hole scanning, etc.</p>

<p>Any unauthorized use of accounts or computers by YOU, whether or not the attacked account or computer belongs to " . $_LANG['freemium_setting_companyname'] . ", will result in action against YOU. Possible actions include warnings, account suspension or cancelation, as well as civil or criminal legal action, depending on the seriousness of the attack.</p>

<p>IMPORTANT NOTE - " . $_LANG['freemium_setting_companyname'] . " has the right to discontinue service, or deny access to anyone who violates our policies or the terms and conditions shown below WITHOUT WARNING or PRIOR NOTICE. No refunds of fees paid will be made if account termination is due to violation of the terms outlined below.</p>

<p>YOU may not run IRC, bots or clients on shared servers. Unacceptable uses also include, but are NOT limited to: Bulk emailing, unsolicited emailing, newsgroup spamming, upload scripts (Rappidleach), pornographic content, illegal content, copyright infringement, trademark infringement, warez sites (including links to/from), cracks, software serial numbers, proxy-relaying, link farming (the act of or by use of scripts), link grinding, link-only sites, spamdexing, FFA (Free-For-All) and/or anything else determined by " . $_LANG['freemium_setting_companyname'] . " to be unacceptable use of our services including abuse of server resources.</p>

<p>WEB APPLICATIONS and WEB ACCESSIBLE SCRIPTS - All web applications that are out-of-date and actively being exploited will be shut down immediately without prior notice. YOU are responsible for and should evaluate YOUR web-based applications and scripts on a regular basis to ensure their security and orderliness.</p>

<p>Shared hosting accounts may also be terminated if it includes the following content or have links to the following content: Providing material that is grossly offensive to the Web community including blatant expressions of bigotry, racism, hatred, or profanity; promoting or providing instructional information about illegal activities; promoting physical harm or injury against any group or individual; displaying material containing obscene nudity or pornographic material (not applicable to managed dedicated servers); displaying material that exploits children under 18-years of age; acts of copyright infringement including offering pirated computer programs or links to such programs; information used to circumvent manufacturer-installed copy-protect devices, including serial or registration numbers for software programs, or any type of cracker utilities.</p>

<h2>Disk Space Abuse</h2>

<p>" . $_LANG['freemium_setting_companyname'] . " will be the sole arbiter as to what constitutes a violation of this provision. You are responsible for monitoring your disk space usage. If you need extra disk space contact one of our staff and they will be happy to help out. You can also upgrade your hosting plan from inside your " . $_LANG['freemium_setting_companyname'] . " client account.</p>

<h2>Bandwidth Abuse</h2>

<p>The intention of " . $_LANG['freemium_setting_companyname'] . " is to provide a large bandwidth to transfer web documents, and not an offsite storage area for electronic files. If YOU violate this condition, YOU will be notified and given 48 hours to remedy the problem. Failure to do so will result in YOU being billed for the overages.</p>

<p>Traffic will go unmonitored until YOU reach the amount of quota allocated to YOUR specific PLAN. " . $_LANG['freemium_setting_companyname'] . " will be the sole arbiter as to what constitutes a violation of this provision.</p>

<h2>AUP</h2>

<p>Customers agree to use our services under the <a href='acceptable-usage-policy.php'>Acceptable Usage Policy</a> which is here by incorporated with this agreement. Customers agree that " . $_LANG['freemium_setting_companyname'] . " hold the right to change their AUP at any time to meet web hosting standards and laws. Amendments to the AUP are effective on the earlier of " . $_LANG['freemium_setting_companyname'] . " notice to Customer that an amendment has been made, or the first day of any Renewal Term that begins subsequent to the amendment. Customer agrees to cooperate with " . $_LANG['freemium_setting_companyname'] . " reasonable investigation of any suspected violation of the AUP. In the event of a dispute between " . $_LANG['freemium_setting_companyname'] . " and Customer regarding the interpretation of the AUP, " . $_LANG['freemium_setting_companyname'] . " commercially reasonable interpretation of the AUP shall govern.</p>

<h2>Customer Information</h2>

<p>Customer represents and warrants to " . $_LANG['freemium_setting_companyname'] . " that the information he, she or it has provided and will provide to " . $_LANG['freemium_setting_companyname'] . " for purposes of establishing and maintaining the service is accurate. If Customer is an individual, Customer represents and warrants to " . $_LANG['freemium_setting_companyname'] . " that he or she is at least 18 years of age. " . $_LANG['freemium_setting_companyname'] . " may rely on the instructions of the person listed as the Primary Customer Contact on the Order with regard to Customer's account until Customer has provided a written notice changing the Primary Customer Contract.</p>

<h2>Unsolicited email &amp; spamming</h2>

<p>Unsolicited commercial advertisements ('SPAM') are not allowed in e-mail, and will likely result in account cancelation. " . $_LANG['freemium_setting_companyname'] . " takes a zero-tolerance approach to SPAM originating from its servers or for spam advertising of domains hosted within our network. If found, YOUR account may be deleted.</p>

<p>The following activities are not allowed: SPAM, which includes, but is not limited to, bulk mailing of commercial advertising, informational announcements, charity requests, petitions for signatures, and political or religious tracts (such messages may only be sent to those who have explicitly requested it from your domain); Forging, altering or removing electronic mail headers - any domain sending stealth spam will be terminated without warning and without refund. Sending numerous copies of the same or substantially similar message with the intent to disrupt a server or account ('mail bombing'); Spamming Newsgroups: Commercial advertisements are unwelcome in most Usenet discussion groups and on most e-mail mailing lists. Inappropriate posting may result in account cancelation. See the newsgroup or mailing list's charter for whether advertising is allowed or not. Sending a message to many different off-topic newsgroups, is particularly unethical and will be treated as such; Mail may not be used to harass or intimidate others. Harassment, whether through language, frequency of messages, or size of messages, is prohibited. Sending a single unwelcome message may be considered harassment. If a recipient asks to stop receiving e-mail, YOU must not send that person any further messages.</p>
<p>NOTE - If YOU use the services of another provider to promote a website hosted by or through " . $_LANG['freemium_setting_companyname'] . " ('spamvertising'), then the provisions of the above policy shall apply as if the SPAM were sent through our servers.</p>

<h2>99.99% Uptime Gurantee</h2>

<p>(1.) COVERAGE - This 99.99% uptime guarantee applies to any Customer in good financial standing with " . $_LANG['freemium_setting_companyname'] . " at the time of a service outage.</p>

<p>(2.) SERVICE LEVEL AGREEMENT ('SLA') &amp; SPECIFICATIONS - " . $_LANG['freemium_setting_companyname'] . " endeavors to have the content of YOUR website available for http access by any party in the world 99.99% of the time. Network downtime ('unavailability') is defined as 100% packet loss from " . $_LANG['freemium_setting_companyname'] . " to its backbone providers. Downtime is measured past 10 minutes after notification of network failure via " . $_LANG['freemium_setting_companyname'] . "'s online ticketing system. If the ticketing system itself is unreachable, the ticket must be started by calling the " . $_LANG['freemium_setting_companyname'] . " NOC.</p>

<p>" . $_LANG['freemium_setting_companyname'] . "'s administrators will determine the end of the downtime by a traceroute to YOUR machine from outside the " . $_LANG['freemium_setting_companyname'] . " network.</p>

<p>(3a.) SHARED HOSTING CREDITS - In the event that YOUR website is unavailable for less than 100%, " . $_LANG['freemium_setting_companyname'] . " will credit the following month's service fee as follows. YOUR credit shall be retroactive and measured in 24 hours a day of a calendar month, with the maximum credit not exceeding 50% of the monthly service charge for the affected month.</p>

<p>- 95% to 99.9% - YOUR account will be credited 10% of your monthly hosting fee<br />
- 90% to 94.9% - YOUR account will be credited 20% of your monthly hosting fee<br />
- 89.9% or below - YOUR account will be credited 50% of your monthly hosting fee (3b.)</p>

<p>Credit shall not be provided to YOU in the event that you have any outage resulting from:</p>

<p>- scheduled maintenance as posted from time to time at " . $_LANG['freemium_setting_companyname'] . ",<br />
- your behavior or the performance or failure of your equipment, facilities or applications,<br />
- circumstances beyond " . $_LANG['freemium_setting_companyname'] . "'s reasonable control, including, without limitation, acts of any governmental body, war, insurrection, sabotage, embargo, fire, flood, strike or other labor disturbance, interruption of or delay in transportation, unavailability of interruption or delay in telecommunications or third party services, including DNS propagation, domain name registration/transfer, failure of third party software or hardware or inability to obtain raw materials, supplies, or power used in or equipment needed for provision of your web site,<br />
- YOU breaking any agreement policy in " . $_LANG['freemium_setting_companyname'] . "'s 'Terms &amp; Conditions and AUP' causing a machine to fail as a result.</p>

<h2>Technical Support Limits</h2>

<p>" . $_LANG['freemium_setting_companyname'] . " provides technical support for YOU that encompasses within our area of expertise only. Such expertise includes assistance, troubleshooting, and debugging of our cPanel control panel interface, servers within our immediate responsibility and any other hosting related issues.</p>

<p>Unlike many hosting companies We do our best to help with scripts, templates and programing languages. However, under no circumstances is " . $_LANG['freemium_setting_companyname'] . " obligated to help YOU in the installations of new application modules, templates and/or programming languages, nor in providing assistance for any errors produced by any applications that have been modified by YOU previously.</p>

<h2>CGI Scripts</h2>

<p>Each shared web hosting account comes with its own CGI-BIN. YOU are free to use any CGI scripts YOU wish, however we reserve the rights to disable any CGI script that effects normal shared server operation without prior notice.</p>

<h2>Indemnification</h2>

<p>Customer agrees to indemnify and hold harmless " . $_LANG['freemium_setting_companyname'] . ", " . $_LANG['freemium_setting_companyname'] . "'s affiliates, and each of their respective officers, directors, agents, and employees from and against any and all claims, demands, liabilities, obligations, losses, damages, penalties, fines, punitive damages, amounts in interest, expenses and disbursements of any kind and nature whatsoever (including reasonable attorneys fees) brought by a third party under any theory of legal liability arising out of or related to the actual or alleged use of Customer's services in violation of applicable law or the AUP by Customer or any person using Customer's log on information, regardless of whether such person has been authorized to use the services by Customer.</p>

<p>YOU AGREE TO DEFEND,INDEMNIFY AND HOLD HARMLESS " . $_LANG['freemium_setting_companyname'] . " AGAINST LIABILITIES ARISING OF:</p>

<p>(1) ANY INJURY TO PERSON OR PROPERTY CAUSED BY ANY PRODUCTS SOLD OR OTHERWISE DISTRIBUTED IN CONNECTION WITH " . $_LANG['freemium_setting_companyname'] . "'S SERVER.<br />
(2) ANY MATERIAL SUPPLIED BY THE CUSTOMER INFRINGING OR ALLEGEDLY INFRINGING ON THE PROPRIETARY RIGHTS OF A THIRD PARTY<br />
(3) COPYRIGHT INFRINGEMENT AND<br />
(4) ANY DEFECTIVE PRODUCTS SOLD TO CUSTOMER FROM " . $_LANG['freemium_setting_companyname'] . "'S SERVER.</p>

<h2>Disclaimer of Warranties</h2>

<p>" . $_LANG['freemium_setting_companyname'] . " does not warrant or represent that the services will be uninterrupted, error free, or completely secure. To the extent permitted by applicable law " . $_LANG['freemium_setting_companyname'] . " disclaims any and all warranties including the implied warranties or merchantability, fitness for a particular purpose and non-infringement. To the extent permitted by applicable law all services are provided on an &quot;As Is&quot; basis.</p>

<h2>Limitation of Damages</h2>

<p>Neither party shall be liable to the other for any lost profits or any indirect, special incidental, consequential or punitive loss or damage of any kind, or for damages that could have been avoided by the use of reasonable diligence, arising in connection with the agreement, even if the party has been advised or should be aware of the possibility of such damages.</p>

<p>Notwithstanding anything else in the agreement to the contrary, the maximum aggregate liability of " . $_LANG['freemium_setting_companyname'] . " and any of its employees, agents or affiliates, under any theory of the law (including breach of contract, tort, strict liability and infringement) shall  be a payment of money not to exceed the amount payable by customer for the three months service.</p>

<h2>Suspension of Services/Termination</h2>

<p>Customer agrees that " . $_LANG['freemium_setting_companyname'] . " may suspend services to Customer without notice and without liability if: (i) " . $_LANG['freemium_setting_companyname'] . " reasonably believes that the services are being used in violation of the AUP; (ii) Customer fails to cooperate with any reasonable investigation of any suspected violation of the AUP; (iii) " . $_LANG['freemium_setting_companyname'] . " reasonably believes that the suspension of service is necessary to protect its network or its other customers, or (iv) as requested by a law enforcement or regulatory agency. Customer shall pay " . $_LANG['freemium_setting_companyname'] . " reasonable reinstatement fee if service is " . $_LANG['freemium_setting_companyname'] . " following a suspension of service under this subsection.</p>

<p>The Agreement may be terminated by Customer prior to the expiration of the Initial Term or any Renewal Term without further notice and without liability if " . $_LANG['freemium_setting_companyname'] . " fails in a material way to provide the service in accordance with the terms of the Agreement and does not cure the failure within ten (10) days of Customer's written notice describing the failure in reasonable detail. The Agreement may be terminated by " . $_LANG['freemium_setting_companyname'] . " prior to the expiration of the Initial Term or any Renewal Term without further notice and without liability as follows: (i) upon five (5) days notice if Customer is overdue on the payment of any amount due under the Agreement; (ii) Customer materially violates any other provision of the Agreement, including the AUP, and fails to cure the violation within thirty (30) days of a written notice from " . $_LANG['freemium_setting_companyname'] . " describing the violation in reasonable detail; (iii) upon one (1) days notice if Customer's Service is used in violation of a material term of the AUP more than once, or (iv) upon one (1) days notice if Customer violates Section 5 (Customer Information) of this Agreement. Either party may terminate this agreement upon five (5) days advance notice if the other party admits insolvency, makes an assignment for the benefit of its creditors, files for bankruptcy or similar protection, is unable to pay debts as they become due, has a trustee or receiver appointed over all or a substantial portion of its assets, or enters into an agreement for the extension or readjustment of all or substantially all of its obligations.</p>

<p>If you break our terms of service/acceptable usage policy we hold the right to cancel any services. We will never cancel any services without trying our best to resolve the problem with you. However in extreme cases such as an account containing child pornography we hold the right to cancel services without any prior warning. We do not refund any accounts breaking our terms of service/acceptable usage policy. For example if we cancel your hosting account during your first month for breaching copyright, we will not refund you for the first month. This is to prevent people signing up for our services with the intention of breaching our terms.</p>

<h2>Request For Customer Information</h2>

<p>Customer agrees that " . $_LANG['freemium_setting_companyname'] . " may, without notice to Customer, (i) report to the appropriate authorities any conduct by Customer or any of Customer's customers or end users that " . $_LANG['freemium_setting_companyname'] . " believes violates applicable law, and (ii) provide any information that it has about Customer or any of its customers or end users in response to a formal or informal request from a law enforcement or regulatory agency or in response to a formal request in a civil action that on its face meets the requirements for such a request.</p>

<h2>Back Up Copy</h2>

<p>Customer agrees to maintain a current copy of all content hosted by " . $_LANG['freemium_setting_companyname'] . " not with standing any agreement by " . $_LANG['freemium_setting_companyname'] . " to provide back up services.</p>

<h2>Request For Restore Of Hosting Package</h2>

<p>During any service term, customer may request up to one free restore for any reason of choice. If a customer should need to request a restore after this a $5 one time fee will be enforced.</p>

<h2>Changes To " . $_LANG['freemium_setting_companyname'] . "'s Network</h2>

<p>Upgrades and other changes in " . $_LANG['freemium_setting_companyname'] . "'s network, including, but not limited to changes in its software, hardware, and service providers, may affect the display or operation of Customer's hosted content and/or applications. " . $_LANG['freemium_setting_companyname'] . " reserves the right to change its network in its commercially reasonable discretion, and " . $_LANG['freemium_setting_companyname'] . " shall not be liable for any resulting harm to Customer.</p>

<h2>Notices</h2>

<p>Notices to " . $_LANG['freemium_setting_companyname'] . " under the Agreement shall be given via electronic mail to the e-mail address posted for customer support. Notices to Customer shall be given via electronic mail to the individual listed as the Primary Customer Contact on the Order. Notices are deemed received on the day transmitted, or if that day is not a business day, on the first business day following the day delivered. Customer may change his, her or its notice address by a notice given in accordance with this Section.</p>

<h2>Force Majored</h2>

<p>" . $_LANG['freemium_setting_companyname'] . " shall not be in default of any obligation under the Agreement if the failure to perform the obligation is due to any event beyond " . $_LANG['freemium_setting_companyname'] . "'s control, including, without limitation, significant failure of a portion of the power grid, significant failure of the Internet, natural disaster, war, riot, insurrection, epidemic, strikes or other organized labour action, terrorist activity, or other events of a magnitude or type for which precautions are not generally taken in the industry.</p>

<h2>Governing/Law Disputes</h2>

<p>The Agreement shall be governed by the laws of the State of Virginia, exclusive of its choice of law principles, and the laws of the United States of America, as applicable. The Agreement shall not be governed by the United Nations Convention on the International Sale of Goods.</p>

<h2>Miscellaneous</h2>

<p>Each party acknowledges and agrees that the other party retains exclusive ownership and rights in its trademarks, service marks, trade secrets, inventions, copyrights, and other intellectual property. Neither party may use the other party's name or trade mark without the other party's prior written consent. The parties intend for their relationship to be that of independent contractors and not a partnership, joint venture, or employer/employee. Neither party will represent itself to be agent of the other. Each party acknowledges that it has no power or authority to bind the other on any agreement and that it will not represent to any person that it has such power or authority. This Agreement may be amended only by a formal written agreement signed by both parties. The terms on Customer's purchase order or other business forms are not binding on " . $_LANG['freemium_setting_companyname'] . " unless they are expressly incorporated into a formal written agreement signed by both parties. A party's failure or delay in enforcing any provision of the Agreement will not be deemed a waiver of that party's rights with respect to that provision or any other provision of the Agreement. A party's waiver of any of its right under the Agreement is not a waiver of any of its other rights with respect to a prior, contemporaneous or future occurrence, whether similar in nature or not. The captions in the Agreement are not part of the Agreement, but are for the convenience of the parties. The following provisions will survive expiration or termination of the Agreement: Fees, indemnity obligations, provisions limiting liability and disclaiming warranties, provisions regarding ownership of intellectual property, these miscellaneous provisions, and other provisions that by their nature are intended to survive termination of the Agreement. There are no third party beneficiaries to the Agreement. Neither insurers nor the customers of resellers are third party beneficiaries to the Agreement. Customer may not transfer the Agreement without " . $_LANG['freemium_setting_companyname'] . "'s prior written consent. " . $_LANG['freemium_setting_companyname'] . "'s approval for assignment is contingent on the assignee meeting " . $_LANG['freemium_setting_companyname'] . "'s credit approval criteria. " . $_LANG['freemium_setting_companyname'] . " may assign the Agreement in whole or in part. This Agreement together with the Order and AUP constitutes the complete and exclusive agreement between the parties regarding its subject matter and supersedes and replace any prior understanding or communication, written or oral.</p>

<h2>Copyright Files</h2>

<p>All files stored on " . $_LANG['freemium_setting_companyname'] . "'s servers must be legally-owned and be accompanied with a valid license and/or copyright. This include and is not limiting to MP3, AVI, MID, MIDI, MPG, MPEG, MOV, EXE, ISO. Should we discover any unlicensed and/or illegal files within YOUR account, the files will be subjected to deletion.</p>

<h2>Cancelation Of Service</h2>

<p>" . $_LANG['freemium_setting_companyname'] . " reserves the right to cancel a service at any time. All fees paid in advance of cancellation will be pro-rated and paid by " . $_LANG['freemium_setting_companyname'] . " if we institutes our right of cancelation. Any violation of policies which results in extra costs billed to YOU.</p>

<h2>Promotional Rates &amp; Special Offers</h2>

<p>" . $_LANG['freemium_setting_companyname'] . " may offer subsequent promotional rates or special offers, the terms of which may or may not be more favorable than the terms and conditions for YOUR Services. Any such promotions or modifications shall not effect YOUR obligations under this Agreement. Promotional fees may be subject to additional terms and conditions which, to the extent they conflict with the terms of this Agreement, shall govern. Different promotional fees and special offers may not be combined together.</p>

<p>We have various special promotions that include a domain name. The cost of this domain name is usually covered by the first month's payment. As a result of this our promotions are not refundable and are not covered by our 30-day money back guarantee.</p>

<h2>Intellectual Property Rights</h2>

<p>Material accessible to you through " . $_LANG['freemium_setting_companyname'] . "'s services may be subject to protection under the United States or other copyright laws, or laws protecting trademarks, trade secrets and proprietary information. Except when expressly permitted by the owner of such rights, YOU must not use " . $_LANG['freemium_setting_companyname'] . " or its servers and network in a manner that would infringe, violate, dilute or misappropriate any such rights, with respect to any material that you access or receive through the " . $_LANG['freemium_setting_companyname'] . " network. If YOU use a domain name in connection with " . $_LANG['freemium_setting_companyname'] . " or similar service, YOU must not use that domain name in violation of any trademark, service mark, or similar rights of any third party.</p>

<h2>Network Security</h2>

<p>Customers may not use the " . $_LANG['freemium_setting_companyname'] . " network with an attempt to circumvent user authentication or security of any host, network, or account. This includes, but is not limited to, accessing data not intended for YOU, logging into a server or account YOU are not expressly authorized to access, password cracking, probing the security of other networks in search of weakness, or violation of any other organization's security policy. YOU may not attempt to interfere or deny service to any user, host, or network. This includes, but is not limited to, flooding, mail bombing, or other deliberate attempts to overload or crash a host or network. " . $_LANG['freemium_setting_companyname'] . " will cooperate fully with investigations for violations of systems or network security at other sites, including cooperating with law enforcement authorities in the investigation of suspected criminal violations. Users who violate system or network security may incur criminal or civil liability.</p>

<h2>Electronic Commerce</h2>

<p>YOU will be solely responsible for the development, operation and maintenance of YOUR online store and products along with all content and materials appearing online or on YOUR products, including without limitation:</p>

<p>(a.) the accuracy and appropriateness of content and materials appearing within the store or related to YOUR products,<br />(b.) ensuring that the content and materials appearing within the store or related to YOUR products do not violate or infringe upon the rights of any third party, and<br />(c.) ensuring that the content and materials appearing within the store or related to YOUR products are not libelous or otherwise illegal. YOU will be solely responsible for the final calculation and application of shipping and sales tax. YOU will also be solely responsible for accepting, processing, and filling any customer orders, and for handling any customer inquiries or complaints arising there from.</p>

<p>YOU are also responsible for the security of any customer credit card numbers and related customer information YOU may access as a result of conducting electronic commerce transactions through YOUR website. YOU will keep all such information confidential and will use the same degree of care and security as YOU use with your confidential information.</p>

<h2>Static &amp; Dynamic Content Caching</h2>

<p>YOU expressly</p>

<p>(i) grant to " . $_LANG['freemium_setting_companyname'] . " a license to cache the entirety of YOUR website, including content supplied by third parties, hosted by " . $_LANG['freemium_setting_companyname'] . " under this Agreement and<br />(ii) agree that such caching is not an infringement of any of YOUR intellectual property rights or any third party's intellectual property rights.</p>

<h2>IP Address Ownership</h2>

<p>" . $_LANG['freemium_setting_companyname'] . " shall maintain and control ownership of all IP numbers and addresses that may be assigned to YOU by " . $_LANG['freemium_setting_companyname'] . ". " . $_LANG['freemium_setting_companyname'] . " reserves, in its sole discretion, the right to change or remove any and all such IP numbers and addresses.</p>

<h2>Domain Name Registration</h2>

<p>YOU agree to pay " . $_LANG['freemium_setting_companyname'] . " prior to the effectiveness of the desired domain name registration, the then-current amount set forth in the " . $_LANG['freemium_setting_companyname'] . " price schedule for the initial registration of the domain name and, should YOU choose to renew the registration, subsequent renewals of the registration. All fees are non-refundable, in whole or in part, even if YOUR domain name registration is suspended, canceled or transferred prior to the end of YOUR then current registration term. " . $_LANG['freemium_setting_companyname'] . " reserves the right to change fees, surcharges, renewal fees or to institute new fees at any time, for any reason, at its sole discretion. YOUR requested domain name will not be registered unless and until we receive actual payment of the registration fee, and have confirmed YOUR registration in an email from " . $_LANG['freemium_setting_companyname'] . " to the email address indicated in YOUR registration application. In the event of a chargeback by a credit card company (or similar action by another payment provider allowed by " . $_LANG['freemium_setting_companyname'] . ") in connection with the payments of the registration fee for YOUR domain name registration, YOU agrees and acknowledges that the domain name registration shall be transferred to " . $_LANG['freemium_setting_companyname'] . " as the paying entity for that registration to the registry and that we reserve all rights regarding such domain name including, without limitation, the right to make the domain name available to other parties for purchase. " . $_LANG['freemium_setting_companyname'] . " will reinstate YOUR domain name registration solely at " . $_LANG['freemium_setting_companyname'] . "'s discretion, and subject to our receipt of the initial registration or renewal fee and our then-current reinstatement fee.</p>

<p>Transfer domain registrar to " . $_LANG['freemium_setting_companyname'] . "</p>

<p>YOU agree to pay " . $_LANG['freemium_setting_companyname'] . " prior to the effectiveness of the desired domain name transfer request, the then-current amount set forth in the " . $_LANG['freemium_setting_companyname'] . " price schedule for the initial transfer request of the domain name. YOU agree and acknowledge that the domain name transfer will fail, and all fees are non-refundable, for the following reasons, but not limited to:</p>

<p>- No response from the Registered Name Holder or Administrative Contact<br />
- Domain name in Registrar Lock Status<br />
- Domain name registration period time expires or other constraints, other than during the first 60 days of initial registration or during the first 60 days after a registrar transfer</p>

<p>" . $_LANG['freemium_setting_companyname'] . " reserves the right to change fees, surcharges, renewal fees or to institute new fees at any time, for any reason, at its sole discretion. YOUR requested domain name will not be registered unless and until we receive actual payment of the registration fee, and have confirmed YOUR registration in an email from " . $_LANG['freemium_setting_companyname'] . " to the email address indicated in YOUR registration application. In the event of a chargeback by a credit card company (or similar action by another payment provider allowed by " . $_LANG['freemium_setting_companyname'] . ") in connection with the payments of the registration fee for YOUR domain name registration, YOU agrees and acknowledges that the domain name registration shall be transferred to " . $_LANG['freemium_setting_companyname'] . " as the paying entity for that registration to the registry and that we reserve all rights regarding such domain name including, without limitation, the right to make the domain name available to other parties for purchase. " . $_LANG['freemium_setting_companyname'] . " will reinstate YOUR domain name registration solely at " . $_LANG['freemium_setting_companyname'] . " discretion, and subject to our receipt of the initial registration or renewal fee and our then-current reinstatement fee.</p>

<p>Transfer domain away from " . $_LANG['freemium_setting_companyname'] . "</p>

<p>" . $_LANG['freemium_setting_companyname'] . " reserves all rights, without limitation, to reject the domain name transfer request for the following reasons, but not limited to:</p>

<p>- No response from the Registered Name Holder or Administrative Contact<br />
- Domain name in Registrar Lock Status and there is no request from Registered Name Holder or Administrative Contact for the status change<br />- Domain name registration period time will be expiring in less than 60 days or other constraints, other than during the first 60 days of initial registration or during the first 60 days after a registrar transfer</p>

<p>YOU agree and acknowledge that the failure or success of a domain name transfer will be his/her sole responsibility, and " . $_LANG['freemium_setting_companyname'] . " will not be held liable for the failure of a domain name transfer for any reason.</p>

<p>Domain registrations are non-refundable. Please do not purchase the domain name until you are certain that it is exactly what you would like to buy.</p>

<h2>Lawful Purpose</h2>

<p>" . $_LANG['freemium_setting_companyname'] . " reserves the right to refuse service to anyone. YOU may only use " . $_LANG['freemium_setting_companyname'] . " server for lawful purposes and our services may not be used for illegal purposes or in support of illegal activities. We reserve the right to cooperate with legal authorities and/or injured third parties in the investigation of any suspected crime or civil wrongdoing. If anything is not legal in the United States of America, it is not permitted to reside on our servers. Transmission, distribution or storage of any material in violation of any applicable law or regulation is prohibited. This includes but not limiting material protected by copyright, trademark, trade secret or other intellectual property right used without proper authorization, and material that is obscene, defamatory, constitutes an illegal threat, or violates export control laws. Examples of non-acceptable content or links: 'Pirated Warez', OGG, AVI, MPEG, ISO, 'Hacker programs or archives', 'Copyrighted Digital Movie Copies (DIVX)' and 'Unlicensed MP3'. The designation of any materials as such described above is left entirely to the discretion of " . $_LANG['freemium_setting_companyname'] . " management.</p>

<p>If illegal content or usage is found, the account will be suspended and/or terminated. YOU agree that " . $_LANG['freemium_setting_companyname'] . " may disclose any and all YOUR information including assigned IP numbers, account history, account use, etc. to any law enforcement agent who makes a written request without further consent or notification.</p>

<p>Regardless of the place of signing this agreement, YOU agree that for purposes of venue this contract is entered in Fremont, California, and any dispute will be litigated or arbitrated in Fremont, California. Defendants further waive all objections to venue and acknowledge that venue in any such litigation will be held in Fremont courts. IN NO EVENT SHALL " . $_LANG['freemium_setting_companyname'] . "'S MAXIMUM LIABILITY EXCEED FIVE HUNDRED ($500.00) DOLLARS.</p>

<h2>Privacy Statement</h2>

<p>" . $_LANG['freemium_setting_companyname'] . " follows the strict guidelines of our customer privacy statement. Please make sure you understand this statement fully.</p>

";






/*
-----------------------------------------
---------   Acceptable Usage Policy page (File: acceptable-usage-policy.tpl, acceptable-usage-policy.php)   ---------
-----------------------------------------
*/

$_LANG['freemium_page_acceptable_usage_policy'] = "

<p>This AUP governs the use of " . $_LANG['freemium_setting_companyname'] . "&#39;s web hosting service. Violation of this AUP may result in suspension or termination of your service. In the event of a dispute between you and " . $_LANG['freemium_setting_companyname'] . " regarding the interpretation of this AUP, " . $_LANG['freemium_setting_companyname'] . "'s interpretation, in its reasonable commercial judgment, shall govern.</p>

<p>The following is the entire Acceptable User Policy ('AUP') agreement between " . $_LANG['freemium_setting_companyname'] . " and the personal or corporate account holder. " . $_LANG['freemium_setting_companyname'] . " provides World Wide Web Hosting, web design and script installation. " . $_LANG['freemium_setting_companyname'] . " has certain legal and ethical responsibilities consisting with the use of its servers and equipment involved in these services. " . $_LANG['freemium_setting_companyname'] . "'s general policy is to act as a provider of Internet presence. " . $_LANG['freemium_setting_companyname'] . " reserves the rights to suspend or cancel a customer's access to any or all services provided by " . $_LANG['freemium_setting_companyname'] . " when we decide that the account has been inappropriately used.</p>

<h2>What is Appropriate Usage?</h2>

<p>" . $_LANG['freemium_setting_companyname'] . " is designed to serve the web hosting needs of small, independently owned and operated businesses in a single country. It is not appropriate to use our services to support large enterprises or internationally based businesses with a sustained demand that places undue burden on our systems or negatively impacts use by small, independently owned and operated businesses.</p>

<p>" . $_LANG['freemium_setting_companyname'] . " is a shared web hosting service, which means that a number of customers' web sites and other email or storage services are hosted from the same server. " . $_LANG['freemium_setting_companyname'] . " uses abuse controls to help ensure that use of our services does not adversely affect the performance of our system or other customers' sites. It is not appropriate to use an account primarily as an online storage space or for archiving electronic files.</p>

<h2>Disk Space</h2>

<p>If you use your services consistently with the <a href=\"terms-of-service.php\">Terms Of Service</a> and these paragraphs, your site can grow as large as necessary to meet your small business needs, but to ensure a great experience for all, we will place some constraints on how fast you can grow. The vast majority of our customers' sites grow at rates well within our rules, but our abuse controls may cause a brief delay while we evaluate if expansion is appropriate for your particular plan.</p>

<p>" . $_LANG['freemium_setting_companyname'] . " Customers may not initiate the following (below), if any customer does " . $_LANG['freemium_setting_companyname'] . " may terminate the account with no refund. Depending on the situation there will/won't be warnings sent.<br />
a) Use 25% or more of system CPU resources for longer then 90 seconds or 1% of the servers CPU resources for longer than 5 minutes. There are numerous activities that could cause such problems; these include: CGI scripts, FTP, PHP, HTTP, etc.<br />
b) Use of any kind of distributed computing software, including but not limited to SETI@home, Node Zero and Folding@home.<br />
c) Run any type of interactive real-time chat applications that require server resources. Remotely-hosted services are fully allowed.<br />
d) Run stand-alone, unattended server-side processes at any point in time on the server. This includes any and all daemons.<br />
e) Run any software that interfaces with an IRC (Internet Relay Chat) network.<br />
f) Run any file sharing, bit torrent or other P2P network services, client or server software.<br />
g) Run any gaming servers such as counter-strike, half-life, battlefield 1492 etc</p>

<h2>Bandwidth</h2>

<p>In most cases, if you use our services consistently with our <a href=\"terms-of-service.php\">Terms Of Service</a>, visitors to your web site will be able to download and view as much content from your site as they like. However, in certain circumstances, our server processing power, server memory, or abuse controls could limit downloads from your site. You will always be able to use as much bandwidth as your account has. For example our Enterprise Plan comes with 40GB bandwidth which is a huge amount, all of this 40GB can be used. Bandwidth is also reset every month.</p>

<p>You are allocated a monthly bandwidth allowance. This allowance varies depending on the hosting package you purchase. Should your account pass the allocated amount we reserve the right to suspend the account until the start of the next allocation, suspend the account until more bandwidth is purchased at an additional fee, suspend the account until you upgrade to a higher level of package, terminate the account and/or charge you an additional fee for the overages. Unused transfer in one month cannot be carried over to the next month.</p>

<h2>Email Storage</h2>

<p>You do not have to worry about hitting a storage limit if you use our services consistently with the <a href=\"terms-of-service.php\">Terms Of Service</a> and our acceptable usage policy. " . $_LANG['freemium_setting_companyname'] . " will increase your space along with your appropriate small business needs, but our abuse controls may impact the rate of growth or your folder size, and there may be a short delay while we assess your usage. In some cases, creating additional folders or subfolders will help ensure that the system works well for everyone. You will always be allowed to use as much disk space is applied to your account.</p>

<h2>Unlimited</h2>

<p>You may have noticed all of our accounts come with unlimited email accounts, sub-domains, FTP accounts and in some cases domains. This is subject to how much disk space your account has. So you can create as many emails, sub-domains etc as you want as long as it's within your disk space limit.</p>

<h2>Offensive Content</h2>

<p>You may not publish or transmit via " . $_LANG['freemium_setting_companyname'] . "'s service any content that " . $_LANG['freemium_setting_companyname'] . " reasonably believes:<br />
a) constitutes child pornography;<br /> 
b) constitutes pornography;<br />
c) is excessively violent, incites violence, threatens violence, or contains harassing content or hate speech;<br /> 
d) is unfair or deceptive under the consumer protection laws of any jurisdiction, including chain letters and pyramid schemes;<br /> 
e) is defamatory or violates a person's privacy;<br /> 
f) creates a risk to a person's safety or health, creates a risk to public safety or health, compromises national security, or interferes with a investigation by law enforcement;<br />
g) improperly exposes trade secrets or other confidential or proprietary information of another person;<br /> 
h) is intended to assist others in defeating technical copyright protections;<br />
i) clearly infringes on another person's trade or service mark, patent, or other property right;<br />
j) promotes illegal drugs, violates export control laws, relates to illegal gambling, or illegal arms trafficking;<br />
k) is otherwise illegal or solicits conduct that is illegal under laws applicable to you or to " . $_LANG['freemium_setting_companyname'] . ";<br />
l) is otherwise malicious, fraudulent, or may result in retaliation against " . $_LANG['freemium_setting_companyname'] . " by offended viewers;</p>

<p>" . $_LANG['freemium_setting_companyname'] . " does not accept material such as:<br />
a) Proxy, Warez, Escrow, High Yield Investment Programs (HYIP), illegal Gambling and Lottery sites.<br />
b )Content 'published or transmitted' via " . $_LANG['freemium_setting_companyname'] . "'s service includes Web content, e-mail, bulletin board postings, chat, and any other type of posting or transmission that relies on any Internet service provided by " . $_LANG['freemium_setting_companyname'] . ".<br /> 
* " . $_LANG['freemium_setting_companyname'] . " can terminate service for any of the above reasons and it's at " . $_LANG['freemium_setting_companyname'] . "'s sole discretion to issue a refund</p>

<h2>Security</h2>

<p>You must take reasonable security precautions. You must protect the confidentiality of your password, and you should change your password periodically.</p>

<h2>Bulk Comercial Email</h2>

<p>Bulk commercial email, mailing lists and email reflectors are allowed on " . $_LANG['freemium_setting_companyname'] . "'s servers, we do however allow a maximum of 500 emails per hour per account. For any emails sent from your " . $_LANG['freemium_setting_companyname'] . " account you must adhere to the following rules:</p>

<p>a) Your intended recipients have given their consent to receive e-mail via some affirmative means, such as an opt-in procedure;<br />b) Your procedures for soliciting consent include reasonable means to ensure that the person giving consent is the owner of the e-mail address for which the consent is given;<br />c) You may not obscure the source of your e-mail in any manner.<br />
d) You otherwise comply with the CAN SPAM Act and other applicable law.</p>

<p>These policies apply to messages sent using your " . $_LANG['freemium_setting_companyname'] . " service, or to messages sent from any network by you or any person on your behalf that directly or indirectly refer the recipient to a site hosted via your " . $_LANG['freemium_setting_companyname'] . " service. In addition, you may not use a third party e-mail service that does not practice similar procedures for all its customers.</p>

<h2>Unsolicited E-Mail</h2>

<p>You may not send any unsolicited e-mail, either in bulk or individually, to any person who has indicated that they do not wish to receive it. You must comply with the rules of any other network you access or participate in using your " . $_LANG['freemium_setting_companyname'] . "'s services.</p>

<h2>Material Protected By Copyright</h2>

<p>You may not publish, distribute, or otherwise copy in any manner any music, software, art, or other work protected by copyright law unless:<br />
a) you have been expressly authorized by the owner of the copyright for the work to copy the work in that manner.<br />
b) you are otherwise permitted by established United States copyright law to copy the work in that manner.</p>

<p>" . $_LANG['freemium_setting_companyname'] . " will terminate the service of repeat copyright infringers.</p>

<h2>Other</h2>

<p>You must have valid and current information on file with your domain name registrar for any domain hosted on the " . $_LANG['freemium_setting_companyname'] . " network.</p>

<h2>Disclaimer</h2>

<p>" . $_LANG['freemium_setting_companyname'] . " is under no duty, and does not by this AUP undertake a duty, to monitor or police our customers' activities and disclaims any responsibility for any misuse of the " . $_LANG['freemium_setting_companyname'] . " network.</p>

<h2>Internet Abuse</h2>

<p>You may not engage in illegal, abusive, or irresponsible behaviour, including:</p>

<p>a) Unauthorized access to or use of data, systems or networks, including any attempt to probe, scan or test the vulnerability of a system or network or to breach security or authentication measures (including those belonging to " . $_LANG['freemium_setting_companyname'] . " and its customers) without express authorization of the owner of the system or network;<br />
b) monitoring data or traffic on any network or system without the authorization of the owner of the system or network;<br />
c) Interference with service to any user, host or network including, without limitation, mail bombing, flooding, deliberate attempts to overload a system and broadcast attacks;<br />
d) Use of an Internet account or computer without the owner's authorization, including, but not limited to Internet scanning (tricking other people into releasing their passwords), password robbery, security hole scanning, and port scanning;<br />
e) Forging of any TCP-IP packet header or any part of the header information in an e-mail or a newsgroup posting; or<br />
f) Any conduct that is likely to result in retaliation against the " . $_LANG['freemium_setting_companyname'] . " network.<br />
g) Use of " . $_LANG['freemium_setting_companyname'] . "'s network in a way that unreasonably interferes with " . $_LANG['freemium_setting_companyname'] . "'s other customers use of the network</p>

<h2>Newsgroup, Chat Forums, Other Networks</h2>

<p>You must comply with the rules and conventions for postings to any bulletin board, chat group or other forum in which you participate, such as IRC and USENET groups including their rules for content and commercial postings. These groups usually prohibit the posting of off-topic commercial messages, or mass postings to multiple forums.</p>

";






/*
-----------------------------------------
---------   Privacy Policy page (File: privacy-policy.tpl, privacy-policy.php)   ---------
-----------------------------------------
*/

$_LANG['freemium_page_privacy_policy'] = "

<p>Your privacy is very important to us, below explains the information we collect from you, what we do with that information and our information security policy.</p>

<h2>Your Information</h2>

<p>When you sign up for any of our services we will ask you to provide contact information for your convenience as well as legal reasons. This will include name, home address, e-mail addresses and payment details (credit or debit card and PayPal). If you need support our staff may need to know information to solve the problem such as operating system, browser software and editing software. When you visit this website we do record certain information using Google Analytics such as your location, browser version, ip address, screen resolution, operating system and flash support. This is so we can continue to provide the most convenient web site for all our visitors. Our website is protected by a Secure Sockets Layer (SSL) and verified by Equifax. This helps prevent eavesdropping on our website, just look for the padlock.</p>

<h2>How Your Information Is Used</h2>

<p>We will use your personal identifiable information in the following ways.</p>

<p>- For payment purposes and to provide convenient and targeted support.<br />
- To contact you and announce special offers, general announcements and news. Please note you can opt out of receiving these emails at anytime by following the instructions at the bottom of the e-mail.<br />
- To improve our service and the marketing of our service. This could include using your demographic location to improve targeting of our website and customise your visit.</p>

<p>We will <strong>NEVER</strong> provide your personally identifiable information to any persons other than A law enforcement or regulatory agency at their request, third parties who provide services on our behalf such as payment processing, only if they agree not to miss use this information.</p>

<p><strong>We do not under any circumstances apart from the above give away or sell your information to any third parties.</strong></p>

<p>Your personal information is <strong>safe with us</strong>, your information is safely encrypted using SSI. Our service is not available to anyone under the age of 13, never will we intentionally maintain information about anyone under the age of 13.</p>

<h2>Cookies</h2>

<p>A cookie is a small text file that is stored on a users computer for record-keeping purposes. We use cookies on this site. We do not link the information we store in cookies to any personally identifiable information you submit while on our site. We use both session ID cookies and persistent cookies. We use session cookies to make it easier for you to navigate our site. A session ID cookie expires when you close you browser. A persistent cookie remains on your hard drive for an extended period of time much like the cookie used for our affiliate program. You can remove persistent cookies by following directions provided in your Internet browsers &#39;help&#39; file. We set a persistent cookie to store your passwords, so you do not have to enter it more than once. Persistent cookies also enable us to track and target the interests of our users to enhance the experience on our site. If you reject cookies, you may still use our site, but you will be asked to enter your username and password again every time you closed your browser or your session has timed out.</p>

<h2>Log Files</h2>

<p>As is true of most Web sites, we gather certain information automatically and store it in log files. This information includes Internet protocol (IP) addresses, browser type, internet service provider (ISP), referring/exit pages, operating system, date/time stamp, and clickstream data. We use this information, which does not identify individual users, to analyze trends, to administer the site, to track users movements around the site and to gather demographic information about our user base as a whole. We do not link this automatically-collected data to personally identifiable information. IP addresses are tied to personally identifiable information to prevent and block abusers to keep using our services such as members who violates our terms of service. We use a third-party tracking service that uses cookies and log files to track non-personally identifiable information about visitors to our site in the aggregate of usage and volume statistics to determine how our users navigate through our website and to know how many users are using our services demographically. We use the information you provide about yourself or others to complete the transaction for which it is intended. This may include administering a service such as registration, email, forum, etc., or contacting you if you have indicated your permission to do so by agreeing to accept further notification and service announcement from us on your member profile page. You can choose to opt-out from receiving any further notification from your member profile page. We do not share this information with outside parties.</p>

<h2>Surveys</h2>

<p>Upon using our free services, you may be requested to participate in our periodic internal surveys that are conducted by " . $_LANG['freemium_setting_companyname'] . " to determine your personal interests. These surveys are strictly voluntary. The data collected through these surveys will only be used to improve our products and services and will never be sold to any third parties.</p>

<h2>Communications From The Site</h2>

<p>When we receive email, we use return email addresses to reply with the information requested. Such addresses are not used for any other purpose and are not shared with outside parties. When supplying contact information to " . $_LANG['freemium_setting_companyname'] . " you can indicate your preference if you would like to be contacted to receive information and updates about our services by logging in to your " . $_LANG['freemium_setting_companyname'] . " account, going to your member profile page and choose not to receive any further notification emails from us or other information pertaining to " . $_LANG['freemium_setting_companyname'] . ". Information you submit to us will not be used for this purpose unless you indicate this as your preference. When supplying contact information to " . $_LANG['freemium_setting_companyname'] . " you can indicate your preference on your members profile page to participate in the " . $_LANG['freemium_setting_companyname'] . " newsletter. You will receive a confirmation email from us when placing an order on our site and paying through PayPal.</p>

<h2>Newsletter</h2>

<p>We provide you the opportunity to &#39;opt-in&#39; and &#39;opt-out&#39; of our newsletter at any time. Our newsletter is sent every month so it will certainly contain allot of useful information and any offers we may have. If you no longer wish to receive our newsletter and promotional communications, you may opt-out of receiving them at any time.</p>

<h2>Information Sharing and Disclosure</h2>

<p>We collect information from our website visitors using <a href=\"https://www.google.com/analytics/\" target=\"_blank\" rel=\"nofollow\">Google Analytics</a>. We use this information to better design our Web site and services. This information is never shared with any third party. We do not link aggregate user data with personally identifiable information.</p>

<h2>Personally Identifiable Information</h2>

<p>" . $_LANG['freemium_setting_companyname'] . " does not share, sell, rent, or trade personally identifiable information with third parties. We never use or share the personally identifiable information provided to us online in ways unrelated to the ones described within this privacy policy without also providing you an opportunity to opt-out or otherwise prohibit such unrelated uses.</p>

<h2>How You Can Access /Correct Your Information</h2>

<p>You can access all your personally identifiable information that we collect by logging into your password-protected " . $_LANG['freemium_setting_companyname'] . " account and selecting to update your &#39;My Details&#39; We use this procedure to better safeguard your information. You can also correct factual errors in your personally identifiable information by sending us a request that credibly shows error. To protect your privacy and security, we will also take reasonable steps to verify your identity before granting access or making corrections.</p>

<h2>Specific Terms and Conditions</h2>

<p>" . $_LANG['freemium_setting_companyname'] . " considers email transmitted via our service to be the private correspondence between the sender and recipient. We will not monitor, edit or disclose the contents of a user`s private communications, except as required by law, to comply with legal process, if necessary to enforce the Service Agreement, to respond to claims that such contents violate the rights of third-parties, or to protect the rights or property of " . $_LANG['freemium_setting_companyname'] . ". By using the service you agree that technical processing of email communications is and may be required to send and receive messages, to conform to the technical requirements of connecting networks, to conform to the limitations of the Service, or to conform to other, similar technical requirements. By using the service you acknowledge and agree that " . $_LANG['freemium_setting_companyname'] . " do not endorse the content of any user communications and are not responsible or liable for any unlawful, harassing, libellous, privacy invading, abusive, threatening, harmful, vulgar, obscene, tortuous, or otherwise objectionable content, or content that infringes or may infringe the intellectual property or other rights of another.</p>

<h2>Legal Disclaimer</h2>

<p>We reserve the right to disclose your personally identifiable information as required by law and when we believe that disclosure is necessary to protect our rights and/or to comply with a judicial proceeding, court order, or legal process served on our Web site.</p>

<h2>Security</h2>

<p>The security of your personal information is important to us. We follow generally accepted industry standards to protect the personal information submitted to us, both during transmission and once we receive it. No method of transmission over the Internet, or method of electronic storage, is 100% secure, however we have taken every step possible to make your information safe. This website is protected by Secure Sockets Layer (SSL) to protect your information. Therefore, while we strive to use commercially acceptable means to protect your personal information, we cannot guarantee its absolute security.</p>

<h2>Links To Other Sites</h2>

<p>This Web site contains links to other sites that are not owned or controlled by " . $_LANG['freemium_setting_companyname'] . ". Please be aware that we, " . $_LANG['freemium_setting_companyname'] . " are not responsible for the privacy practices of such other sites. We encourage you to be aware when you leave our site and to read the privacy statements of each and every Web site that collects personally identifiable information. This privacy statement applies only to information collected by this Web site.</p>

<h2>Changes To This Privacy Statement</h2>

<p>If we decide to change our privacy policy, we will post those changes to this privacy statement, the home page, and other places we deem appropriate so that you are aware of what information we collect, how we use it, and under what circumstances, if any, we disclose it. We reserve the right to modify this privacy statement at any time, so please review it frequently. If we make material changes to this policy, we will notify you here, by email, or by means of a notice on our home page. For more information please do not hesitate to send your questions via our <a href=\"contact.php\">Contact Form</a>.</p>

";






/*
-----------------------------------------
---------   Addon pages - earn a commission promoting our products/services   ---------
-----------------------------------------
*/

// Global

$_LANG['freemium_addons_onetime'] = "one time";

$_LANG['freemium_addons_button1_text'] = "Learn More";
$_LANG['freemium_addons_button1_icon'] = "fas fa-info-circle";

$_LANG['freemium_addons_button2_text'] = "View Demo";
$_LANG['freemium_addons_button2_icon'] = "fas fa-search";

$_LANG['freemium_addons_button3_text'] = "Order Now";
$_LANG['freemium_addons_button3_icon'] = "fas fa-shopping-cart";






/*
-----------------------------------------
---------   Addons (addons.tpl, addons.php)   ---------
-----------------------------------------
*/

$_LANG['freemium_addons_whmcstemplates_image_alt'] = "WHMCS Templates";
$_LANG['freemium_addons_whmcstemplates_text'] = "<p>These WHMCS Templates are a complete solution for your web hosting business. They come packed with all of the pages and content required for a successful hosting company.</p>";

$_LANG['freemium_addons_wordpressthemes_image_alt'] = "WordPress Themes";
$_LANG['freemium_addons_wordpressthemes_text'] = "<p>Our WordPress Themes are extremely feature-rich and perfect for any type of online business. They allow you full control of your website without HTML experience.</p>";

$_LANG['freemium_addons_htmltemplates_image_alt'] = "HTML Templates";
$_LANG['freemium_addons_htmltemplates_text'] = "<p>Our custom developed HTML Templates are clean, easy to edit and fully responsive meaning they support almost all modern devices.</p>";

$_LANG['freemium_addons_blestatemplates_image_alt'] = "Blesta Templates";
$_LANG['freemium_addons_blestatemplates_text'] = "<p>Our Blesta Templates are built from scratch including a WordPress or HTML version for your main website and stunning Blesta integration out of the box.</p>";

$_LANG['freemium_addons_clientexectemplates_image_alt'] = "Clientexec Templates";
$_LANG['freemium_addons_clientexectemplates_text'] = "<p>Our Clientexec Templates are built from scratch including a WordPress or HTML version for your main website and stunning Clientexec integration out of the box.</p>";

$_LANG['freemium_addons_wisecptemplates_image_alt'] = "WISECP Templates";
$_LANG['freemium_addons_wisecptemplates_text'] = "<p>Our WISECP Templates are built from scratch including a WordPress or HTML version for your main website and stunning WISECP integration out of the box.</p>";

$_LANG['freemium_addons_hostbilltemplates_image_alt'] = "HostBill Templates";
$_LANG['freemium_addons_hostbilltemplates_text'] = "<p>Our HostBill Templates are built from scratch including a WordPress or HTML version for your main website and stunning HostBill integration out of the box.</p>";

$_LANG['freemium_addons_whmcsmodules_image_alt'] = "WHMCS Modules";
$_LANG['freemium_addons_whmcsmodules_text'] = "<p>We’ve developed a selection of exclusive & easy to use WHMCS Modules. These modules provide added functionality to your WHMCS website.</p>";

$_LANG['freemium_addons_scripts_image_alt'] = "Scripts";
$_LANG['freemium_addons_scripts_text'] = "<p>Originally created for our own website we’ve made all of our custom Scripts available to purchase. You’ll find menus, feature boxes & other useful scripts.</p>";

$_LANG['freemium_addons_logodesign_image_alt'] = "Logo Design";
$_LANG['freemium_addons_logodesign_text'] = "<p>Get your business up and running with a custom Logo Design. All of our logos are designed from scratch based on your requirements.</p>";

$_LANG['freemium_addons_bannerdesign_image_alt'] = "Banner Design";
$_LANG['freemium_addons_bannerdesign_text'] = "<p>We develop banners from scratch based on your requirements. Our banners are suitable for advertising campaigns and useful for your affiliate program.</p>";

$_LANG['freemium_addons_whmcsservices_image_alt'] = "WHMCS Services";
$_LANG['freemium_addons_whmcsservices_text'] = "<p>We have a lot of experience working with WHMCS. Our WHMCS Services consist of installation, configuration, integration, Enom account setup & automation.</p>";

$_LANG['freemium_addons_wordpressservices_image_alt'] = "WordPress Services";
$_LANG['freemium_addons_wordpressservices_text'] = "<p>We provide a mix of premium WordPress Services that you get your WordPress based website/blog setup properly. These include installation, configuration & integration.</p>";

$_LANG['freemium_addons_blestaservices_image_alt'] = "Blesta Services";
$_LANG['freemium_addons_blestaservices_text'] = "<p>We provide a mix of premium Blesta Services including installation, configuration & integration. Browse our services today to get started.</p>";

$_LANG['freemium_addons_clientexecservices_image_alt'] = "Clientexec Services";
$_LANG['freemium_addons_clientexecservices_text'] = "<p>We provide a mix of premium Clientexec Services including installation, configuration & integration. Browse our services today to get started.</p>";






/*
-----------------------------------------
---------   WHMCS Templates (whmcs-templates.tpl, whmcs-templates.php)   ---------
-----------------------------------------
*/

// Submenu

$_LANG['freemium_whmcstemplates_submenu_display'] = true;

$_LANG['freemium_whmcstemplates_submenu_1_display'] = true;
$_LANG['freemium_whmcstemplates_submenu_1_text'] = "Overview";
$_LANG['freemium_whmcstemplates_submenu_1_url'] = "#overview";
$_LANG['freemium_whmcstemplates_submenu_1_url_newwindow'] = false;

$_LANG['freemium_whmcstemplates_submenu_2_display'] = true;
$_LANG['freemium_whmcstemplates_submenu_2_text'] = "Templates";
$_LANG['freemium_whmcstemplates_submenu_2_url'] = "#plans";
$_LANG['freemium_whmcstemplates_submenu_2_url_newwindow'] = false;

// Overview

$_LANG['freemium_whmcstemplates_overview_display'] = true;

$_LANG['freemium_whmcstemplates_overview_text'] = "<p>This collection of WHMCS Templates make it easy to get your web hosting business launched with a professional look. These templates are fully responsive, come with an admin based settings area, support multiple display options, support multi-languages & much more.</p>";

// Templates

$_LANG['freemium_whmcstemplates_plans_heading'] = "Templates";






/*
-----------------------------------------
---------   WordPress Themes (wordpress-themes.tpl, wordpress-themes.php)   ---------
-----------------------------------------
*/

// Submenu

$_LANG['freemium_wordpressthemes_submenu_display'] = true;

$_LANG['freemium_wordpressthemes_submenu_1_display'] = true;
$_LANG['freemium_wordpressthemes_submenu_1_text'] = "Overview";
$_LANG['freemium_wordpressthemes_submenu_1_url'] = "#overview";
$_LANG['freemium_wordpressthemes_submenu_1_url_newwindow'] = false;

$_LANG['freemium_wordpressthemes_submenu_2_display'] = true;
$_LANG['freemium_wordpressthemes_submenu_2_text'] = "Themes";
$_LANG['freemium_wordpressthemes_submenu_2_url'] = "#plans";
$_LANG['freemium_wordpressthemes_submenu_2_url_newwindow'] = false;

// Overview

$_LANG['freemium_wordpressthemes_overview_display'] = true;

$_LANG['freemium_wordpressthemes_overview_text'] = "<p>This collection of WordPress Themes come packed with many features, are highly optimized and come with premium support. They feature a built-in options panel, admin-based menus, widgets, blog support & much more. Our WordPress Themes also support optional software consisting of an integration template that will match the design/content of your WordPress Theme. The supported software includes WHMCS, Blesta, Clientexec, WISECP & HostBill ($30/year).</p>";

// Themes

$_LANG['freemium_wordpressthemes_plans_heading'] = "Themes";






/*
-----------------------------------------
---------   HTML Templates (html-templates.tpl, html-templates.php)   ---------
-----------------------------------------
*/

// Submenu

$_LANG['freemium_htmltemplates_submenu_display'] = true;

$_LANG['freemium_htmltemplates_submenu_1_display'] = true;
$_LANG['freemium_htmltemplates_submenu_1_text'] = "Overview";
$_LANG['freemium_htmltemplates_submenu_1_url'] = "#overview";
$_LANG['freemium_htmltemplates_submenu_1_url_newwindow'] = false;

$_LANG['freemium_htmltemplates_submenu_2_display'] = true;
$_LANG['freemium_htmltemplates_submenu_2_text'] = "Templates";
$_LANG['freemium_htmltemplates_submenu_2_url'] = "#plans";
$_LANG['freemium_htmltemplates_submenu_2_url_newwindow'] = false;

// Overview

$_LANG['freemium_htmltemplates_overview_display'] = true;

$_LANG['freemium_htmltemplates_overview_text'] = "<p>A collection of HTML Templates designed for your web hosting reseller business. These templates are professionally coded to be lightning fast, easy to edit (require HTML experience) and come with reliable support. To automate the account provisioning, invoicing & provide account/support functionality these templates also come with optional WHMCS, Blesta, Clientexec & HostBill integration ($30/year) that will automatically sync with the HTML pages.</p>";

// Templates

$_LANG['freemium_htmltemplates_plans_heading'] = "Templates";






/*
-----------------------------------------
---------   Blesta Templates (blesta-templates.tpl, blesta-templates.php)   ---------
-----------------------------------------
*/

// Submenu

$_LANG['freemium_blestatemplates_submenu_display'] = true;

$_LANG['freemium_blestatemplates_submenu_1_display'] = true;
$_LANG['freemium_blestatemplates_submenu_1_text'] = "Overview";
$_LANG['freemium_blestatemplates_submenu_1_url'] = "#overview";
$_LANG['freemium_blestatemplates_submenu_1_url_newwindow'] = false;

$_LANG['freemium_blestatemplates_submenu_2_display'] = true;
$_LANG['freemium_blestatemplates_submenu_2_text'] = "Templates";
$_LANG['freemium_blestatemplates_submenu_2_url'] = "#plans";
$_LANG['freemium_blestatemplates_submenu_2_url_newwindow'] = false;

// Overview

$_LANG['freemium_blestatemplates_overview_display'] = true;

$_LANG['freemium_blestatemplates_overview_text'] = "<p>These Blesta Templates are designed to launch your very own web hosting reseller business. The templates are available for WordPress & HTML and come with reliable support. Each template comes with an optional Blesta integration template ($30/year) that will handle the account, cart, tickets & invoicing functionality of your website.</p>";

// Templates

$_LANG['freemium_blestatemplates_plans_heading'] = "Templates";






/*
-----------------------------------------
---------   Clientexec Templates (clientexec-templates.tpl, clientexec-templates.php)   ---------
-----------------------------------------
*/

// Submenu

$_LANG['freemium_clientexectemplates_submenu_display'] = true;

$_LANG['freemium_clientexectemplates_submenu_1_display'] = true;
$_LANG['freemium_clientexectemplates_submenu_1_text'] = "Overview";
$_LANG['freemium_clientexectemplates_submenu_1_url'] = "#overview";
$_LANG['freemium_clientexectemplates_submenu_1_url_newwindow'] = false;

$_LANG['freemium_clientexectemplates_submenu_2_display'] = true;
$_LANG['freemium_clientexectemplates_submenu_2_text'] = "Templates";
$_LANG['freemium_clientexectemplates_submenu_2_url'] = "#plans";
$_LANG['freemium_clientexectemplates_submenu_2_url_newwindow'] = false;

// Overview

$_LANG['freemium_clientexectemplates_overview_display'] = true;

$_LANG['freemium_clientexectemplates_overview_text'] = "<p>These Clientexec Templates are designed to launch your very own web hosting reseller business. The templates are available for WordPress & HTML and come with reliable support. Each template comes with an optional Clientexec integration template ($30/year) that will handle the account, cart, tickets & invoicing functionality of your website.</p>";

// Templates

$_LANG['freemium_clientexectemplates_plans_heading'] = "Templates";






/*
-----------------------------------------
---------   WISECP Templates (wisecp-templates.tpl, wisecp-templates.php)   ---------
-----------------------------------------
*/

// Submenu

$_LANG['freemium_wisecptemplates_submenu_display'] = true;

$_LANG['freemium_wisecptemplates_submenu_1_display'] = true;
$_LANG['freemium_wisecptemplates_submenu_1_text'] = "Overview";
$_LANG['freemium_wisecptemplates_submenu_1_url'] = "#overview";
$_LANG['freemium_wisecptemplates_submenu_1_url_newwindow'] = false;

$_LANG['freemium_wisecptemplates_submenu_2_display'] = true;
$_LANG['freemium_wisecptemplates_submenu_2_text'] = "Templates";
$_LANG['freemium_wisecptemplates_submenu_2_url'] = "#plans";
$_LANG['freemium_wisecptemplates_submenu_2_url_newwindow'] = false;

// Overview

$_LANG['freemium_wisecptemplates_overview_display'] = true;

$_LANG['freemium_wisecptemplates_overview_text'] = "<p>These WISECP Templates are designed to launch your very own web hosting reseller business. The templates are available for WordPress & HTML and come with reliable support. Each template comes with a optional WISECP integration template ($30/year) that will handle the account, cart, tickets & invoicing functionality of your website.</p>";

// Templates

$_LANG['freemium_wisecptemplates_plans_heading'] = "Templates";






/*
-----------------------------------------
---------   HostBill Templates (hostbill-templates.tpl, hostbill-templates.php)   ---------
-----------------------------------------
*/

// Submenu

$_LANG['freemium_hostbilltemplates_submenu_display'] = true;

$_LANG['freemium_hostbilltemplates_submenu_1_display'] = true;
$_LANG['freemium_hostbilltemplates_submenu_1_text'] = "Overview";
$_LANG['freemium_hostbilltemplates_submenu_1_url'] = "#overview";
$_LANG['freemium_hostbilltemplates_submenu_1_url_newwindow'] = false;

$_LANG['freemium_hostbilltemplates_submenu_2_display'] = true;
$_LANG['freemium_hostbilltemplates_submenu_2_text'] = "Templates";
$_LANG['freemium_hostbilltemplates_submenu_2_url'] = "#plans";
$_LANG['freemium_hostbilltemplates_submenu_2_url_newwindow'] = false;

// Overview

$_LANG['freemium_hostbilltemplates_overview_display'] = true;

$_LANG['freemium_hostbilltemplates_overview_text'] = "<p>These HostBill Templates are designed to launch your very own web hosting reseller business. The templates are available for WordPress & HTML and come with reliable support. Each template comes with a optional HostBill integration template ($30/year) that will handle the account, cart, tickets & invoicing functionality of your website.</p>";

// Templates

$_LANG['freemium_hostbilltemplates_plans_heading'] = "Templates";






/*
-----------------------------------------
---------   WHMCS Modules (whmcs-modules.tpl, whmcs-modules.php)   ---------
-----------------------------------------
*/

// Submenu

$_LANG['freemium_whmcsmodules_submenu_display'] = true;

$_LANG['freemium_whmcsmodules_submenu_1_display'] = true;
$_LANG['freemium_whmcsmodules_submenu_1_text'] = "Overview";
$_LANG['freemium_whmcsmodules_submenu_1_url'] = "#overview";
$_LANG['freemium_whmcsmodules_submenu_1_url_newwindow'] = false;

$_LANG['freemium_whmcsmodules_submenu_2_display'] = true;
$_LANG['freemium_whmcsmodules_submenu_2_text'] = "Modules";
$_LANG['freemium_whmcsmodules_submenu_2_url'] = "#plans";
$_LANG['freemium_whmcsmodules_submenu_2_url_newwindow'] = false;

// Overview

$_LANG['freemium_whmcsmodules_overview_display'] = true;

$_LANG['freemium_whmcsmodules_overview_text'] = "<p>We've developed a collection of easy to install WHMCS Modules which are used to add extra functionality to your WHMCS based website.</p>";

// Modules

$_LANG['freemium_whmcsmodules_plans_heading'] = "Modules";






/*
-----------------------------------------
---------   Scripts (scripts.tpl, scripts.php)   ---------
-----------------------------------------
*/

// Submenu

$_LANG['freemium_scripts_submenu_display'] = true;

$_LANG['freemium_scripts_submenu_1_display'] = true;
$_LANG['freemium_scripts_submenu_1_text'] = "Overview";
$_LANG['freemium_scripts_submenu_1_url'] = "#overview";
$_LANG['freemium_scripts_submenu_1_url_newwindow'] = false;

$_LANG['freemium_scripts_submenu_2_display'] = true;
$_LANG['freemium_scripts_submenu_2_text'] = "Scripts";
$_LANG['freemium_scripts_submenu_2_url'] = "#plans";
$_LANG['freemium_scripts_submenu_2_url_newwindow'] = false;

// Overview

$_LANG['freemium_scripts_overview_display'] = true;

$_LANG['freemium_scripts_overview_text'] = "<p>We’ve developed a collection of premium Scripts originally for our website but now have decided to make them available to everyone. These scripts will enhance your websites functionality quickly and effectively.</p>";

// Scripts

$_LANG['freemium_scripts_plans_heading'] = "Scripts";






/*
-----------------------------------------
---------   Logo Design (logo-design.tpl, logo-design.php)   ---------
-----------------------------------------
*/

// Submenu

$_LANG['freemium_logodesign_submenu_display'] = true;

$_LANG['freemium_logodesign_submenu_1_display'] = true;
$_LANG['freemium_logodesign_submenu_1_text'] = "Overview";
$_LANG['freemium_logodesign_submenu_1_url'] = "#overview";
$_LANG['freemium_logodesign_submenu_1_url_newwindow'] = false;

$_LANG['freemium_logodesign_submenu_2_display'] = true;
$_LANG['freemium_logodesign_submenu_2_text'] = "Features";
$_LANG['freemium_logodesign_submenu_2_url'] = "#features";
$_LANG['freemium_logodesign_submenu_2_url_newwindow'] = false;

$_LANG['freemium_logodesign_submenu_3_display'] = true;
$_LANG['freemium_logodesign_submenu_3_text'] = "Past Work";
$_LANG['freemium_logodesign_submenu_3_url'] = "#pastwork";
$_LANG['freemium_logodesign_submenu_3_url_newwindow'] = false;

// Overview

$_LANG['freemium_logodesign_overview_display'] = true;

$_LANG['freemium_logodesign_overview_text'] = "

<p>Get your business up and running with a custom Logo Design. All of our logos are designed from scratch based on your requirements.</p>
	
<p>Our logo design service is completed within 5 days, from concept to the finished logo.</p>

";

// Banner

$_LANG['freemium_logodesign_banner_display'] = true;
$_LANG['freemium_logodesign_banner_heading'] = $_LANG['freemium_logodesign_name'];
$_LANG['freemium_logodesign_banner_text'] = "We design stunning custom vector logos that are unique to you and your business. All logos we design come in vector and raster format meaning you will be able to use your finished logo in any type of advertising.";
$_LANG['freemium_logodesign_banner_feat1'] = "Unique Design";
$_LANG['freemium_logodesign_banner_feat2'] = "Vector Files";
$_LANG['freemium_logodesign_banner_feat3'] = "";
$_LANG['freemium_logodesign_banner_feat4'] = "";
$_LANG['freemium_logodesign_banner_feat5'] = "";
$_LANG['freemium_logodesign_banner_feat6'] = "";
$_LANG['freemium_logodesign_banner_feat_icon'] = "fas fa-check-square";
$_LANG['freemium_logodesign_banner_background'] = "background4.jpg";
$_LANG['freemium_logodesign_banner_background_opacity'] = 0.6;
$_LANG['freemium_logodesign_banner_price_before'] = "Just";
$_LANG['freemium_logodesign_banner_price'] = "150";
$_LANG['freemium_logodesign_banner_price_term'] = "/logo";
$_LANG['freemium_logodesign_banner_image'] = "logodesign1.png";
$_LANG['freemium_logodesign_banner_image_small'] = "logodesign1-small.png";
$_LANG['freemium_logodesign_banner_image_alt'] = "Logo Design";
$_LANG['freemium_logodesign_banner_image_url'] = "#pastwork";
$_LANG['freemium_logodesign_banner_image_url_newwindow'] = false;
$_LANG['freemium_logodesign_banner_image_screenshot'] = false;
$_LANG['freemium_logodesign_banner_image_video'] = false;
$_LANG['freemium_logodesign_banner_image_video_badge'] = "Watch Video";
$_LANG['freemium_logodesign_banner_image_video_badge_icon'] = "fab fa-youtube";
$_LANG['freemium_logodesign_banner_button1_text'] = "Learn More";
$_LANG['freemium_logodesign_banner_button1_icon'] = "fas fa-info-circle";
$_LANG['freemium_logodesign_banner_button1_url'] = "default"; // Set to default to use the Zomex affiliate program, you can replace with your own URL or leave blank to change this
$_LANG['freemium_logodesign_banner_button1_url_newwindow'] = false;
$_LANG['freemium_logodesign_banner_button2_text'] = "Order Now";
$_LANG['freemium_logodesign_banner_button2_icon'] = "fas fa-shopping-cart";
$_LANG['freemium_logodesign_banner_button2_url'] = "default"; // Set to default to use the Zomex affiliate program, you can replace with your own URL or leave blank to change this
$_LANG['freemium_logodesign_banner_button2_url_newwindow'] = false;

// Features

$_LANG['freemium_logodesign_features_display'] = true;

$_LANG['freemium_logodesign_features_heading'] = "Features";

// Feature 1

$_LANG['freemium_logodesign_features_1_display'] = true;
$_LANG['freemium_logodesign_features_1_displayorder'] = 0;
$_LANG['freemium_logodesign_features_1_animation'] = "fadeInLeft";
$_LANG['freemium_logodesign_features_1_heading'] = "Custom Design";
$_LANG['freemium_logodesign_features_1_image'] = "logodesign-features-1.png";
$_LANG['freemium_logodesign_features_1_image_alt'] = "custom design";
$_LANG['freemium_logodesign_features_1_image_url'] = "";
$_LANG['freemium_logodesign_features_1_image_url_newwindow'] = false;
$_LANG['freemium_logodesign_features_1_text'] = "<p>Every logo we design is completely custom to you and your business. The design is based on your requirements, our research of your business and competition & the goals of your business.</p>";

// Feature 2

$_LANG['freemium_logodesign_features_2_display'] = true;
$_LANG['freemium_logodesign_features_2_displayorder'] = 0;
$_LANG['freemium_logodesign_features_2_animation'] = "fadeInUp";
$_LANG['freemium_logodesign_features_2_heading'] = "Unlimited Revisions";
$_LANG['freemium_logodesign_features_2_image'] = "logodesign-features-2.png";
$_LANG['freemium_logodesign_features_2_image_alt'] = "unlimited revisions";
$_LANG['freemium_logodesign_features_2_image_url'] = "";
$_LANG['freemium_logodesign_features_2_image_url_newwindow'] = false;
$_LANG['freemium_logodesign_features_2_text'] = "<p>You can request unlimited revisions once the initial logo design is provided ensuring that the end result is a perfect logo for your business that meets your requirements.</p>";

// Feature 3

$_LANG['freemium_logodesign_features_3_display'] = true;
$_LANG['freemium_logodesign_features_3_displayorder'] = 0;
$_LANG['freemium_logodesign_features_3_animation'] = "fadeInRight";
$_LANG['freemium_logodesign_features_3_heading'] = "Full Copyright Owned By You";
$_LANG['freemium_logodesign_features_3_image'] = "logodesign-features-3.png";
$_LANG['freemium_logodesign_features_3_image_alt'] = "full copyright";
$_LANG['freemium_logodesign_features_3_image_url'] = "";
$_LANG['freemium_logodesign_features_3_image_url_newwindow'] = false;
$_LANG['freemium_logodesign_features_3_text'] = "<p>The logo we design will be completely custom to you and your business. We also include exclusive and full copyright rights to you as part of our logo design service.</p>";

// Feature 4

$_LANG['freemium_logodesign_features_4_display'] = true;
$_LANG['freemium_logodesign_features_4_displayorder'] = 0;
$_LANG['freemium_logodesign_features_4_animation'] = "fadeInLeft";
$_LANG['freemium_logodesign_features_4_heading'] = "All File Formats Provided";
$_LANG['freemium_logodesign_features_4_image'] = "logodesign-features-4.png";
$_LANG['freemium_logodesign_features_4_image_alt'] = "file formats";
$_LANG['freemium_logodesign_features_4_image_url'] = "";
$_LANG['freemium_logodesign_features_4_image_url_newwindow'] = false;
$_LANG['freemium_logodesign_features_4_text'] = "<p>We can provide your finished logo design in any file format you need. By default we will provide the .ai, .eps (vector - perfect for print), .jpg, .png (perfect for the web) file formats.</p>";

// Feature 5

$_LANG['freemium_logodesign_features_5_display'] = true;
$_LANG['freemium_logodesign_features_5_displayorder'] = 0;
$_LANG['freemium_logodesign_features_5_animation'] = "fadeInUp";
$_LANG['freemium_logodesign_features_5_heading'] = "Out Of The Box Service";
$_LANG['freemium_logodesign_features_5_image'] = "logodesign-features-5.png";
$_LANG['freemium_logodesign_features_5_image_alt'] = "out of the box service";
$_LANG['freemium_logodesign_features_5_image_url'] = "";
$_LANG['freemium_logodesign_features_5_image_url_newwindow'] = false;
$_LANG['freemium_logodesign_features_5_text'] = "<p>Our Logo Design service is the perfect solution for new businesses looking for a high quality logo that is professional, effective and custom at an affordable price.</p>";

// Past Work

$_LANG['freemium_logodesign_pastwork_display'] = true;

$_LANG['freemium_logodesign_pastwork_heading'] = "Past Work";

// Past Work 1

$_LANG['freemium_logodesign_pastwork_1_display'] = true;
$_LANG['freemium_logodesign_pastwork_1_displayorder'] = 0;
$_LANG['freemium_logodesign_pastwork_1_animation'] = "fadeInLeft";
$_LANG['freemium_logodesign_pastwork_1_image'] = "logodesign-pastwork-1.png";
$_LANG['freemium_logodesign_pastwork_1_image_alt'] = "logo design 1";
$_LANG['freemium_logodesign_pastwork_1_image_url'] = "logodesign-pastwork-1.png";
$_LANG['freemium_logodesign_pastwork_1_image_url_newwindow'] = false;
$_LANG['freemium_logodesign_pastwork_1_image_url_popup'] = true;

// Past Work 2

$_LANG['freemium_logodesign_pastwork_2_display'] = true;
$_LANG['freemium_logodesign_pastwork_2_displayorder'] = 0;
$_LANG['freemium_logodesign_pastwork_2_animation'] = "fadeInUp";
$_LANG['freemium_logodesign_pastwork_2_image'] = "logodesign-pastwork-2.png";
$_LANG['freemium_logodesign_pastwork_2_image_alt'] = "logo design 2";
$_LANG['freemium_logodesign_pastwork_2_image_url'] = "logodesign-pastwork-2.png";
$_LANG['freemium_logodesign_pastwork_2_image_url_newwindow'] = false;
$_LANG['freemium_logodesign_pastwork_2_image_url_popup'] = true;

// Past Work 3

$_LANG['freemium_logodesign_pastwork_3_display'] = true;
$_LANG['freemium_logodesign_pastwork_3_displayorder'] = 0;
$_LANG['freemium_logodesign_pastwork_3_animation'] = "fadeInRight";
$_LANG['freemium_logodesign_pastwork_3_image'] = "logodesign-pastwork-3.png";
$_LANG['freemium_logodesign_pastwork_3_image_alt'] = "logo design 3";
$_LANG['freemium_logodesign_pastwork_3_image_url'] = "logodesign-pastwork-3.png";
$_LANG['freemium_logodesign_pastwork_3_image_url_newwindow'] = false;
$_LANG['freemium_logodesign_pastwork_3_image_url_popup'] = true;

// CTA

$_LANG['freemium_logodesign_cta_display'] = true;
$_LANG['freemium_logodesign_cta_text'] = "Ready To Get Started?";
$_LANG['freemium_logodesign_cta_button_text'] = "Order Now";
$_LANG['freemium_logodesign_cta_button_icon'] = "fas fa-shopping-cart";
$_LANG['freemium_logodesign_cta_button_url'] = "default"; // Set to default to use the Zomex affiliate program, you can replace with your own URL or leave blank to change this
$_LANG['freemium_logodesign_cta_button_url_newwindow'] = false;






/*
-----------------------------------------
---------   Banner Design (banner-design.tpl, banner-design.php)   ---------
-----------------------------------------
*/

// Submenu

$_LANG['freemium_bannerdesign_submenu_display'] = true;

$_LANG['freemium_bannerdesign_submenu_1_display'] = true;
$_LANG['freemium_bannerdesign_submenu_1_text'] = "Overview";
$_LANG['freemium_bannerdesign_submenu_1_url'] = "#overview";
$_LANG['freemium_bannerdesign_submenu_1_url_newwindow'] = false;

$_LANG['freemium_bannerdesign_submenu_2_display'] = true;
$_LANG['freemium_bannerdesign_submenu_2_text'] = "Features";
$_LANG['freemium_bannerdesign_submenu_2_url'] = "#features";
$_LANG['freemium_bannerdesign_submenu_2_url_newwindow'] = false;

$_LANG['freemium_bannerdesign_submenu_3_display'] = true;
$_LANG['freemium_bannerdesign_submenu_3_text'] = "Past Work";
$_LANG['freemium_bannerdesign_submenu_3_url'] = "#pastwork";
$_LANG['freemium_bannerdesign_submenu_3_url_newwindow'] = false;

// Overview

$_LANG['freemium_bannerdesign_overview_display'] = true;

$_LANG['freemium_bannerdesign_overview_text'] = "

<p>We develop banners from scratch based on your requirements. Our banners are suitable for advertising campaigns and useful for your affiliate program.</p>
	
<p>Our banner design service is completed within 5 days, from concept to the finished banner.</p>

";

// Banner

$_LANG['freemium_bannerdesign_banner_display'] = true;
$_LANG['freemium_bannerdesign_banner_heading'] = $_LANG['freemium_bannerdesign_name'];
$_LANG['freemium_bannerdesign_banner_text'] = "We design banners of all sizes! We take great care when creating your custom banners to ensure they are help achieve your goal whether that's increased sales or any other goal using enhanced call-to-actions.";
$_LANG['freemium_bannerdesign_banner_feat1'] = "Unique Design";
$_LANG['freemium_bannerdesign_banner_feat2'] = "Any Size";
$_LANG['freemium_bannerdesign_banner_feat3'] = "";
$_LANG['freemium_bannerdesign_banner_feat4'] = "";
$_LANG['freemium_bannerdesign_banner_feat5'] = "";
$_LANG['freemium_bannerdesign_banner_feat6'] = "";
$_LANG['freemium_bannerdesign_banner_feat_icon'] = "fas fa-check-square";
$_LANG['freemium_bannerdesign_banner_background'] = "background4.jpg";
$_LANG['freemium_bannerdesign_banner_background_opacity'] = 0.6;
$_LANG['freemium_bannerdesign_banner_price_before'] = "Just";
$_LANG['freemium_bannerdesign_banner_price'] = "30";
$_LANG['freemium_bannerdesign_banner_price_term'] = "/banner";
$_LANG['freemium_bannerdesign_banner_image'] = "bannerdesign1.png";
$_LANG['freemium_bannerdesign_banner_image_small'] = "bannerdesign1-small.png";
$_LANG['freemium_bannerdesign_banner_image_alt'] = "Banner Design";
$_LANG['freemium_bannerdesign_banner_image_url'] = "#pastwork";
$_LANG['freemium_bannerdesign_banner_image_url_newwindow'] = false;
$_LANG['freemium_bannerdesign_banner_image_screenshot'] = false;
$_LANG['freemium_bannerdesign_banner_image_video'] = false;
$_LANG['freemium_bannerdesign_banner_image_video_badge'] = "Watch Video";
$_LANG['freemium_bannerdesign_banner_image_video_badge_icon'] = "fab fa-youtube";
$_LANG['freemium_bannerdesign_banner_button1_text'] = "Learn More";
$_LANG['freemium_bannerdesign_banner_button1_icon'] = "fas fa-info-circle";
$_LANG['freemium_bannerdesign_banner_button1_url'] = "default"; // Set to default to use the Zomex affiliate program, you can replace with your own URL or leave blank to change this
$_LANG['freemium_bannerdesign_banner_button1_url_newwindow'] = false;
$_LANG['freemium_bannerdesign_banner_button2_text'] = "Order Now";
$_LANG['freemium_bannerdesign_banner_button2_icon'] = "fas fa-shopping-cart";
$_LANG['freemium_bannerdesign_banner_button2_url'] = "default"; // Set to default to use the Zomex affiliate program, you can replace with your own URL or leave blank to change this
$_LANG['freemium_bannerdesign_banner_button2_url_newwindow'] = false;

// Features

$_LANG['freemium_bannerdesign_features_display'] = true;

$_LANG['freemium_bannerdesign_features_heading'] = "Features";

// Feature 1

$_LANG['freemium_bannerdesign_features_1_display'] = true;
$_LANG['freemium_bannerdesign_features_1_displayorder'] = 0;
$_LANG['freemium_bannerdesign_features_1_animation'] = "fadeInLeft";
$_LANG['freemium_bannerdesign_features_1_heading'] = "Custom Design";
$_LANG['freemium_bannerdesign_features_1_image'] = "bannerdesign-features-1.png";
$_LANG['freemium_bannerdesign_features_1_image_alt'] = "custom design";
$_LANG['freemium_bannerdesign_features_1_image_url'] = "";
$_LANG['freemium_bannerdesign_features_1_image_url_newwindow'] = false;
$_LANG['freemium_bannerdesign_features_1_text'] = "<p>Every banner we design is completely custom to you and your business. The design is based on your requirements, our research of your business and competition & the goals of your business.</p>";

// Feature 2

$_LANG['freemium_bannerdesign_features_2_display'] = true;
$_LANG['freemium_bannerdesign_features_2_displayorder'] = 0;
$_LANG['freemium_bannerdesign_features_2_animation'] = "fadeInUp";
$_LANG['freemium_bannerdesign_features_2_heading'] = "Unlimited Revisions";
$_LANG['freemium_bannerdesign_features_2_image'] = "bannerdesign-features-2.png";
$_LANG['freemium_bannerdesign_features_2_image_alt'] = "unlimited revisions";
$_LANG['freemium_bannerdesign_features_2_image_url'] = "";
$_LANG['freemium_bannerdesign_features_2_image_url_newwindow'] = false;
$_LANG['freemium_bannerdesign_features_2_text'] = "<p>You can request unlimited revisions once the initial banner design is provided ensuring that the end result is a perfect banner for your business that meets your requirements.</p>";

// Feature 3

$_LANG['freemium_bannerdesign_features_3_display'] = true;
$_LANG['freemium_bannerdesign_features_3_displayorder'] = 0;
$_LANG['freemium_bannerdesign_features_3_animation'] = "fadeInRight";
$_LANG['freemium_bannerdesign_features_3_heading'] = "All File Formats Provided";
$_LANG['freemium_bannerdesign_features_3_image'] = "bannerdesign-features-3.png";
$_LANG['freemium_bannerdesign_features_3_image_alt'] = "all file formats";
$_LANG['freemium_bannerdesign_features_3_image_url'] = "";
$_LANG['freemium_bannerdesign_features_3_image_url_newwindow'] = false;
$_LANG['freemium_bannerdesign_features_3_text'] = "<p>We can provide your finished banner design in any file format you need. By default we will provide the .jpg and .png file formats.</p>";

// Feature 4

$_LANG['freemium_bannerdesign_features_4_display'] = true;
$_LANG['freemium_bannerdesign_features_4_displayorder'] = 0;
$_LANG['freemium_bannerdesign_features_4_animation'] = "fadeInLeft";
$_LANG['freemium_bannerdesign_features_4_heading'] = "Out Of The Box Service";
$_LANG['freemium_bannerdesign_features_4_image'] = "bannerdesign-features-4.png";
$_LANG['freemium_bannerdesign_features_4_image_alt'] = "out of the box service";
$_LANG['freemium_bannerdesign_features_4_image_url'] = "";
$_LANG['freemium_bannerdesign_features_4_image_url_newwindow'] = false;
$_LANG['freemium_bannerdesign_features_4_text'] = "<p>Our banner design service is the perfect solution for new businesses looking for a high quality banner that is professional, effective and custom at an affordable price.</p>";

// Past Work

$_LANG['freemium_bannerdesign_pastwork_display'] = true;

$_LANG['freemium_bannerdesign_pastwork_heading'] = "Past Work";

// Past Work 1

$_LANG['freemium_bannerdesign_pastwork_1_display'] = true;
$_LANG['freemium_bannerdesign_pastwork_1_displayorder'] = 0;
$_LANG['freemium_bannerdesign_pastwork_1_animation'] = "fadeInLeft";
$_LANG['freemium_bannerdesign_pastwork_1_image'] = "bannerdesign-pastwork-1.gif";
$_LANG['freemium_bannerdesign_pastwork_1_image_alt'] = "banner design 1";
$_LANG['freemium_bannerdesign_pastwork_1_image_url'] = "bannerdesign-pastwork-1.gif";
$_LANG['freemium_bannerdesign_pastwork_1_image_url_newwindow'] = false;
$_LANG['freemium_bannerdesign_pastwork_1_image_url_popup'] = true;

// Past Work 2

$_LANG['freemium_bannerdesign_pastwork_2_display'] = true;
$_LANG['freemium_bannerdesign_pastwork_2_displayorder'] = 0;
$_LANG['freemium_bannerdesign_pastwork_2_animation'] = "fadeInUp";
$_LANG['freemium_bannerdesign_pastwork_2_image'] = "bannerdesign-pastwork-2.gif";
$_LANG['freemium_bannerdesign_pastwork_2_image_alt'] = "banner design 2";
$_LANG['freemium_bannerdesign_pastwork_2_image_url'] = "bannerdesign-pastwork-2.gif";
$_LANG['freemium_bannerdesign_pastwork_2_image_url_newwindow'] = false;
$_LANG['freemium_bannerdesign_pastwork_2_image_url_popup'] = true;

// Past Work 3

$_LANG['freemium_bannerdesign_pastwork_3_display'] = true;
$_LANG['freemium_bannerdesign_pastwork_3_displayorder'] = 0;
$_LANG['freemium_bannerdesign_pastwork_3_animation'] = "fadeInRight";
$_LANG['freemium_bannerdesign_pastwork_3_image'] = "bannerdesign-pastwork-3.gif";
$_LANG['freemium_bannerdesign_pastwork_3_image_alt'] = "banner design 3";
$_LANG['freemium_bannerdesign_pastwork_3_image_url'] = "bannerdesign-pastwork-3.gif";
$_LANG['freemium_bannerdesign_pastwork_3_image_url_newwindow'] = false;
$_LANG['freemium_bannerdesign_pastwork_3_image_url_popup'] = true;

// Past Work 4

$_LANG['freemium_bannerdesign_pastwork_4_display'] = true;
$_LANG['freemium_bannerdesign_pastwork_4_displayorder'] = 0;
$_LANG['freemium_bannerdesign_pastwork_4_animation'] = "fadeInLeft";
$_LANG['freemium_bannerdesign_pastwork_4_image'] = "bannerdesign-pastwork-4.gif";
$_LANG['freemium_bannerdesign_pastwork_4_image_alt'] = "banner design 4";
$_LANG['freemium_bannerdesign_pastwork_4_image_url'] = "bannerdesign-pastwork-4.gif";
$_LANG['freemium_bannerdesign_pastwork_4_image_url_newwindow'] = false;
$_LANG['freemium_bannerdesign_pastwork_4_image_url_popup'] = true;

// CTA

$_LANG['freemium_bannerdesign_cta_display'] = true;
$_LANG['freemium_bannerdesign_cta_text'] = "Ready To Get Started?";
$_LANG['freemium_bannerdesign_cta_button_text'] = "Order Now";
$_LANG['freemium_bannerdesign_cta_button_icon'] = "fas fa-shopping-cart";
$_LANG['freemium_bannerdesign_cta_button_url'] = "default"; // Set to default to use the Zomex affiliate program, you can replace with your own URL or leave blank to change this
$_LANG['freemium_bannerdesign_cta_button_url_newwindow'] = false;






/*
-----------------------------------------
---------   WHMCS Services (whmcs-services.tpl, whmcs-services.php)   ---------
-----------------------------------------
*/

// Submenu

$_LANG['freemium_whmcsservices_submenu_display'] = true;

$_LANG['freemium_whmcsservices_submenu_1_display'] = true;
$_LANG['freemium_whmcsservices_submenu_1_text'] = "Overview";
$_LANG['freemium_whmcsservices_submenu_1_url'] = "#overview";
$_LANG['freemium_whmcsservices_submenu_1_url_newwindow'] = false;

$_LANG['freemium_whmcsservices_submenu_2_display'] = true;
$_LANG['freemium_whmcsservices_submenu_2_text'] = "Services";
$_LANG['freemium_whmcsservices_submenu_2_url'] = "#plans";
$_LANG['freemium_whmcsservices_submenu_2_url_newwindow'] = false;

// Overview

$_LANG['freemium_whmcsservices_overview_display'] = true;

$_LANG['freemium_whmcsservices_overview_text'] = "<p>A mix of services for the popular web hosting automation software, WHMCS. These WHMCS Services are reliable and provided by a company who has vast experience in the web hosting industry.</p>";

// Services

$_LANG['freemium_whmcsservices_plans_heading'] = "Services";

$_LANG['freemium_whmcsservices_1_heading'] = "WHMCS Configuration";
$_LANG['freemium_whmcsservices_1_text'] = "This service includes the general configuration of WHMCS, 3 support departments, 1 payment gateway and the setup of 3 shared hosting plans that are fully automated.";

$_LANG['freemium_whmcsservices_2_heading'] = "WHMCS Upgrade";
$_LANG['freemium_whmcsservices_2_text'] = "We will manually update your WHMCS installation to the latest version. During which we will ensure that any customisations you’ve made to the language or template files remain safe without any data loss.";

$_LANG['freemium_whmcsservices_3_heading'] = "WHMCS Integration";
$_LANG['freemium_whmcsservices_3_text'] = "We will take the design of your existing website and use it to create a matching WHMCS Template, this ensures that both your website and WHMCS match in design creating a consistent user experience.";

$_LANG['freemium_whmcsservices_4_heading'] = "WHMCS Installation";
$_LANG['freemium_whmcsservices_4_text'] = "Hire Zomex to complete your WHMCS Installation. We have vast experience working with WHMCS and first installed WHMCS back in 2009 for this very website you are using, Zomex.com.";

$_LANG['freemium_whmcsservices_5_heading'] = "Basic Security";
$_LANG['freemium_whmcsservices_5_text'] = "Our basic security service includes the completion of the further security steps. This includes securing writable directories, changing your admin directory & securing your configuration.php file.";

$_LANG['freemium_whmcsservices_6_heading'] = "Advanced Security";
$_LANG['freemium_whmcsservices_6_text'] = "One big security risk we see is WHMCS installations that contain old files (modules, WHMCS copies, databases etc). Hire Zomex to tidy your WHMCS directory by clearing out these old files.";

$_LANG['freemium_whmcsservices_7_heading'] = "Move Directory";
$_LANG['freemium_whmcsservices_7_text'] = "We will move the directory of your WHMCS installation. For example from domain.com/whmcs to domain.com/clients. Once this process is finished all you’ll need to do is re-issue your license.";

$_LANG['freemium_whmcsservices_8_heading'] = "Move Server";
$_LANG['freemium_whmcsservices_8_text'] = "We will move the server of your WHMCS installation. For example from domain.com/whmcs to domain2.com/clients. Once this process is finished all you’ll need to do is re-issue your license.";

$_LANG['freemium_whmcsservices_9_heading'] = "Shared Hosting Setup";
$_LANG['freemium_whmcsservices_9_text'] = "This service includes the setup of 3 shared hosting plans in WHMCS using any supported server (cPanel, Plesk etc). The plans we setup in WHMCS will be fully automated.";

$_LANG['freemium_whmcsservices_10_heading'] = "Reseller Hosting Setup";
$_LANG['freemium_whmcsservices_10_text'] = "This service includes the setup of 3 reseller hosting plans in WHMCS using any supported server (cPanel, Plesk etc). The plans we setup in WHMCS will be fully automated.";

$_LANG['freemium_whmcsservices_11_heading'] = "Domain Registrar Setup";
$_LANG['freemium_whmcsservices_11_text'] = "This service includes the setup of any WHMCS supported domain registrar (Enom, ResellerClub etc). We will setup 6 domains of your choice (e.g .com at $14.99/year) with full automation within WHMCS.";

$_LANG['freemium_whmcsservices_12_heading'] = "Payment Gateway Setup";
$_LANG['freemium_whmcsservices_12_text'] = "This service includes the setup of any WHMCS supported payment gateway (PayPal, 2CheckOut, Stripe etc). Once finished you will be able to accept payments via WHMCS using this payment gateway.";






/*
-----------------------------------------
---------   WordPress Services (wordpress-services.tpl, wordpress-services.php)   ---------
-----------------------------------------
*/

// Submenu

$_LANG['freemium_wordpressservices_submenu_display'] = true;

$_LANG['freemium_wordpressservices_submenu_1_display'] = true;
$_LANG['freemium_wordpressservices_submenu_1_text'] = "Overview";
$_LANG['freemium_wordpressservices_submenu_1_url'] = "#overview";
$_LANG['freemium_wordpressservices_submenu_1_url_newwindow'] = false;

$_LANG['freemium_wordpressservices_submenu_2_display'] = true;
$_LANG['freemium_wordpressservices_submenu_2_text'] = "Services";
$_LANG['freemium_wordpressservices_submenu_2_url'] = "#plans";
$_LANG['freemium_wordpressservices_submenu_2_url_newwindow'] = false;

// Overview

$_LANG['freemium_wordpressservices_overview_display'] = true;

$_LANG['freemium_wordpressservices_overview_text'] = "<p>A mix of services for the popular content management system, Wordpress. These Wordpress services are reliable and provided by a company who has many years experience working with WordPress.</p>";

// Services

$_LANG['freemium_wordpressservices_plans_heading'] = "Services";

$_LANG['freemium_wordpressservices_1_heading'] = "WordPress Installation";
$_LANG['freemium_wordpressservices_1_text'] = "We will install the latest version of WordPress, completing the installation manually. This service is a quick and easy way to avoid having to install the software yourself and at just $10 is fantastic value.";

$_LANG['freemium_wordpressservices_2_heading'] = "WordPress Configuration";
$_LANG['freemium_wordpressservices_2_text'] = "Hire Zomex to configure your WordPress installation with our recommended settings and plugins for a website that is well optimized for the search engines. We setup your website as we would do for our own.";

$_LANG['freemium_wordpressservices_3_heading'] = "WordPress Integration";
$_LANG['freemium_wordpressservices_3_text'] = "This service involves taking your existing website design to create a matching WordPress theme. This service is popular with companies looking to have a matching WordPress Theme to create a company blog.";






/*
-----------------------------------------
---------   Blesta Services (blesta-services.tpl, blesta-services.php)   ---------
-----------------------------------------
*/

// Submenu

$_LANG['freemium_blestaservices_submenu_display'] = true;

$_LANG['freemium_blestaservices_submenu_1_display'] = true;
$_LANG['freemium_blestaservices_submenu_1_text'] = "Overview";
$_LANG['freemium_blestaservices_submenu_1_url'] = "#overview";
$_LANG['freemium_blestaservices_submenu_1_url_newwindow'] = false;

$_LANG['freemium_blestaservices_submenu_2_display'] = true;
$_LANG['freemium_blestaservices_submenu_2_text'] = "Services";
$_LANG['freemium_blestaservices_submenu_2_url'] = "#plans";
$_LANG['freemium_blestaservices_submenu_2_url_newwindow'] = false;

// Overview

$_LANG['freemium_blestaservices_overview_display'] = true;

$_LANG['freemium_blestaservices_overview_text'] = "<p>A mix of services for the popular web hosting provider software, Blesta.</p>";

// Services

$_LANG['freemium_blestaservices_plans_heading'] = "Services";

$_LANG['freemium_blestaservices_1_heading'] = "Blesta Installation";
$_LANG['freemium_blestaservices_1_text'] = "We will install the latest version of Blesta, completing the installation manually. This service is a quick and easy way to avoid having to install the software yourself and at just $12 represents fantastic value.";

$_LANG['freemium_blestaservices_2_heading'] = "Blesta Integration";
$_LANG['freemium_blestaservices_2_text'] = "We will take the design of your existing website and use it to create a Blesta theme including support for the WordPress based functionality such as admin based pages, menu & widget editing.";






/*
-----------------------------------------
---------   Clientexec Services (clientexec-services.tpl, clientexec-services.php)   ---------
-----------------------------------------
*/

// Submenu

$_LANG['freemium_clientexecservices_submenu_display'] = true;

$_LANG['freemium_clientexecservices_submenu_1_display'] = true;
$_LANG['freemium_clientexecservices_submenu_1_text'] = "Overview";
$_LANG['freemium_clientexecservices_submenu_1_url'] = "#overview";
$_LANG['freemium_clientexecservices_submenu_1_url_newwindow'] = false;

$_LANG['freemium_clientexecservices_submenu_2_display'] = true;
$_LANG['freemium_clientexecservices_submenu_2_text'] = "Services";
$_LANG['freemium_clientexecservices_submenu_2_url'] = "#plans";
$_LANG['freemium_clientexecservices_submenu_2_url_newwindow'] = false;

// Overview

$_LANG['freemium_clientexecservices_overview_display'] = true;

$_LANG['freemium_clientexecservices_overview_text'] = "<p>A mix of services for the popular web hosting provider software, Clientexec.</p>";

// Services

$_LANG['freemium_clientexecservices_plans_heading'] = "Services";

$_LANG['freemium_clientexecservices_1_heading'] = "Clientexec Installation";
$_LANG['freemium_clientexecservices_1_text'] = "We will install the latest version of Clientexec, completing the installation manually. This service is a quick and easy way to avoid having to install the software yourself and at just $12 represents fantastic value.";

$_LANG['freemium_clientexecservices_2_heading'] = "Clientexec Integration";
$_LANG['freemium_clientexecservices_2_text'] = " We will take the design of your existing website and use it to create a Clientexec theme including support for the Clientexec based functionality such as admin based pages, menu & widget editing.";






/*
-----------------------------------------
---------   Multi-language support: on   ---------
-----------------------------------------

When Multi-language support is set to On from inside Wizard Panel the below text will be used (in order to support multiple languages). If your Multi-language support setting is set to Google Translate or Off then this text is editable in Wizard Panel directly and everything below can be ignored.

-----------------------------------------	
*/






/*
-----------------------------------------
---------   Toolbar (File: includes/toolbar.tpl)   ---------
-----------------------------------------
*/

$_LANG['freemium_toolbar_text'] = "We provide <strong>premium cPanel hosting!</strong>";
$_LANG['freemium_toolbar_text_cart'] = "Thank you for shopping with <strong>" . $_LANG['freemium_setting_companyname'] . "</strong>";






/*
-----------------------------------------
---------   Header (File: includes/header.tpl)   ---------
-----------------------------------------
*/

$_LANG['freemium_header_logo_alt'] = $_LANG['freemium_setting_companyname'] . " logo";

$_LANG['freemium_header_buttons_1_text'] = "Our Clients";
$_LANG['freemium_header_buttons_2_text'] = "Knowledgebase";
$_LANG['freemium_header_buttons_3_text'] = "Knowledgebase";
$_LANG['freemium_header_buttons_4_text'] = "Knowledgebase";
$_LANG['freemium_header_buttons_5_text'] = "Knowledgebase";






/*
-----------------------------------------
---------   Main Menu (File: includes/menu.tpl)   ---------
-----------------------------------------
*/

$_LANG['freemium_menu_order'] = "order";






/*
-----------------------------------------
---------   CTA (File: includes/cta.tpl)   ---------
-----------------------------------------
*/

$_LANG['freemium_cta_text'] = "700+ people trust " . $_LANG['freemium_setting_companyname'];
$_LANG['freemium_cta_button'] = "Join Them Today";






/*
-----------------------------------------
---------   Partners (File: includes/partners.tpl)   ---------
-----------------------------------------
*/

$_LANG['freemium_partners_image_alt'] = $_LANG['freemium_setting_companyname'] . " partners";






/*
-----------------------------------------
---------   Footer (File: includes/footer.tpl)   ---------
-----------------------------------------
*/

$_LANG['freemium_footer_about'] = "About " . $_LANG['freemium_setting_companyname'];
$_LANG['freemium_footer_about_text'] = $_LANG['freemium_setting_companyname'] . " provide premium web hosting, domain registration &amp; security services to businesses around the world.";
$_LANG['freemium_footer_about_button_text'] = "more";
$_LANG['freemium_footer_linkblocks_1_text'] = "29 Your Street, Chatham, Kent, England";
$_LANG['freemium_footer_linkblocks_2_text'] = "sales@yourcompany.com";
$_LANG['freemium_footer_linkblocks_3_text'] = "+01 23 45 47 25";
$_LANG['freemium_footer_linkblocks_4_text'] = "Company Number: 7832763";
$_LANG['freemium_footer_linkblocks_5_text'] = "VAT Number: FR197763863";






/*
-----------------------------------------
---------   Copyright (File: includes/footer.tpl)   ---------
-----------------------------------------
*/

$_LANG['freemium_legalimages_1_alt'] = $_LANG['freemium_setting_companyname'] . " PayPal";
$_LANG['freemium_legalimages_2_alt'] = $_LANG['freemium_setting_companyname'] . " Credit Card";
$_LANG['freemium_legalimages_3_alt'] = $_LANG['freemium_setting_companyname'] . " RapidSSL";






/*
-----------------------------------------
---------   Home page (File: homepage.tpl, index.php)   ---------
-----------------------------------------
*/

// Slide 1

$_LANG['freemium_banner_1_heading'] = "Shared Hosting";
$_LANG['freemium_banner_1_text'] = "Reliable cPanel Hosting Plans";
$_LANG['freemium_banner_1_feat1'] = "Unlimited domains, email & space";
$_LANG['freemium_banner_1_feat2'] = "Award-winning 24/7 technical support";
$_LANG['freemium_banner_1_feat3'] = "Money back guarantee with all plans";
$_LANG['freemium_banner_1_feat4'] = "Unlimited bandwidth reset monthly";
$_LANG['freemium_banner_1_feat5'] = "cPanel - easy-to-use control panel";
$_LANG['freemium_banner_1_feat6'] = "Perfect for personal websites and businesses";
$_LANG['freemium_banner_1_price_before'] = "Starting From";
$_LANG['freemium_banner_1_price_term'] = "/month";
$_LANG['freemium_banner_1_image_alt'] = "Web Hosting";
$_LANG['freemium_banner_1_image_video_badge'] = "Watch Video";
$_LANG['freemium_banner_1_button1_text'] = "Features";
$_LANG['freemium_banner_1_button2_text'] = "Get Started Now!";

// Slide 2

$_LANG['freemium_banner_2_heading'] = "Reseller Hosting";
$_LANG['freemium_banner_2_text'] = "Provide web hosting as a business!";
$_LANG['freemium_banner_2_feat1'] = "Provide your clients with cPanel hosting";
$_LANG['freemium_banner_2_feat2'] = "Manage your reseller business with WHM";
$_LANG['freemium_banner_2_feat3'] = "Create unlimited cPanel accounts";
$_LANG['freemium_banner_2_feat4'] = "WHMCS license provided at a discount";
$_LANG['freemium_banner_2_feat5'] = "Unlimited access to our knowledgeable support";
$_LANG['freemium_banner_2_feat6'] = "We only use the highest quality LiteSpeed servers";
$_LANG['freemium_banner_2_price_before'] = "Starting From";
$_LANG['freemium_banner_2_price_term'] = "/month";
$_LANG['freemium_banner_2_image_alt'] = "Reseller Hosting";
$_LANG['freemium_banner_2_image_video_badge'] = "Watch Video";
$_LANG['freemium_banner_2_button1_text'] = "Features";
$_LANG['freemium_banner_2_button2_text'] = "Get Started Now!";

// Slide 3

$_LANG['freemium_banner_3_heading'] = "About " . $_LANG['freemium_setting_companyname'];
$_LANG['freemium_banner_3_text'] = $_LANG['freemium_setting_companyname'] . " provide premium web hosting, domain registration & security services to businesses around the world. Our most popular service is our shared hosting which comes packed with many features and reliable support.";
$_LANG['freemium_banner_3_feat1'] = "";
$_LANG['freemium_banner_3_feat2'] = "";
$_LANG['freemium_banner_3_feat3'] = "";
$_LANG['freemium_banner_3_feat4'] = "";
$_LANG['freemium_banner_3_feat5'] = "";
$_LANG['freemium_banner_3_feat6'] = "";
$_LANG['freemium_banner_3_price_before'] = "";
$_LANG['freemium_banner_3_price_term'] = "";
$_LANG['freemium_banner_3_image_alt'] = "";
$_LANG['freemium_banner_3_image_video_badge'] = "";
$_LANG['freemium_banner_3_button1_text'] = "Why Choose " . $_LANG['freemium_setting_companyname'] . "?";
$_LANG['freemium_banner_3_button2_text'] = "Learn More About Us";

// Slide 4

$_LANG['freemium_banner_4_heading'] = "Shared Hosting";
$_LANG['freemium_banner_4_text'] = "Reliable cPanel Hosting Plans";
$_LANG['freemium_banner_4_feat1'] = "Unlimited domains, email & space";
$_LANG['freemium_banner_4_feat2'] = "Award-winning 24/7 technical support";
$_LANG['freemium_banner_4_feat3'] = "Money back guarantee with all plans";
$_LANG['freemium_banner_4_feat4'] = "Unlimited bandwidth reset monthly";
$_LANG['freemium_banner_4_feat5'] = "cPanel - easy-to-use control panel";
$_LANG['freemium_banner_4_feat6'] = "Perfect for personal websites and businesses";
$_LANG['freemium_banner_4_price_before'] = "Starting From";
$_LANG['freemium_banner_4_price_term'] = "/month";
$_LANG['freemium_banner_4_image_alt'] = "Web Hosting";
$_LANG['freemium_banner_4_image_video_badge'] = "Watch Video";
$_LANG['freemium_banner_4_button1_text'] = "Features";
$_LANG['freemium_banner_4_button2_text'] = "Get Started Now!";

// Slide 5

$_LANG['freemium_banner_5_heading'] = "Shared Hosting";
$_LANG['freemium_banner_5_text'] = "Reliable cPanel Hosting Plans";
$_LANG['freemium_banner_5_feat1'] = "Unlimited domains, email & space";
$_LANG['freemium_banner_5_feat2'] = "Award-winning 24/7 technical support";
$_LANG['freemium_banner_5_feat3'] = "Money back guarantee with all plans";
$_LANG['freemium_banner_5_feat4'] = "Unlimited bandwidth reset monthly";
$_LANG['freemium_banner_5_feat5'] = "cPanel - easy-to-use control panel";
$_LANG['freemium_banner_5_feat6'] = "Perfect for personal websites and businesses";
$_LANG['freemium_banner_5_price_before'] = "Starting From";
$_LANG['freemium_banner_5_price_term'] = "/month";
$_LANG['freemium_banner_5_image_alt'] = "Web Hosting";
$_LANG['freemium_banner_5_image_video_badge'] = "Watch Video";
$_LANG['freemium_banner_5_button1_text'] = "Features";
$_LANG['freemium_banner_5_button2_text'] = "Get Started Now!";

// Domain Checker

$_LANG['freemium_domainchecker_heading'] = "A Great Domain Means Instant Credibility";
$_LANG['freemium_domainchecker_subheading'] = "Register your perfect domain name from just $19.99/yr";
$_LANG['freemium_domainchecker_input'] = "yourcompanywebsite.com";
$_LANG['freemium_domainchecker_button'] = "Search";
$_LANG['freemium_domainchecker_image_alt'] = "Search TLDS"; 
$_LANG['freemium_domainchecker_tld_1_term'] = "/yr";
$_LANG['freemium_domainchecker_tld_2_term'] = "/yr";
$_LANG['freemium_domainchecker_tld_3_term'] = "/yr";
$_LANG['freemium_domainchecker_tld_4_term'] = "/yr";
$_LANG['freemium_domainchecker_tld_5_term'] = "/yr";

// Feature boxes (File: includes/feature-boxes.tpl)

$_LANG['freemium_homepage_plans_heading'] = "Choose Your Service To Get Started";

// Plan 1

$_LANG['freemium_homepage_featureboxes_plan1_name'] = "Shared Hosting";
$_LANG['freemium_homepage_featureboxes_plan1_desc'] = "Premium cPanel based web hosting";
$_LANG['freemium_homepage_featureboxes_plan1_image_alt'] = "Shared Hosting icon";
$_LANG['freemium_homepage_featureboxes_plan1_features'] = "Features";
$_LANG['freemium_homepage_featureboxes_plan1_feat1'] = "<strong>10GB Disk Space</strong>";
$_LANG['freemium_homepage_featureboxes_plan1_feat2'] = "<strong>100GB Bandwidth</strong>";
$_LANG['freemium_homepage_featureboxes_plan1_feat3'] = "<strong>5 Addon Domains</strong>";
$_LANG['freemium_homepage_featureboxes_plan1_feat4'] = "cPanel Control Panel";
$_LANG['freemium_homepage_featureboxes_plan1_feat5'] = "Softaculous Installer";
$_LANG['freemium_homepage_featureboxes_plan1_pricepre'] = "From";
$_LANG['freemium_homepage_featureboxes_plan1_term'] = "/monthly";
$_LANG['freemium_homepage_featureboxes_plan1_button1'] = "Learn More";
$_LANG['freemium_homepage_featureboxes_plan1_button2'] = "Order Now";

// Plan 2

$_LANG['freemium_homepage_featureboxes_plan2_name'] = "Reseller Hosting";
$_LANG['freemium_homepage_featureboxes_plan2_desc'] = "Start your own reseller business";
$_LANG['freemium_homepage_featureboxes_plan2_image_alt'] = "Reseller Hosting icon";
$_LANG['freemium_homepage_featureboxes_plan2_features'] = "Features";
$_LANG['freemium_homepage_featureboxes_plan2_feat1'] = "<strong>50GB Disk Space</strong>";
$_LANG['freemium_homepage_featureboxes_plan2_feat2'] = "<strong>500GB Bandwidth</strong>";
$_LANG['freemium_homepage_featureboxes_plan2_feat3'] = "<strong>cPanel/WHM</strong>";
$_LANG['freemium_homepage_featureboxes_plan2_feat4'] = "Overselling Enabled";
$_LANG['freemium_homepage_featureboxes_plan2_feat5'] = "Free WHMCS License";
$_LANG['freemium_homepage_featureboxes_plan2_pricepre'] = "From";
$_LANG['freemium_homepage_featureboxes_plan2_term'] = "/monthly";
$_LANG['freemium_homepage_featureboxes_plan2_button1'] = "Learn More";
$_LANG['freemium_homepage_featureboxes_plan2_button2'] = "Order Now";

// Plan 3

$_LANG['freemium_homepage_featureboxes_plan3_name'] = "VPS Hosting";
$_LANG['freemium_homepage_featureboxes_plan3_desc'] = "Take full control of your website";
$_LANG['freemium_homepage_featureboxes_plan3_image_alt'] = "VPS Hosting icon";
$_LANG['freemium_homepage_featureboxes_plan3_features'] = "Features";
$_LANG['freemium_homepage_featureboxes_plan3_feat1'] = "<strong>50GB Disk Space</strong>";
$_LANG['freemium_homepage_featureboxes_plan3_feat2'] = "<strong>1TB Bandwidth</strong>";
$_LANG['freemium_homepage_featureboxes_plan3_feat3'] = "<strong>Free cPanel License</strong>";
$_LANG['freemium_homepage_featureboxes_plan3_feat4'] = "SolusVM Included";
$_LANG['freemium_homepage_featureboxes_plan3_feat5'] = "VPS Templates";
$_LANG['freemium_homepage_featureboxes_plan3_pricepre'] = "From";
$_LANG['freemium_homepage_featureboxes_plan3_term'] = "/monthly";
$_LANG['freemium_homepage_featureboxes_plan3_button1'] = "Learn More";
$_LANG['freemium_homepage_featureboxes_plan3_button2'] = "Order Now";

// Plan 4

$_LANG['freemium_homepage_featureboxes_plan4_name'] = "Dedicated Servers";
$_LANG['freemium_homepage_featureboxes_plan4_desc'] = "Give your website the hosting it deserves";
$_LANG['freemium_homepage_featureboxes_plan4_image_alt'] = "Dedicated Servers icon";
$_LANG['freemium_homepage_featureboxes_plan4_features'] = "Features";
$_LANG['freemium_homepage_featureboxes_plan4_feat1'] = "<strong>2.8GHz</strong>";
$_LANG['freemium_homepage_featureboxes_plan4_feat2'] = "<strong>3 CPU Cores</strong>";
$_LANG['freemium_homepage_featureboxes_plan4_feat3'] = "<strong>4GB RAM</strong>";
$_LANG['freemium_homepage_featureboxes_plan4_feat4'] = "250GB Storage";
$_LANG['freemium_homepage_featureboxes_plan4_feat5'] = "2TB Bandwidth";
$_LANG['freemium_homepage_featureboxes_plan4_pricepre'] = "From";
$_LANG['freemium_homepage_featureboxes_plan4_term'] = "/monthly";
$_LANG['freemium_homepage_featureboxes_plan4_button1'] = "Learn More";
$_LANG['freemium_homepage_featureboxes_plan4_button2'] = "Order Now";

// Plan 5

$_LANG['freemium_homepage_featureboxes_plan5_name'] = "Cloud Hosting";
$_LANG['freemium_homepage_featureboxes_plan5_desc'] = "Next generation in website hosting";
$_LANG['freemium_homepage_featureboxes_plan5_image_alt'] = "Cloud Hosting icon";
$_LANG['freemium_homepage_featureboxes_plan5_features'] = "Features";
$_LANG['freemium_homepage_featureboxes_plan5_feat1'] = "<strong>10GB Disk Space</strong>";
$_LANG['freemium_homepage_featureboxes_plan5_feat2'] = "<strong>100GB Bandwidth</strong>";
$_LANG['freemium_homepage_featureboxes_plan5_feat3'] = "<strong>5 Addon Domains</strong>";
$_LANG['freemium_homepage_featureboxes_plan5_feat4'] = "cPanel Control Panel";
$_LANG['freemium_homepage_featureboxes_plan5_feat5'] = "Softaculous Installer";
$_LANG['freemium_homepage_featureboxes_plan5_pricepre'] = "From";
$_LANG['freemium_homepage_featureboxes_plan5_term'] = "/monthly";
$_LANG['freemium_homepage_featureboxes_plan5_button1'] = "Learn More";
$_LANG['freemium_homepage_featureboxes_plan5_button2'] = "Order Now";

// Plan 6

$_LANG['freemium_homepage_featureboxes_plan6_name'] = "Game Servers";
$_LANG['freemium_homepage_featureboxes_plan6_desc'] = "Call Of Duty, Medal Of Honour, Halo";
$_LANG['freemium_homepage_featureboxes_plan6_image_alt'] = "Game Servers icon";
$_LANG['freemium_homepage_featureboxes_plan6_features'] = "Features";
$_LANG['freemium_homepage_featureboxes_plan6_feat1'] = "<strong>Control Panel</strong>";
$_LANG['freemium_homepage_featureboxes_plan6_feat2'] = "<strong>Price Match</strong>";
$_LANG['freemium_homepage_featureboxes_plan6_feat3'] = "<strong>Fast & Reliable</strong>";
$_LANG['freemium_homepage_featureboxes_plan6_feat4'] = "Instant Setup";
$_LANG['freemium_homepage_featureboxes_plan6_feat5'] = "High Quality Network";
$_LANG['freemium_homepage_featureboxes_plan6_pricepre'] = "From";
$_LANG['freemium_homepage_featureboxes_plan6_term'] = "/slot";
$_LANG['freemium_homepage_featureboxes_plan6_button1'] = "Learn More";
$_LANG['freemium_homepage_featureboxes_plan6_button2'] = "Order Now";

// Plan 7

$_LANG['freemium_homepage_featureboxes_plan7_name'] = "VPN";
$_LANG['freemium_homepage_featureboxes_plan7_desc'] = "We offer low cost VPN servers";
$_LANG['freemium_homepage_featureboxes_plan7_image_alt'] = "VPN icon";
$_LANG['freemium_homepage_featureboxes_plan7_features'] = "Features";
$_LANG['freemium_homepage_featureboxes_plan7_feat1'] = "<strong>Easy To Setup</strong>";
$_LANG['freemium_homepage_featureboxes_plan7_feat2'] = "<strong>Anonymous Browsing</strong>";
$_LANG['freemium_homepage_featureboxes_plan7_feat3'] = "<strong>Unlimited Access</strong>";
$_LANG['freemium_homepage_featureboxes_plan7_feat4'] = "Low Fees";
$_LANG['freemium_homepage_featureboxes_plan7_feat5'] = "Reliable Support";
$_LANG['freemium_homepage_featureboxes_plan7_pricepre'] = "From";
$_LANG['freemium_homepage_featureboxes_plan7_term'] = "/user";
$_LANG['freemium_homepage_featureboxes_plan7_button1'] = "Learn More";
$_LANG['freemium_homepage_featureboxes_plan7_button2'] = "Order Now";

// Plan 8

$_LANG['freemium_homepage_featureboxes_plan8_name'] = "IPTV";
$_LANG['freemium_homepage_featureboxes_plan8_desc'] = "Stream hundreds of popular shows & movies ";
$_LANG['freemium_homepage_featureboxes_plan8_image_alt'] = "IPTV icon";
$_LANG['freemium_homepage_featureboxes_plan8_features'] = "Features";
$_LANG['freemium_homepage_featureboxes_plan8_feat1'] = "<strong>TV Shows & Movies</strong>";
$_LANG['freemium_homepage_featureboxes_plan8_feat2'] = "<strong>Unlimited Bandwidth</strong>";
$_LANG['freemium_homepage_featureboxes_plan8_feat3'] = "<strong>Secure Access</strong>";
$_LANG['freemium_homepage_featureboxes_plan8_feat4'] = "Desktop & Mobile Apps";
$_LANG['freemium_homepage_featureboxes_plan8_feat5'] = "Reliable Support";
$_LANG['freemium_homepage_featureboxes_plan8_pricepre'] = "From";
$_LANG['freemium_homepage_featureboxes_plan8_term'] = "/user";
$_LANG['freemium_homepage_featureboxes_plan8_button1'] = "Learn More";
$_LANG['freemium_homepage_featureboxes_plan8_button2'] = "Order Now";

// Plan 9

$_LANG['freemium_homepage_featureboxes_plan9_name'] = "Web Design Quote";
$_LANG['freemium_homepage_featureboxes_plan9_desc'] = "Hire us to create your website";
$_LANG['freemium_homepage_featureboxes_plan9_image_alt'] = "Web Design icon";
$_LANG['freemium_homepage_featureboxes_plan9_features'] = "Features";
$_LANG['freemium_homepage_featureboxes_plan9_feat1'] = "<strong>WordPress & HTML</strong>";
$_LANG['freemium_homepage_featureboxes_plan9_feat2'] = "<strong>10 Years Experience</strong>";
$_LANG['freemium_homepage_featureboxes_plan9_feat3'] = "<strong>SEO Included</strong>";
$_LANG['freemium_homepage_featureboxes_plan9_feat4'] = "FREE Domain";
$_LANG['freemium_homepage_featureboxes_plan9_feat5'] = "FREE Email";
$_LANG['freemium_homepage_featureboxes_plan9_pricepre'] = "";
$_LANG['freemium_homepage_featureboxes_plan9_term'] = "";
$_LANG['freemium_homepage_featureboxes_plan9_button1'] = "Learn More";
$_LANG['freemium_homepage_featureboxes_plan9_button2'] = "Quote";






/*
-----------------------------------------
---------   Shared Hosting page by default (File: web-hosting.tpl, web-hosting.php, includes/custom1.tpl)   ---------
-----------------------------------------
*/

// Banner

$_LANG['freemium_custom1_banner_heading'] = $_LANG['freemium_custom1_name'];
$_LANG['freemium_custom1_banner_text'] = "Reliable cPanel Hosting Plans";
$_LANG['freemium_custom1_banner_feat1'] = "Unlimited domains, email & space";
$_LANG['freemium_custom1_banner_feat2'] = "Award-winning 24/7 technical support";
$_LANG['freemium_custom1_banner_feat3'] = "Money back guarantee with all plans";
$_LANG['freemium_custom1_banner_feat4'] = "Unlimited bandwidth reset monthly";
$_LANG['freemium_custom1_banner_feat5'] = "cPanel - easy-to-use control panel";
$_LANG['freemium_custom1_banner_feat6'] = "Perfect for personal websites and businesses";
$_LANG['freemium_custom1_banner_price_before'] = "Starting From";
$_LANG['freemium_custom1_banner_price_term'] = "/month";
$_LANG['freemium_custom1_banner_image_alt'] = $_LANG['freemium_custom1_name'];
$_LANG['freemium_custom1_banner_image_video_badge'] = "Watch Video";
$_LANG['freemium_custom1_banner_button1_text'] = "Features";
$_LANG['freemium_custom1_banner_button2_text'] = "View Plans";

$_LANG['freemium_custom1_plans_heading'] = "Select Your Perfect " . $_LANG['freemium_custom1_name'] . " Plan";

// Table Layout

$_LANG['freemium_custom1_table_heading1'] = "Main Information";
$_LANG['freemium_custom1_table_feat1'] = "Web Space";
$_LANG['freemium_custom1_table_feat2'] = "Bandwidth";
$_LANG['freemium_custom1_table_feat3'] = "Control Panel";

$_LANG['freemium_custom1_table_heading2'] = "Plan Comparison";
$_LANG['freemium_custom1_table_feat4'] = "Web Space";
$_LANG['freemium_custom1_table_feat5'] = "Bandwidth";
$_LANG['freemium_custom1_table_feat6'] = "Addon Domains";
$_LANG['freemium_custom1_table_feat7'] = "Control Panel";
$_LANG['freemium_custom1_table_feat8'] = "Script Installer";
$_LANG['freemium_custom1_table_feat9'] = "Daily Backups";
$_LANG['freemium_custom1_table_feat10'] = "Server";
$_LANG['freemium_custom1_table_feat11'] = "Free Domain";
$_LANG['freemium_custom1_table_feat12'] = "Ticket Support";

$_LANG['freemium_custom1_table_heading3'] = "Key Features";
$_LANG['freemium_custom1_table_feat13'] = "Addon Domains";
$_LANG['freemium_custom1_table_feat14'] = "Databases";
$_LANG['freemium_custom1_table_feat15'] = "FTP Accounts";
$_LANG['freemium_custom1_table_feat16'] = "Email Accounts";
$_LANG['freemium_custom1_table_feat17'] = "Mailing lists";
$_LANG['freemium_custom1_table_feat18'] = "Subdomains";
$_LANG['freemium_custom1_table_feat19'] = "Email Limit";
$_LANG['freemium_custom1_table_feat20'] = "Auto Responders";
$_LANG['freemium_custom1_table_feat21'] = "File Manager";

$_LANG['freemium_custom1_table_heading4'] = "Free Software";
$_LANG['freemium_custom1_table_feat22'] = "Wordpress";
$_LANG['freemium_custom1_table_feat23'] = "Joomla";
$_LANG['freemium_custom1_table_feat24'] = "Drupal";
$_LANG['freemium_custom1_table_feat25'] = "Magento";
$_LANG['freemium_custom1_table_feat26'] = "Zen Cart";
$_LANG['freemium_custom1_table_feat27'] = "phpBB";
$_LANG['freemium_custom1_table_feat28'] = "myBB";
$_LANG['freemium_custom1_table_feat29'] = "SMF";
$_LANG['freemium_custom1_table_feat30'] = "PHPCoin";

// Plan 1

$_LANG['freemium_custom1_table_plan1_name'] = "Shared 1";
$_LANG['freemium_custom1_table_plan1_desc'] = "Perfect shared hosting plan for beginners";
$_LANG['freemium_custom1_table_plan1_pricepre'] = "Only";
$_LANG['freemium_custom1_table_plan1_term'] = "/month";
$_LANG['freemium_custom1_table_plan1_button'] = "Order Now";

// Plan 2

$_LANG['freemium_custom1_table_plan2_name'] = "Shared 2";
$_LANG['freemium_custom1_table_plan2_desc'] = "Reliable low-cost shared hosting plan";
$_LANG['freemium_custom1_table_plan2_pricepre'] = "Only";
$_LANG['freemium_custom1_table_plan2_term'] = "/month";
$_LANG['freemium_custom1_table_plan2_button'] = "Order Now";

// Plan 3

$_LANG['freemium_custom1_table_plan3_name'] = "Shared 3";
$_LANG['freemium_custom1_table_plan3_desc'] = "Advanced shared hosting package";
$_LANG['freemium_custom1_table_plan3_pricepre'] = "Only";
$_LANG['freemium_custom1_table_plan3_term'] = "/month";
$_LANG['freemium_custom1_table_plan3_button'] = "Order Now";

// Plan 4

$_LANG['freemium_custom1_table_plan4_name'] = "Shared 4";
$_LANG['freemium_custom1_table_plan4_desc'] = "Professional shared hosting plan";
$_LANG['freemium_custom1_table_plan4_pricepre'] = "Only";
$_LANG['freemium_custom1_table_plan4_term'] = "/month";
$_LANG['freemium_custom1_table_plan4_button'] = "Order Now";

// Plan 5

$_LANG['freemium_custom1_table_plan5_name'] = "Shared 5";
$_LANG['freemium_custom1_table_plan5_desc'] = "Suitable shared plan for web designers";
$_LANG['freemium_custom1_table_plan5_pricepre'] = "Only";
$_LANG['freemium_custom1_table_plan5_term'] = "/month";
$_LANG['freemium_custom1_table_plan5_button'] = "Order Now";

// Plan 6

$_LANG['freemium_custom1_table_plan6_name'] = "Shared 6";
$_LANG['freemium_custom1_table_plan6_desc'] = "The best shared plan for experts";
$_LANG['freemium_custom1_table_plan6_pricepre'] = "Only";
$_LANG['freemium_custom1_table_plan6_term'] = "/month";
$_LANG['freemium_custom1_table_plan6_button'] = "Order Now";

// Table2 Layout

$_LANG['freemium_custom1_table2_heading0'] = "Package";
$_LANG['freemium_custom1_table2_heading1'] = "Disk Space";
$_LANG['freemium_custom1_table2_heading2'] = "Bandwidth";
$_LANG['freemium_custom1_table2_heading3'] = "Control Panel";
$_LANG['freemium_custom1_table2_heading4'] = "Script Installer";
$_LANG['freemium_custom1_table2_heading5'] = "Online Editor";
$_LANG['freemium_custom1_table2_heading6'] = "Reliable Support";

// Plan 1

$_LANG['freemium_custom1_table2_plan1_name'] = "Shared 1";
$_LANG['freemium_custom1_table2_plan1_desc'] = "Perfect shared hosting plan for beginners";
$_LANG['freemium_custom1_table2_plan1_feat1'] = "10GB";
$_LANG['freemium_custom1_table2_plan1_feat2'] = "100GB";
$_LANG['freemium_custom1_table2_plan1_feat3'] = "cPanel";
$_LANG['freemium_custom1_table2_plan1_feat4'] = "Softaculous";
$_LANG['freemium_custom1_table2_plan1_feat5'] = "check";
$_LANG['freemium_custom1_table2_plan1_feat6'] = "check";
$_LANG['freemium_custom1_table2_plan1_pricepre'] = "Only";
$_LANG['freemium_custom1_table2_plan1_term'] = "/month";
$_LANG['freemium_custom1_table2_plan1_button'] = "Order Now";

// Plan 2

$_LANG['freemium_custom1_table2_plan2_name'] = "Shared 2";
$_LANG['freemium_custom1_table2_plan2_desc'] = "Reliable low-cost shared hosting plan";
$_LANG['freemium_custom1_table2_plan2_feat1'] = "20GB";
$_LANG['freemium_custom1_table2_plan2_feat2'] = "200GB";
$_LANG['freemium_custom1_table2_plan2_feat3'] = "cPanel";
$_LANG['freemium_custom1_table2_plan2_feat4'] = "Softaculous";
$_LANG['freemium_custom1_table2_plan2_feat5'] = "check";
$_LANG['freemium_custom1_table2_plan2_feat6'] = "check";
$_LANG['freemium_custom1_table2_plan2_pricepre'] = "Only";
$_LANG['freemium_custom1_table2_plan2_term'] = "/month";
$_LANG['freemium_custom1_table2_plan2_button'] = "Order Now";

// Plan 3

$_LANG['freemium_custom1_table2_plan3_name'] = "Shared 3";
$_LANG['freemium_custom1_table2_plan3_desc'] = "Advanced shared hosting package";
$_LANG['freemium_custom1_table2_plan3_feat1'] = "30GB";
$_LANG['freemium_custom1_table2_plan3_feat2'] = "300GB";
$_LANG['freemium_custom1_table2_plan3_feat3'] = "cPanel";
$_LANG['freemium_custom1_table2_plan3_feat4'] = "Softaculous";
$_LANG['freemium_custom1_table2_plan3_feat5'] = "check";
$_LANG['freemium_custom1_table2_plan3_feat6'] = "check";
$_LANG['freemium_custom1_table2_plan3_pricepre'] = "Only";
$_LANG['freemium_custom1_table2_plan3_term'] = "/month";
$_LANG['freemium_custom1_table2_plan3_button'] = "Order Now";

// Plan 4

$_LANG['freemium_custom1_table2_plan4_name'] = "Shared 4";
$_LANG['freemium_custom1_table2_plan4_desc'] = "Professional shared hosting plan";
$_LANG['freemium_custom1_table2_plan4_feat1'] = "40GB";
$_LANG['freemium_custom1_table2_plan4_feat2'] = "400GB";
$_LANG['freemium_custom1_table2_plan4_feat3'] = "cPanel";
$_LANG['freemium_custom1_table2_plan4_feat4'] = "Softaculous";
$_LANG['freemium_custom1_table2_plan4_feat5'] = "check";
$_LANG['freemium_custom1_table2_plan4_feat6'] = "check";
$_LANG['freemium_custom1_table2_plan4_pricepre'] = "Only";
$_LANG['freemium_custom1_table2_plan4_term'] = "/month";
$_LANG['freemium_custom1_table2_plan4_button'] = "Order Now";

// Plan 5

$_LANG['freemium_custom1_table2_plan5_name'] = "Shared 5";
$_LANG['freemium_custom1_table2_plan5_desc'] = "Suitable shared plan for web designers";
$_LANG['freemium_custom1_table2_plan5_feat1'] = "50GB";
$_LANG['freemium_custom1_table2_plan5_feat2'] = "500GB";
$_LANG['freemium_custom1_table2_plan5_feat3'] = "cPanel";
$_LANG['freemium_custom1_table2_plan5_feat4'] = "Softaculous";
$_LANG['freemium_custom1_table2_plan5_feat5'] = "check";
$_LANG['freemium_custom1_table2_plan5_feat6'] = "check";
$_LANG['freemium_custom1_table2_plan5_pricepre'] = "Only";
$_LANG['freemium_custom1_table2_plan5_term'] = "/month";
$_LANG['freemium_custom1_table2_plan5_button'] = "Order Now";

// Plan 6

$_LANG['freemium_custom1_table2_plan6_name'] = "Shared 6";
$_LANG['freemium_custom1_table2_plan6_desc'] = "The best shared plan for experts";
$_LANG['freemium_custom1_table2_plan6_feat1'] = "60GB";
$_LANG['freemium_custom1_table2_plan6_feat2'] = "600GB";
$_LANG['freemium_custom1_table2_plan6_feat3'] = "cPanel";
$_LANG['freemium_custom1_table2_plan6_feat4'] = "Softaculous";
$_LANG['freemium_custom1_table2_plan6_feat5'] = "check";
$_LANG['freemium_custom1_table2_plan6_feat6'] = "check";
$_LANG['freemium_custom1_table2_plan6_pricepre'] = "Only";
$_LANG['freemium_custom1_table2_plan6_term'] = "/month";
$_LANG['freemium_custom1_table2_plan6_button'] = "Order Now";

// Plan 7

$_LANG['freemium_custom1_table2_plan7_name'] = "Shared 7";
$_LANG['freemium_custom1_table2_plan7_desc'] = "The best shared plan for experts";
$_LANG['freemium_custom1_table2_plan7_feat1'] = "70GB";
$_LANG['freemium_custom1_table2_plan7_feat2'] = "700GB";
$_LANG['freemium_custom1_table2_plan7_feat3'] = "cPanel";
$_LANG['freemium_custom1_table2_plan7_feat4'] = "Softaculous";
$_LANG['freemium_custom1_table2_plan7_feat5'] = "check";
$_LANG['freemium_custom1_table2_plan7_feat6'] = "check";
$_LANG['freemium_custom1_table2_plan7_pricepre'] = "Only";
$_LANG['freemium_custom1_table2_plan7_term'] = "/month";
$_LANG['freemium_custom1_table2_plan7_button'] = "Order Now";

// Plan 8

$_LANG['freemium_custom1_table2_plan8_name'] = "Shared 8";
$_LANG['freemium_custom1_table2_plan8_desc'] = "The best shared plan for experts";
$_LANG['freemium_custom1_table2_plan8_feat1'] = "80GB";
$_LANG['freemium_custom1_table2_plan8_feat2'] = "800GB";
$_LANG['freemium_custom1_table2_plan8_feat3'] = "cPanel";
$_LANG['freemium_custom1_table2_plan8_feat4'] = "Softaculous";
$_LANG['freemium_custom1_table2_plan8_feat5'] = "check";
$_LANG['freemium_custom1_table2_plan8_feat6'] = "check";
$_LANG['freemium_custom1_table2_plan8_pricepre'] = "Only";
$_LANG['freemium_custom1_table2_plan8_term'] = "/month";
$_LANG['freemium_custom1_table2_plan8_button'] = "Order Now";

// Plan 9

$_LANG['freemium_custom1_table2_plan9_name'] = "Shared 9";
$_LANG['freemium_custom1_table2_plan9_desc'] = "The best shared plan for experts";
$_LANG['freemium_custom1_table2_plan9_feat1'] = "90GB";
$_LANG['freemium_custom1_table2_plan9_feat2'] = "900GB";
$_LANG['freemium_custom1_table2_plan9_feat3'] = "cPanel";
$_LANG['freemium_custom1_table2_plan9_feat4'] = "Softaculous";
$_LANG['freemium_custom1_table2_plan9_feat5'] = "check";
$_LANG['freemium_custom1_table2_plan9_feat6'] = "check";
$_LANG['freemium_custom1_table2_plan9_pricepre'] = "Only";
$_LANG['freemium_custom1_table2_plan9_term'] = "/month";
$_LANG['freemium_custom1_table2_plan9_button'] = "Order Now";

// Plan 10

$_LANG['freemium_custom1_table2_plan10_name'] = "Shared 10";
$_LANG['freemium_custom1_table2_plan10_desc'] = "The best shared plan for experts";
$_LANG['freemium_custom1_table2_plan10_feat1'] = "100GB";
$_LANG['freemium_custom1_table2_plan10_feat2'] = "1TB";
$_LANG['freemium_custom1_table2_plan10_feat3'] = "cPanel";
$_LANG['freemium_custom1_table2_plan10_feat4'] = "Softaculous";
$_LANG['freemium_custom1_table2_plan10_feat5'] = "check";
$_LANG['freemium_custom1_table2_plan10_feat6'] = "check";
$_LANG['freemium_custom1_table2_plan10_pricepre'] = "Only";
$_LANG['freemium_custom1_table2_plan10_term'] = "/month";
$_LANG['freemium_custom1_table2_plan10_button'] = "Order Now";

// Feature Boxes Layout

// Plan 1

$_LANG['freemium_custom1_featureboxes_plan1_name'] = "Shared 1";
$_LANG['freemium_custom1_featureboxes_plan1_desc'] = "Perfect shared hosting plan for beginners";
$_LANG['freemium_custom1_featureboxes_plan1_image_alt'] = "Shared 1 icon";
$_LANG['freemium_custom1_featureboxes_plan1_features'] = "Features";
$_LANG['freemium_custom1_featureboxes_plan1_feat1'] = "<strong>10GB Disk Space</strong>";
$_LANG['freemium_custom1_featureboxes_plan1_feat2'] = "<strong>100GB Bandwidth</strong>";
$_LANG['freemium_custom1_featureboxes_plan1_feat3'] = "<strong>5 Addon Domains</strong>";
$_LANG['freemium_custom1_featureboxes_plan1_feat4'] = "cPanel Control Panel";
$_LANG['freemium_custom1_featureboxes_plan1_feat5'] = "Softaculous Installer";
$_LANG['freemium_custom1_featureboxes_plan1_pricepre'] = "Only";
$_LANG['freemium_custom1_featureboxes_plan1_term'] = "/month";
$_LANG['freemium_custom1_featureboxes_plan1_button1'] = "Features";
$_LANG['freemium_custom1_featureboxes_plan1_button2'] = "Order Now";

// Plan 2

$_LANG['freemium_custom1_featureboxes_plan2_name'] = "Shared 2";
$_LANG['freemium_custom1_featureboxes_plan2_desc'] = "Reliable low-cost shared hosting plan";
$_LANG['freemium_custom1_featureboxes_plan2_image_alt'] = "Shared 2 icon";
$_LANG['freemium_custom1_featureboxes_plan2_features'] = "Features";
$_LANG['freemium_custom1_featureboxes_plan2_feat1'] = "<strong>20GB Disk Space</strong>";
$_LANG['freemium_custom1_featureboxes_plan2_feat2'] = "<strong>200GB Bandwidth</strong>";
$_LANG['freemium_custom1_featureboxes_plan2_feat3'] = "<strong>10 Addon Domains</strong>";
$_LANG['freemium_custom1_featureboxes_plan2_feat4'] = "cPanel Control Panel";
$_LANG['freemium_custom1_featureboxes_plan2_feat5'] = "Softaculous Installer";
$_LANG['freemium_custom1_featureboxes_plan2_pricepre'] = "Only";
$_LANG['freemium_custom1_featureboxes_plan2_term'] = "/month";
$_LANG['freemium_custom1_featureboxes_plan2_button1'] = "Features";
$_LANG['freemium_custom1_featureboxes_plan2_button2'] = "Order Now";

// Plan 3

$_LANG['freemium_custom1_featureboxes_plan3_name'] = "Shared 3";
$_LANG['freemium_custom1_featureboxes_plan3_desc'] = "Advanced shared hosting package";
$_LANG['freemium_custom1_featureboxes_plan3_image_alt'] = "Shared 3 icon";
$_LANG['freemium_custom1_featureboxes_plan3_features'] = "Features";
$_LANG['freemium_custom1_featureboxes_plan3_feat1'] = "<strong>30GB Disk Space</strong>";
$_LANG['freemium_custom1_featureboxes_plan3_feat2'] = "<strong>300GB Bandwidth</strong>";
$_LANG['freemium_custom1_featureboxes_plan3_feat3'] = "<strong>Unlimited Addon Domains</strong>";
$_LANG['freemium_custom1_featureboxes_plan3_feat4'] = "cPanel Control Panel";
$_LANG['freemium_custom1_featureboxes_plan3_feat5'] = "Softaculous Installer";
$_LANG['freemium_custom1_featureboxes_plan3_pricepre'] = "Only";
$_LANG['freemium_custom1_featureboxes_plan3_term'] = "/month";
$_LANG['freemium_custom1_featureboxes_plan3_button1'] = "Features";
$_LANG['freemium_custom1_featureboxes_plan3_button2'] = "Order Now";

// Plan 4

$_LANG['freemium_custom1_featureboxes_plan4_name'] = "Shared 4";
$_LANG['freemium_custom1_featureboxes_plan4_desc'] = "Professional shared hosting plan";
$_LANG['freemium_custom1_featureboxes_plan4_image_alt'] = "Shared 4 icon";
$_LANG['freemium_custom1_featureboxes_plan4_features'] = "Features";
$_LANG['freemium_custom1_featureboxes_plan4_feat1'] = "<strong>40GB Disk Space</strong>";
$_LANG['freemium_custom1_featureboxes_plan4_feat2'] = "<strong>400GB Bandwidth</strong>";
$_LANG['freemium_custom1_featureboxes_plan4_feat3'] = "<strong>Unlimited Addon Domains</strong>";
$_LANG['freemium_custom1_featureboxes_plan4_feat4'] = "cPanel Control Panel";
$_LANG['freemium_custom1_featureboxes_plan4_feat5'] = "Softaculous Installer";
$_LANG['freemium_custom1_featureboxes_plan4_pricepre'] = "Only";
$_LANG['freemium_custom1_featureboxes_plan4_term'] = "/month";
$_LANG['freemium_custom1_featureboxes_plan4_button1'] = "Features";
$_LANG['freemium_custom1_featureboxes_plan4_button2'] = "Order Now";

// Plan 5

$_LANG['freemium_custom1_featureboxes_plan5_name'] = "Shared 5";
$_LANG['freemium_custom1_featureboxes_plan5_desc'] = "Suitable shared plan for web designers";
$_LANG['freemium_custom1_featureboxes_plan5_image_alt'] = "Shared 5 icon";
$_LANG['freemium_custom1_featureboxes_plan5_features'] = "Features";
$_LANG['freemium_custom1_featureboxes_plan5_feat1'] = "<strong>50GB Disk Space</strong>";
$_LANG['freemium_custom1_featureboxes_plan5_feat2'] = "<strong>500GB Bandwidth</strong>";
$_LANG['freemium_custom1_featureboxes_plan5_feat3'] = "<strong>Unlimited Addon Domains</strong>";
$_LANG['freemium_custom1_featureboxes_plan5_feat4'] = "cPanel Control Panel";
$_LANG['freemium_custom1_featureboxes_plan5_feat5'] = "Softaculous Installer";
$_LANG['freemium_custom1_featureboxes_plan5_pricepre'] = "Only";
$_LANG['freemium_custom1_featureboxes_plan5_term'] = "/month";
$_LANG['freemium_custom1_featureboxes_plan5_button1'] = "Features";
$_LANG['freemium_custom1_featureboxes_plan5_button2'] = "Order Now";

// Plan 6

$_LANG['freemium_custom1_featureboxes_plan6_name'] = "Shared 6";
$_LANG['freemium_custom1_featureboxes_plan6_desc'] = "The best shared plan for experts";
$_LANG['freemium_custom1_featureboxes_plan6_image_alt'] = "Shared 6 icon";
$_LANG['freemium_custom1_featureboxes_plan6_features'] = "Features";
$_LANG['freemium_custom1_featureboxes_plan6_feat1'] = "<strong>60GB Disk Space</strong>";
$_LANG['freemium_custom1_featureboxes_plan6_feat2'] = "<strong>600GB Bandwidth</strong>";
$_LANG['freemium_custom1_featureboxes_plan6_feat3'] = "<strong>Unlimited Addon Domains</strong>";
$_LANG['freemium_custom1_featureboxes_plan6_feat4'] = "cPanel Control Panel";
$_LANG['freemium_custom1_featureboxes_plan6_feat5'] = "Softaculous Installer";
$_LANG['freemium_custom1_featureboxes_plan6_pricepre'] = "Only";
$_LANG['freemium_custom1_featureboxes_plan6_term'] = "/month";
$_LANG['freemium_custom1_featureboxes_plan6_button1'] = "Features";
$_LANG['freemium_custom1_featureboxes_plan6_button2'] = "Order Now";

// Plan 7

$_LANG['freemium_custom1_featureboxes_plan7_name'] = "Shared 7";
$_LANG['freemium_custom1_featureboxes_plan7_desc'] = "The best shared plan for experts";
$_LANG['freemium_custom1_featureboxes_plan7_image_alt'] = "Shared 7 icon";
$_LANG['freemium_custom1_featureboxes_plan7_features'] = "Features";
$_LANG['freemium_custom1_featureboxes_plan7_feat1'] = "<strong>70GB Disk Space</strong>";
$_LANG['freemium_custom1_featureboxes_plan7_feat2'] = "<strong>700GB Bandwidth</strong>";
$_LANG['freemium_custom1_featureboxes_plan7_feat3'] = "<strong>Unlimited Addon Domains</strong>";
$_LANG['freemium_custom1_featureboxes_plan7_feat4'] = "cPanel Control Panel";
$_LANG['freemium_custom1_featureboxes_plan7_feat5'] = "Softaculous Installer";
$_LANG['freemium_custom1_featureboxes_plan7_pricepre'] = "Only";
$_LANG['freemium_custom1_featureboxes_plan7_term'] = "/month";
$_LANG['freemium_custom1_featureboxes_plan7_button1'] = "Features";
$_LANG['freemium_custom1_featureboxes_plan7_button2'] = "Order Now";

// Plan 8

$_LANG['freemium_custom1_featureboxes_plan8_name'] = "Shared 8";
$_LANG['freemium_custom1_featureboxes_plan8_desc'] = "The best shared plan for experts";
$_LANG['freemium_custom1_featureboxes_plan8_image_alt'] = "Shared 8 icon";
$_LANG['freemium_custom1_featureboxes_plan8_features'] = "Features";
$_LANG['freemium_custom1_featureboxes_plan8_feat1'] = "<strong>80GB Disk Space</strong>";
$_LANG['freemium_custom1_featureboxes_plan8_feat2'] = "<strong>800GB Bandwidth</strong>";
$_LANG['freemium_custom1_featureboxes_plan8_feat3'] = "<strong>Unlimited Addon Domains</strong>";
$_LANG['freemium_custom1_featureboxes_plan8_feat4'] = "cPanel Control Panel";
$_LANG['freemium_custom1_featureboxes_plan8_feat5'] = "Softaculous Installer";
$_LANG['freemium_custom1_featureboxes_plan8_pricepre'] = "Only";
$_LANG['freemium_custom1_featureboxes_plan8_term'] = "/month";
$_LANG['freemium_custom1_featureboxes_plan8_button1'] = "Features";
$_LANG['freemium_custom1_featureboxes_plan8_button2'] = "Order Now";

// Plan 9

$_LANG['freemium_custom1_featureboxes_plan9_name'] = "Shared 9";
$_LANG['freemium_custom1_featureboxes_plan9_desc'] = "The best shared plan for experts";
$_LANG['freemium_custom1_featureboxes_plan9_image_alt'] = "Shared 9 icon";
$_LANG['freemium_custom1_featureboxes_plan9_features'] = "Features";
$_LANG['freemium_custom1_featureboxes_plan9_feat1'] = "<strong>90GB Disk Space</strong>";
$_LANG['freemium_custom1_featureboxes_plan9_feat2'] = "<strong>900GB Bandwidth</strong>";
$_LANG['freemium_custom1_featureboxes_plan9_feat3'] = "<strong>Unlimited Addon Domains</strong>";
$_LANG['freemium_custom1_featureboxes_plan9_feat4'] = "cPanel Control Panel";
$_LANG['freemium_custom1_featureboxes_plan9_feat5'] = "Softaculous Installer";
$_LANG['freemium_custom1_featureboxes_plan9_pricepre'] = "Only";
$_LANG['freemium_custom1_featureboxes_plan9_term'] = "/month";
$_LANG['freemium_custom1_featureboxes_plan9_button1'] = "Features";
$_LANG['freemium_custom1_featureboxes_plan9_button2'] = "Order Now";

// Plan 10

$_LANG['freemium_custom1_featureboxes_plan10_name'] = "Shared 10";
$_LANG['freemium_custom1_featureboxes_plan10_desc'] = "The best shared plan for experts";
$_LANG['freemium_custom1_featureboxes_plan10_image_alt'] = "Shared 10 icon";
$_LANG['freemium_custom1_featureboxes_plan10_features'] = "Features";
$_LANG['freemium_custom1_featureboxes_plan10_feat1'] = "<strong>100GB Disk Space</strong>";
$_LANG['freemium_custom1_featureboxes_plan10_feat2'] = "<strong>1TB Bandwidth</strong>";
$_LANG['freemium_custom1_featureboxes_plan10_feat3'] = "<strong>Unlimited Addon Domains</strong>";
$_LANG['freemium_custom1_featureboxes_plan10_feat4'] = "cPanel Control Panel";
$_LANG['freemium_custom1_featureboxes_plan10_feat5'] = "Softaculous Installer";
$_LANG['freemium_custom1_featureboxes_plan10_pricepre'] = "Only";
$_LANG['freemium_custom1_featureboxes_plan10_term'] = "/month";
$_LANG['freemium_custom1_featureboxes_plan10_button1'] = "Features";
$_LANG['freemium_custom1_featureboxes_plan10_button2'] = "Order Now";

// Slider Layout

$_LANG['freemium_custom1_slider_heading1'] = "Disk Space";
$_LANG['freemium_custom1_slider_heading2'] = "Bandwidth";
$_LANG['freemium_custom1_slider_heading3'] = "Control Panel";
$_LANG['freemium_custom1_slider_heading4'] = "Script Installer";
$_LANG['freemium_custom1_slider_heading5'] = "Support";

// Plan 1

$_LANG['freemium_custom1_slider_plan1_name'] = "Shared 1";
$_LANG['freemium_custom1_slider_plan1_desc'] = "Perfect shared hosting plan for beginners";
$_LANG['freemium_custom1_slider_plan1_feat1'] = "10GB";
$_LANG['freemium_custom1_slider_plan1_feat2'] = "100GB";
$_LANG['freemium_custom1_slider_plan1_feat3'] = "cPanel";
$_LANG['freemium_custom1_slider_plan1_feat4'] = "Softaculous";
$_LANG['freemium_custom1_slider_plan1_feat5'] = "Tickets";
$_LANG['freemium_custom1_slider_plan1_pricepre'] = "Only";
$_LANG['freemium_custom1_slider_plan1_term'] = "/month";
$_LANG['freemium_custom1_slider_plan1_button'] = "Order Now";

// Plan 2

$_LANG['freemium_custom1_slider_plan2_name'] = "Shared 2";
$_LANG['freemium_custom1_slider_plan2_desc'] = "Reliable low-cost shared hosting plan";
$_LANG['freemium_custom1_slider_plan2_feat1'] = "20GB";
$_LANG['freemium_custom1_slider_plan2_feat2'] = "200GB";
$_LANG['freemium_custom1_slider_plan2_feat3'] = "cPanel";
$_LANG['freemium_custom1_slider_plan2_feat4'] = "Softaculous";
$_LANG['freemium_custom1_slider_plan2_feat5'] = "Tickets";
$_LANG['freemium_custom1_slider_plan2_pricepre'] = "Only";
$_LANG['freemium_custom1_slider_plan2_term'] = "/month";
$_LANG['freemium_custom1_slider_plan2_button'] = "Order Now";

// Plan 3

$_LANG['freemium_custom1_slider_plan3_name'] = "Shared 3";
$_LANG['freemium_custom1_slider_plan3_desc'] = "Advanced shared hosting package";
$_LANG['freemium_custom1_slider_plan3_feat1'] = "30GB";
$_LANG['freemium_custom1_slider_plan3_feat2'] = "300GB";
$_LANG['freemium_custom1_slider_plan3_feat3'] = "cPanel";
$_LANG['freemium_custom1_slider_plan3_feat4'] = "Softaculous";
$_LANG['freemium_custom1_slider_plan3_feat5'] = "Tickets";
$_LANG['freemium_custom1_slider_plan3_pricepre'] = "Only";
$_LANG['freemium_custom1_slider_plan3_term'] = "/month";
$_LANG['freemium_custom1_slider_plan3_button'] = "Order Now";

// Plan 4

$_LANG['freemium_custom1_slider_plan4_name'] = "Shared 4";
$_LANG['freemium_custom1_slider_plan4_desc'] = "Professional shared hosting plan";
$_LANG['freemium_custom1_slider_plan4_feat1'] = "40GB";
$_LANG['freemium_custom1_slider_plan4_feat2'] = "400GB";
$_LANG['freemium_custom1_slider_plan4_feat3'] = "cPanel";
$_LANG['freemium_custom1_slider_plan4_feat4'] = "Softaculous";
$_LANG['freemium_custom1_slider_plan4_feat5'] = "Tickets";
$_LANG['freemium_custom1_slider_plan4_pricepre'] = "Only";
$_LANG['freemium_custom1_slider_plan4_term'] = "/month";
$_LANG['freemium_custom1_slider_plan4_button'] = "Order Now";

// Plan 5

$_LANG['freemium_custom1_slider_plan5_name'] = "Shared 5";
$_LANG['freemium_custom1_slider_plan5_desc'] = "Suitable shared plan for web designers";
$_LANG['freemium_custom1_slider_plan5_feat1'] = "50GB";
$_LANG['freemium_custom1_slider_plan5_feat2'] = "500GB";
$_LANG['freemium_custom1_slider_plan5_feat3'] = "cPanel";
$_LANG['freemium_custom1_slider_plan5_feat4'] = "Softaculous";
$_LANG['freemium_custom1_slider_plan5_feat5'] = "Tickets";
$_LANG['freemium_custom1_slider_plan5_pricepre'] = "Only";
$_LANG['freemium_custom1_slider_plan5_term'] = "/month";
$_LANG['freemium_custom1_slider_plan5_button'] = "Order Now";

// Plan 6

$_LANG['freemium_custom1_slider_plan6_name'] = "Shared 6";
$_LANG['freemium_custom1_slider_plan6_desc'] = "The best shared plan for experts";
$_LANG['freemium_custom1_slider_plan6_feat1'] = "60GB";
$_LANG['freemium_custom1_slider_plan6_feat2'] = "600GB";
$_LANG['freemium_custom1_slider_plan6_feat3'] = "cPanel";
$_LANG['freemium_custom1_slider_plan6_feat4'] = "Softaculous";
$_LANG['freemium_custom1_slider_plan6_feat5'] = "Tickets";
$_LANG['freemium_custom1_slider_plan6_pricepre'] = "Only";
$_LANG['freemium_custom1_slider_plan6_term'] = "/month";
$_LANG['freemium_custom1_slider_plan6_button'] = "Order Now";

// Plan 7

$_LANG['freemium_custom1_slider_plan7_name'] = "Shared 7";
$_LANG['freemium_custom1_slider_plan7_desc'] = "The best shared plan for experts";
$_LANG['freemium_custom1_slider_plan7_feat1'] = "70GB";
$_LANG['freemium_custom1_slider_plan7_feat2'] = "700GB";
$_LANG['freemium_custom1_slider_plan7_feat3'] = "cPanel";
$_LANG['freemium_custom1_slider_plan7_feat4'] = "Softaculous";
$_LANG['freemium_custom1_slider_plan7_feat5'] = "Tickets";
$_LANG['freemium_custom1_slider_plan7_pricepre'] = "Only";
$_LANG['freemium_custom1_slider_plan7_term'] = "/month";
$_LANG['freemium_custom1_slider_plan7_button'] = "Order Now";

// Plan 8

$_LANG['freemium_custom1_slider_plan8_name'] = "Shared 8";
$_LANG['freemium_custom1_slider_plan8_desc'] = "The best shared plan for experts";
$_LANG['freemium_custom1_slider_plan8_feat1'] = "80GB";
$_LANG['freemium_custom1_slider_plan8_feat2'] = "800GB";
$_LANG['freemium_custom1_slider_plan8_feat3'] = "cPanel";
$_LANG['freemium_custom1_slider_plan8_feat4'] = "Softaculous";
$_LANG['freemium_custom1_slider_plan8_feat5'] = "Tickets";
$_LANG['freemium_custom1_slider_plan8_pricepre'] = "Only";
$_LANG['freemium_custom1_slider_plan8_term'] = "/month";
$_LANG['freemium_custom1_slider_plan8_button'] = "Order Now";

// Plan 9

$_LANG['freemium_custom1_slider_plan9_name'] = "Shared 9";
$_LANG['freemium_custom1_slider_plan9_desc'] = "The best shared plan for experts";
$_LANG['freemium_custom1_slider_plan9_feat1'] = "90GB";
$_LANG['freemium_custom1_slider_plan9_feat2'] = "900GB";
$_LANG['freemium_custom1_slider_plan9_feat3'] = "cPanel";
$_LANG['freemium_custom1_slider_plan9_feat4'] = "Softaculous";
$_LANG['freemium_custom1_slider_plan9_feat5'] = "Tickets";
$_LANG['freemium_custom1_slider_plan9_pricepre'] = "Only";
$_LANG['freemium_custom1_slider_plan9_term'] = "/month";
$_LANG['freemium_custom1_slider_plan9_button'] = "Order Now";

// Plan 10

$_LANG['freemium_custom1_slider_plan10_name'] = "Shared 10";
$_LANG['freemium_custom1_slider_plan10_desc'] = "The best shared plan for experts";
$_LANG['freemium_custom1_slider_plan10_feat1'] = "100GB";
$_LANG['freemium_custom1_slider_plan10_feat2'] = "1TB";
$_LANG['freemium_custom1_slider_plan10_feat3'] = "cPanel";
$_LANG['freemium_custom1_slider_plan10_feat4'] = "Softaculous";
$_LANG['freemium_custom1_slider_plan10_feat5'] = "Tickets";
$_LANG['freemium_custom1_slider_plan10_pricepre'] = "Only";
$_LANG['freemium_custom1_slider_plan10_term'] = "/month";
$_LANG['freemium_custom1_slider_plan10_button'] = "Order Now";






/*
-----------------------------------------
---------   SEO (File: includes/seo.tpl)   ---------
-----------------------------------------
*/

// Homepage

$_LANG['freemium_meta_title_index'] = "Professional Web Hosting - We provide solid web hosting &amp; domain registration services!";
$_LANG['freemium_meta_description_index'] = "Professional web services for businesses and individuals.";
$_LANG['freemium_meta_tags_index'] = "shared hosting, reseller hosting, vps hosting, dedicated hosting, domain registration";

// Register Domain

$_LANG['freemium_meta_title_registerdomain'] = "Domain Registration - Search &amp; register your domains here";
$_LANG['freemium_meta_description_registerdomain'] = "Affordable domain registration service with multiple extension options.";
$_LANG['freemium_meta_tags_registerdomain'] = "domain registration, domains, domain checker, WHOIS";

// Transfer Domain

$_LANG['freemium_meta_title_transferdomain'] = "Transfer your domain to our company";
$_LANG['freemium_meta_description_transferdomain'] = "Now you can transfer multiple domains to our company";
$_LANG['freemium_meta_tags_transferdomain'] = "domain registration, domains, domain checker, whois";

// Custom1

$_LANG['freemium_meta_title_custom1'] = "Shared Hosting - We provide professional &amp; affordable cPanel hosting";
$_LANG['freemium_meta_description_custom1'] = "We provide top quality cPanel hosting which is perfect for any type of website.";
$_LANG['freemium_meta_tags_custom1'] = "shared hosting, cpanel hosting, website hosting, web hosting";

// Custom2

$_LANG['freemium_meta_title_custom2'] = "Reseller Hosting - Become your own boss by starting a web hosting company";
$_LANG['freemium_meta_description_custom2'] = "We provide reseller web hosting which allows you to easily create your own web hosting business.";
$_LANG['freemium_meta_tags_custom2'] = "reseller hosting, reseller web hosting, whm hosting";

// Custom3

$_LANG['freemium_meta_title_custom3'] = "VPS Hosting - High resource VPS hosting for individuals &amp; businesses alike";
$_LANG['freemium_meta_description_custom3'] = "The best VPS hosting at an affordable price.";
$_LANG['freemium_meta_tags_custom3'] = "vps hosting, vps, vps server";

// Custom4

$_LANG['freemium_meta_title_custom4'] = "Dedicated Servers - We manage your server so you can focus on your business!";
$_LANG['freemium_meta_description_custom4'] = "Our dedicated servers are a great choice for any enterprise as they come fully managed by us.";
$_LANG['freemium_meta_tags_custom4'] = "dedicated hosting, dedicated servers";

// Custom5

$_LANG['freemium_meta_title_custom5'] = "Cloud Hosting - Host your website on our next generation servers!";
$_LANG['freemium_meta_description_custom5'] = "Our cloud hosting is a scalable &amp; quality hosting service.";
$_LANG['freemium_meta_tags_custom5'] = "cloud hosting, cloud servers, cloud";

// Custom6

$_LANG['freemium_meta_title_custom6'] = "Game Servers - Setup your own game server today!";
$_LANG['freemium_meta_description_custom6'] = "Our game servers are fast, reliable &amp; more importantly affordable.";
$_LANG['freemium_meta_tags_custom6'] = "game servers, game hosting, gaming";

// Custom7

$_LANG['freemium_meta_title_custom7'] = "Premium quality Virtual Private Network servers (VPN)";
$_LANG['freemium_meta_description_custom7'] = "We provide the most reliable Virtual Private Networks in the industry.";
$_LANG['freemium_meta_tags_custom7'] = "vpns, vpn, virtual private network";

// Custom8

$_LANG['freemium_meta_title_custom8'] = "Stream hundreds of high quality tv shows & movies";
$_LANG['freemium_meta_description_custom8'] = "We provide a very reliable and fast speed streaming service";
$_LANG['freemium_meta_tags_custom8'] = "streaming, speed, high quality";

// Custom9

$_LANG['freemium_meta_title_custom9'] = "Web Hosting Addons - dedicated IPs, disk space/bandwidth upgrades and more!";
$_LANG['freemium_meta_description_custom9'] = "Enhance your web hosting account with our hosting addons";
$_LANG['freemium_meta_tags_custom9'] = "web hosting, web hosting addons, hosting addons";

// Custom10

$_LANG['freemium_meta_title_custom10'] = "Hire us to create the perfect website for you";
$_LANG['freemium_meta_description_custom10'] = "All of our websites are built using the power of WordPress";
$_LANG['freemium_meta_tags_custom10'] = "web design, wordpress";

// SSL Certificates (WHMCS Marketconnect page)

$_LANG['freemium_meta_title_sslcertificates'] = "SSL Certificates | Secure your website and give your visitors/clients confidence with validation";
$_LANG['freemium_meta_description_sslcertificates'] = "We provide a range of SSL Certificates to help secure your website and project your clients data.";
$_LANG['freemium_meta_tags_sslcertificates'] = "ssl";

// VPN (WHMCS Marketconnect page)

$_LANG['freemium_meta_title_vpn'] = "VPN - Protect your identity & secure your web browsing using our full-featured and IP masking VPN service";
$_LANG['freemium_meta_description_vpn'] = "We provide a high quality VPN service that comes packed with many features and our industry leading support.";
$_LANG['freemium_meta_tags_vpn'] = "vpn";

// Website Builder (WHMCS Marketconnect page)

$_LANG['freemium_meta_title_websitebuilder'] = "Create a website using our easy builder - no experience required";
$_LANG['freemium_meta_description_websitebuilder'] = "We provide a complete website builder that is easy to use and affordable";
$_LANG['freemium_meta_tags_websitebuilder'] = "website builder";

// Website Backup (WHMCS Marketconnect page)

$_LANG['freemium_meta_title_websitebackup'] = "Website Backup - Protect your website from viruses and hacking with automated backup & restore";
$_LANG['freemium_meta_description_websitebackup'] = "Our website backup service is the perfect solution to protect your website against viruses, malware and other threats.";
$_LANG['freemium_meta_tags_websitebackup'] = "backup, website backup";

// Website Security (WHMCS Marketconnect page)

$_LANG['freemium_meta_title_websitesecurity'] = "Website Security - Secure your website today";
$_LANG['freemium_meta_description_websitesecurity'] = "We provide a selection of website security services including malware detection & removal.";
$_LANG['freemium_meta_tags_websitesecurity'] = "website security, wordpress";

// Email Security (WHMCS Marketconnect page)

$_LANG['freemium_meta_title_emailsecurity'] = "Email Security - Protect your inbox from Spam & Malware!";
$_LANG['freemium_meta_description_emailsecurity'] = "Check out our Email Security services that protect both your outgoing and incoming mail from Spam and other security threats.";
$_LANG['freemium_meta_tags_emailsecurity'] = "email security";

// SEO Tools (WHMCS Marketconnect page)

$_LANG['freemium_meta_title_seotools'] = "SEO Report - Get useful insight into your website's SEO with this service from Marketgoo";
$_LANG['freemium_meta_description_seotools'] = "Our SEO Report service is a great way to learn about your website's search engine performance and know how to increase SEO performance.";
$_LANG['freemium_meta_tags_seotools'] = "seo tools";

// Professional Email (WHMCS Marketconnect page)

$_LANG['freemium_meta_title_professionalemail'] = "Professional email services";
$_LANG['freemium_meta_description_professionalemail'] = "Take email to the next level";
$_LANG['freemium_meta_tags_professionalemail'] = "professional email";

// Site Builder (WHMCS Marketconnect page)

$_LANG['freemium_meta_title_sitebuilder'] = "Simply and quick website builder";
$_LANG['freemium_meta_description_sitebuilder'] = "Make use of our affordable and simple to use website builder";
$_LANG['freemium_meta_tags_sitebuilder'] = "site builder";

// Xovinow (WHMCS Marketconnect page)

$_LANG['freemium_meta_title_xovinow'] = "XOVI NOW - SEO optimization &amp; reporting";
$_LANG['freemium_meta_description_xovinow'] = "Take your SEO game to a new level with XOVI NOW.";
$_LANG['freemium_meta_tags_xovinow'] = "xovinow, seo";

// Nordvpn (WHMCS Marketconnect page)

$_LANG['freemium_meta_title_nordvpn'] = "NordVPN - Protect your online privacy";
$_LANG['freemium_meta_description_nordvpn'] = "NordVPN provides one of the best VPN's on the market.";
$_LANG['freemium_meta_tags_nordvpn'] = "nordvpn, vpn, privacy";

// 360Monitoring (WHMCS Marketconnect page)

$_LANG['freemium_meta_title_360monitoring'] = "360Monitoring - Monitor your website";
$_LANG['freemium_meta_description_360monitoring'] = "360Monitoring - Monitor your website";
$_LANG['freemium_meta_tags_360monitoring'] = "360monitoring";

// Company

$_LANG['freemium_meta_title_company'] = "All you need to know about our web hosting &amp; domain registration company";
$_LANG['freemium_meta_description_company'] = "Where we come from, when we started &amp; why we started.";
$_LANG['freemium_meta_tags_company'] = "company, about us";

// Why Choose Us

$_LANG['freemium_meta_title_whychooseus'] = "The reasons why you should choose our company";
$_LANG['freemium_meta_description_whychooseus'] = "Here is 4 reasons why we are are the best hosting provider.";
$_LANG['freemium_meta_tags_whychooseus'] = "why choose us, why us, why choose our company";

// Testimonials

$_LANG['freemium_meta_title_testimonials'] = "We've compiled a list of testimonials from our customer's";
$_LANG['freemium_meta_description_testimonials'] = "Check out our collection of testimonials sent by our customer's.";
$_LANG['freemium_meta_tags_testimonials'] = "testimonials, customer reviews";

// Affiliate Program

$_LANG['freemium_meta_title_affiliateprogram'] = "Join our affiliate program and earn commissions on your sales!";
$_LANG['freemium_meta_description_affiliateprogram'] = "We offer a very professional web hosting affiliate program.";
$_LANG['freemium_meta_tags_affiliateprogram'] = "affiliate program, affiliates, web hosting affiliate program";

// Terms Of Service

$_LANG['freemium_meta_title_terms'] = "Terms Of Service - A document listing all of our terms";
$_LANG['freemium_meta_description_terms'] = "Please read our terms of service to see what our policies are.";
$_LANG['freemium_meta_tags_terms'] = "terms of service, terms, legal";

// Acceptable Usage Policy

$_LANG['freemium_meta_title_usage'] = "Acceptable Usage Policy - The usage policy you must accept before signing up";
$_LANG['freemium_meta_description_usage'] = "Please read our acceptable usage policy to see what our policies are.";
$_LANG['freemium_meta_tags_usage'] = "acceptable usage policy, usage, restrictions";

// Privacy Policy

$_LANG['freemium_meta_title_privacy'] = "Privacy Policy - Our policy regarding your privacy";
$_LANG['freemium_meta_description_privacy'] = "Please read our privacy policy to see what our policies are.";
$_LANG['freemium_meta_tags_privacy'] = "privacy policy";

// Addons

$_LANG['freemium_meta_title_addons'] = "WHMCS Templates | WordPress Themes | HTML Templates | Logo Design | Banner Design | Scripts";
$_LANG['freemium_meta_description_addons'] = "Premium website addons including web hosting templates for WHMCS, WordPress, Clientexec, WISECP &amp; HostBill.";
$_LANG['freemium_meta_tags_addons'] = "whmcs templates, WordPress themes, html templates, logo design, banner design";

// WHMCS Templates

$_LANG['freemium_meta_title_whmcstemplates'] = "WHMCS Templates - Professional WHMCS Themes for web hosting reseller businesses | Complete Solution";
$_LANG['freemium_meta_description_whmcstemplates'] = "Our WHMCS Templates allow you to launch your very own web hosting reseller business using the power of WHMCS.";
$_LANG['freemium_meta_tags_whmcstemplates'] = "whmcs templates, whmcs themes, responsive whmcs templates";

// WordPress Themes

$_LANG['freemium_meta_title_wordpressthemes'] = "WordPress Themes - Premium themes for the web hosting reseller business supporting the best software";
$_LANG['freemium_meta_description_wordpressthemes'] = "We provide the best WordPress web hosting themes with features including our options panel, shortcodes &amp; WHMCS, Blesta, WISECP, HostBill integration.";
$_LANG['freemium_meta_tags_wordpressthemes'] = "wordpress themes, web hosting wordpress themes, wordpress templates";

// HTML Templates

$_LANG['freemium_meta_title_htmltemplates'] = "HTML Templates - We provide high quality web hosting reseller HTML Templates with integrations for WHMCS, Blesta, Clientexec, WISECP &amp; HostBill.";
$_LANG['freemium_meta_description_htmltemplates'] = "Our responsive web hosting reseller HTML Templates come with many features, free support and pixel perfect integrations for WHMCS, Blesta, Clientexec, WISECP &amp; HostBill.";
$_LANG['freemium_meta_tags_htmltemplates'] = "html templates, html web hosting templates, responsive html templates";

// Blesta Templates

$_LANG['freemium_meta_title_blestatemplates'] = "Blesta Themes - We provide high quality themes for Blesta as WordPress Themes &amp; HTML Templates";
$_LANG['freemium_meta_description_blestatemplates'] = "Launch your Blesta based web hosting reseller business today using our feature-rich Blesta WordPress Themes or Blesta HTML Templates.";
$_LANG['freemium_meta_tags_blestatemplates'] = "bleata, blesta themes, blesta templates, blesta wordpress themes, blesta html templates";

// Clientexec Templates

$_LANG['freemium_meta_title_clientexectemplates'] = "Clientexec Themes - We provide high quality themes for Clientexec as WordPress Themes &amp; HTML Templates";
$_LANG['freemium_meta_description_clientexectemplates'] = "Launch your Clientexec based web hosting reseller business today using our feature-rich Clientexec WordPress Themes or Clientexec HTML Templates.";
$_LANG['freemium_meta_tags_clientexectemplates'] = "clientexec, clientexec themes, clientexec templates, clientexec wordpress themes, clientexec html templates";

// WISECP Templates

$_LANG['freemium_meta_title_wisecptemplates'] = "WISECP Themes - We provide high quality themes for WISECP as WordPress Themes &amp; HTML Templates";
$_LANG['freemium_meta_description_wisecptemplates'] = "Launch your WISECP based web hosting reseller business today using our feature-rich WISECP WordPress Themes or WISECP HTML Templates.";
$_LANG['freemium_meta_tags_wisecptemplates'] = "wisecp, wisecp themes, wisecp templates, wisecp wordpress themes, wisecp html templates";

// HostBill Templates

$_LANG['freemium_meta_title_hostbilltemplates'] = "HostBill Themes - We provide high quality themes for HostBill as WordPress Themes &amp; HTML Templates";
$_LANG['freemium_meta_description_hostbilltemplates'] = "Launch your HostBill based web hosting reseller business today using our feature-rich HostBill WordPress Themes or HostBill HTML Templates.";
$_LANG['freemium_meta_tags_hostbilltemplates'] = "hostbill, hostbill themes, hostbill templates, hostbill wordpress themes, hostbill html templates";

// Scripts

$_LANG['freemium_meta_title_scripts'] = "Scripts | Ready-made scripts to enhance your website including Cookie Law Script, Mega Menus &amp; More";
$_LANG['freemium_meta_description_scripts'] = "Our collection of ready to use HTML/CSS mega menus, features boxes and many scripts including our exclusive EU cookie law script.";
$_LANG['freemium_meta_tags_scripts'] = "html code, css menus, css tables, css feature boxes, eu cookie law";

// WHMCS Modules

$_LANG['freemium_meta_title_whmcsmodules'] = "WHMCS Modules - Exclusive WHMCS Modules to add functionality to your WHMCS based website";
$_LANG['freemium_meta_description_whmcsmodules'] = "We have developed a range of premium WHMCS Modules including Flex Mail, Affiliates Land Anywhere &amp; SEO Enhancer";
$_LANG['freemium_meta_tags_whmcsmodules'] = "whmcs modules, whmcs addons";

// Logo Design

$_LANG['freemium_meta_title_logodesign'] = "Logo design service - We design custom vector logos from scratch for businesses of all types | Premium logo design service";
$_LANG['freemium_meta_description_logodesign'] = "We design custom logos from scratch in vector and raster format for businesses of all types.";
$_LANG['freemium_meta_tags_logodesign'] = "logo design, vector logos, logo designer, custom logo design";

// Banner Design

$_LANG['freemium_meta_title_bannerdesign'] = "Custom Banner Design - High quality banner designs, animated .GIF &amp; static, bast portfolio!";
$_LANG['freemium_meta_description_bannerdesign'] = "We offer a very high quality and affordable banner design service.";
$_LANG['freemium_meta_tags_bannerdesign'] = "banner design, banner designer, animated banners";

// WHMCS Serivces

$_LANG['freemium_meta_title_whmcsservices'] = "WHMCS Integration - WHMCS Setup, Configuration And Integration Services Starting From $12! Web hosting business setup/startup services";
$_LANG['freemium_meta_description_whmcsservices'] = "Be sure to check out our popular whmcs services including whmcs setup, whmcs configuration & whmcs integration.";
$_LANG['freemium_meta_tags_whmcsservices'] = "whmcs services, whmcs, whmcs integration, whmcs configuration, whmcs security";

// WordPress Services

$_LANG['freemium_meta_title_wordpressservices'] = "Wordpress Services - Looking For Wordpress Service(s)? Look No Further! We Specialise In Wordpress Installation, Configuration & Integration";
$_LANG['freemium_meta_description_wordpressservices'] = "We Provide Multiple Wordpress Services To Businesses & Individuals At An Affordable Price. These Include Installation, Configuration and Integration!";
$_LANG['freemium_meta_tags_wordpressservices'] = "wordpress services, wordpress installation, wordpress integration";

// Blesta Services

$_LANG['freemium_meta_title_blestaservices'] = "Blesta Services - We provide reliable Blesta services including Blesta Installation &amp; Blesta Integration";
$_LANG['freemium_meta_description_blestaservices'] = "We provide reliable and manual Bleata services including installation and integration.";
$_LANG['freemium_meta_tags_blestaservices'] = "blesta services, blesta, blesta installation, blesta configuration";

// Clientexec Services

$_LANG['freemium_meta_title_clientexecservices'] = "Clientexec Services - We provide reliable Clientexec services including Clientexec Installation &amp; Clientexec Integration";
$_LANG['freemium_meta_description_clientexecservices'] = "We provide reliable and manual Bleata services including installation and integration.";
$_LANG['freemium_meta_tags_clientexecservices'] = "clientexec services, clientexec, clientexec installation, clientexec configuration";

// Support

$_LANG['freemium_meta_title_portal'] = "Support Portal - Everything you need to manage your service &amp; request support";
$_LANG['freemium_meta_description_portal'] = "Links to support &amp; announcements.";
$_LANG['freemium_meta_tags_portal'] = "support, portal";

// Contact

$_LANG['freemium_meta_title_contact'] = "Contact us for help with your web hosting or with any pre-sale questions.";
$_LANG['freemium_meta_description_contact'] = "Use our contact form as a reliable way to contact us for support.";
$_LANG['freemium_meta_tags_contact'] = "contact us, contact, contact form";

// Register

$_LANG['freemium_meta_title_register'] = "Register your free account with us";
$_LANG['freemium_meta_description_register'] = "Using your account you can easily create a new order and request support.";
$_LANG['freemium_meta_tags_register'] = "register, register account, free account";

// Submit Ticket

$_LANG['freemium_meta_title_submitticket'] = "Submit a new ticket with us";
$_LANG['freemium_meta_description_submitticket'] = "Submit a new ticket with us.";
$_LANG['freemium_meta_tags_submitticket'] = "ticket, ticket system, submit ticket";

// Support Tickets

$_LANG['freemium_meta_title_supporttickets'] = "View your existing tickets in our system";
$_LANG['freemium_meta_description_supporttickets'] = "Here you can view all of your existing tickets in our system and make a reply.";
$_LANG['freemium_meta_tags_supporttickets'] = "tickets, support tickets";

// Cart

$_LANG['freemium_meta_title_cart'] = "Create your new order with us";
$_LANG['freemium_meta_description_cart'] = "Use our order form to create your new hosting/domain order with us";
$_LANG['freemium_meta_tags_cart'] = "cart, checkout";

// Login

$_LANG['freemium_meta_title_login'] = "Login to manage your account";
$_LANG['freemium_meta_description_login'] = "Once logged-in you can view downloads, request support or easily create a new order.";
$_LANG['freemium_meta_tags_login'] = "manage account, account login";

// Knowledgebase

$_LANG['freemium_meta_title_knowledgebase'] = "View our complete list of tutorials & guides!";
$_LANG['freemium_meta_description_knowledgebase'] = "Our knowledgebase is a great resource for easy to access tutorials.";
$_LANG['freemium_meta_tags_knowledgebase'] = "knowledgebase, tutorials, guides";

// Downloads

$_LANG['freemium_meta_title_downloads'] = "We have a great selection of downloads";
$_LANG['freemium_meta_description_downloads'] = "Download a mix of software and ebooks to help you start your website.";
$_LANG['freemium_meta_tags_downloads'] = "downloads, download library";

// Announcements

$_LANG['freemium_meta_title_announcements'] = "View our announcements and latest news";
$_LANG['freemium_meta_description_announcements'] = "Here is where you'll find all of our announcements and news posts.";
$_LANG['freemium_meta_tags_announcements'] = "announcements, news";

// Server Staus

$_LANG['freemium_meta_title_serverstatus'] = "Check out the status of our servers";
$_LANG['freemium_meta_description_serverstatus'] = "View the status of our servers, allows you to easily check if our servers are online.";
$_LANG['freemium_meta_tags_serverstatus'] = "server status, servers";

// Network Issues

$_LANG['freemium_meta_title_networkissues'] = "Here is where we will post any issues with our network";
$_LANG['freemium_meta_description_networkissues'] = "View this page to instantly check any of our listed network issues.";
$_LANG['freemium_meta_tags_networkissues'] = "network issues, network";

?>