<?php
	
if (!defined("WHMCS"))
die("This file cannot be accessed directly");	

/*
	--------------
	
		This hook was developed by "Brian!" from the WHMCS community. On behalf of everyone at Zomex we would like to thank Brian for not only this script but also his time and dedication given to the WHMCS software. Reference: https://forum.whmcs.com/showthread.php?130402-If-statement-link-to-the-WHMCS-marketplace-connect-pages&p=521186
		
		This hook generates links for the WHMCS marketplace connect pages if enabled. These links are used in the WHMCS template menus.
		
	--------------	
*/

use Illuminate\Database\Capsule\Manager as Capsule;

if(Capsule::schema()->hasTable('tblmarketconnect_services')){	
function zomex_marketconnect_hook($vars)
{
    global $CONFIG;    
    $friendlyurl = $CONFIG['RouteUriPathMode'];
    
    if ($friendlyurl == 'acceptpathinfo') {
        $urlpath = 'index.php/store/';
    }
    elseif ($friendlyurl == 'rewrite') {
        $urlpath = 'store/';
    }
    elseif ($friendlyurl == 'basic') {
        $urlpath = 'index.php?rp=/store/';
    }
    
    $marketconnect = Capsule::table('tblmarketconnect_services')->where('status', '1')->get();
    
    if (count($marketconnect)) {

        foreach ($marketconnect as $service) {
	        
            if ($service->name == 'symantec') {
                $symantec = $urlpath.'ssl-certificates';
            }
            
            if ($service->name == 'sitelockvpn') {
	            $vpn = $urlpath.'vpn';
            }             	        

            if ($service->name == 'weebly') {
	            $weebly = $urlpath.'website-builder';
            }

            if ($service->name == 'codeguard') {
	            $codeguard = $urlpath.'codeguard';
            } 
            
            if ($service->name == 'sitelock') {
	            $sitelock = $urlpath.'sitelock';
            }              
	        
            if ($service->name == 'spamexperts') {
	            $spamexperts = $urlpath.'email-services';
            }    
            
            if ($service->name == 'marketgoo') {
	            $marketgoo = $urlpath.'marketgoo';
            } 
            
            if ($service->name == 'ox') {
	            $ox = $urlpath.'professional-email';
            }
            
            if ($service->name == 'sitebuilder') {
	            $sitebuilder = $urlpath.'site-builder';
            }
            
            if ($service->name == 'xovinow') {
	            $xovinow = $urlpath.'xovinow';
            } 
            
            if ($service->name == 'nordvpn') {
	            $nordvpn = $urlpath.'nordvpn';
            }
            
            if ($service->name == 'threesixtymonitoring') {
	            $threesixtymonitoring = $urlpath.'360monitoring';
            }                                                
                                              
        }
        
        return array("spamexperts" => $spamexperts, "symantec" => $symantec, "weebly" => $weebly, "sitelock" => $sitelock, "codeguard" => $codeguard, "vpn" => $vpn, "marketgoo" => $marketgoo, "ox" => $ox, "sitebuilder" => $sitebuilder, "xovinow" => $xovinow, "nordvpn" => $nordvpn, "360monitoring" => $threesixtymonitoring);
    }
	
}

	add_hook("ClientAreaPage", 1, "zomex_marketconnect_hook");
}	


/*
	--------------
	
		Obtain Product Group Details for Menu @ Zomex
		Written by brian! from the whmcs.community
		Email: whmcsbrian@gmail.com
		
	--------------	
*/

use WHMCS\Product\Group;

add_hook('ClientAreaPage', 1, function($vars) {
	$productgroups = Capsule::table('tblproductgroups')->where('hidden',0)->orderBy('order','asc')->select('id as gid')->get();
	$results = json_decode(json_encode($productgroups), true);
	foreach ($results as $key => $group) {
		$currentgroup = Group::findOrFail($group['gid']);
		$results[$key]['name'] = $currentgroup->getGroupName($group['gid']);
		$results[$key]['headline'] = $currentgroup->getHeadline($group['gid']);
		$results[$key]['tagline'] = $currentgroup->getTagline($group['gid']);
	}
	return array ("zomex_product_group_list" => $results);
});


/*
	--------------
	
		Fix language strings not being displayed on new /user/account pages.
		Written by brian! from the whmcs.community
		Email: whmcsbrian@gmail.com
		
	--------------	
*/


use WHMCS\Config\Setting;

function zomex_language_fix_hook($vars) {
	
	global $_LANG;
	$currentlanguage = $vars['language'];
	$dblanguage = Setting::getValue('Language');
	if (isset($vars['language']) && !empty($vars['language'])) {
		$templatelangname = $vars['language'];
	} elseif (isset($_SESSION['Language']) && !empty($_SESSION['Language'])) {
		$templatelangname = $_SESSION['Language'];
	} elseif (!empty($dblanguage)) {
		$templatelangname = $dblanguage;
	} else {
		$templatelangname = "english";
	}
	
	
/*
	--------------
	
		Updated by ictTech Support
		Found a semicolon (;) mistakenly placed inside the file_exists condition, which leads to a syntax error.
		Uncommented existing hook section
		
	--------------	
*/	
	
	if (file_exists(ROOTDIR . "/modules/addons/zomex_template_manager/lang/".strtolower($templatelangname).".php")) {
		include ROOTDIR . "/modules/addons/zomex_template_manager/lang/".strtolower($templatelangname).".php";
		return array("LANG" => $_LANG);
	}
}
add_hook("ClientAreaPage", 1, "zomex_language_fix_hook");