-- Update old credits for linking with Invoice, use relid field instead of description
UPDATE tblcredit SET relid = COALESCE(REGEXP_SUBSTR(TRIM(description), '(\\d+)$'), 0) WHERE relid = 0;

-- Add new mixpanel_tracking_enabled column to tbladmins
SET @query = IF ((SELECT COUNT(*) FROM information_schema.columns WHERE table_schema = database() AND TABLE_NAME = 'tbladmins' AND COLUMN_NAME = 'mixpanel_tracking_enabled') = 0, 'ALTER TABLE `tbladmins` ADD `mixpanel_tracking_enabled` TINYINT(1) NOT NULL DEFAULT 0 AFTER `user_preferences`', 'DO 0;');
PREPARE statement FROM @query;
EXECUTE statement;
DEALLOCATE PREPARE statement;
